/*
 * Decompiled with CFR 0.152.
 */
package HWE;

import Algorithms.MersenneTwisterFast;
import HWE.HWETools;
import Tool.ArrayTools;

public class MakeMultiAllele {
    public static void main(String[] args) {
        int seed = 0;
        int x = 10000000;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        double[] p = new double[]{0.3, 0.2, 0.1, 0.4};
        double[] pLow = new double[]{0.3, 0.2, 0.1};
        double[] pUp = new double[]{0.3, 0.2, 0.1};
    }

    public static int[][] MakeMultiDiploCountFreqSeq(double[] pLow, double[] pUp, int N, boolean NonZero, MersenneTwisterFast mz) {
        int k = pLow.length + 1;
        double sum = 0.0;
        double[] p = new double[k];
        int i = 0;
        while (i < k - 1) {
            p[i] = mz.nextDouble() * (pLow[i] - pUp[i]) + pLow[i];
            sum += p[i];
            ++i;
        }
        p[k - 1] = 1.0 - sum;
        int[][] ret = MakeMultiAllele.MakeMultiDiploCount(p, N, NonZero, mz);
        return ret;
    }

    public static int[][] MakeMultiDiploCount(double[] p, int N, boolean NonZero, MersenneTwisterFast mz) {
        int k = p.length;
        int kdip = k * (k + 1) / 2;
        int[] Allele = new int[2];
        int[][] ret = new int[kdip][3];
        double[] NormP = ArrayTools.NormarizeTable(p);
        NormP = ArrayTools.CumFreq(NormP);
        boolean iter = true;
        while (iter) {
            int j;
            int count1 = 0;
            int count2 = 0;
            int i = 0;
            while (i < kdip) {
                ret[i][0] = count1++;
                ret[i][1] = count2++;
                ret[i][2] = 0;
                if (count2 == k) {
                    count2 = count1;
                }
                ++i;
            }
            i = 0;
            while (i < N) {
                j = 0;
                while (j < Allele.length) {
                    double rand = mz.nextDouble();
                    Allele[j] = ArrayTools.DecideOrder(NormP, rand);
                    ++j;
                }
                int x = Math.min(Allele[0], Allele[1]);
                int y = Math.max(Allele[0], Allele[1]);
                int ord = k * x - x * (x - 1) / 2 + y - x;
                int[] nArray = ret[ord];
                nArray[2] = nArray[2] + 1;
                ++i;
            }
            if (NonZero) {
                iter = false;
                int[][] tmpAllele = HWETools.ChangeDiploToAllele(ret);
                j = 0;
                while (j < tmpAllele.length) {
                    if (tmpAllele[j][1] == 0) {
                        iter = true;
                    }
                    ++j;
                }
                continue;
            }
            iter = false;
        }
        return ret;
    }
}

