/*
 * Decompiled with CFR 0.152.
 */
package Algorithms;

public class CombinationGenerator {
    final int n;
    long x;

    public CombinationGenerator(int n, int k) {
        this.n = n;
        this.x = this.lowBit(k);
    }

    long lowBit(int n) {
        return (1L << n) - 1L;
    }

    public boolean next() {
        long smallest = this.x & -this.x;
        long ripple = this.x + smallest;
        long new_smallest = ripple & -ripple;
        long ones = (new_smallest / smallest >> 1) - 1L;
        this.x = ripple | ones;
        return (this.x & (this.lowBit(this.n) ^ 0xFFFFFFFFFFFFFFFFL)) == 0L;
    }

    public String toString() {
        String s = "";
        long y = this.x;
        int i = 1;
        while (i <= this.n) {
            if ((y & 1L) == 1L) {
                s = String.valueOf(s) + " " + i;
            }
            y >>>= 1;
            ++i;
        }
        return s;
    }

    public byte[] toByte() {
        byte[] rep = new byte[this.n];
        long y = this.x;
        int i = 0;
        while (i < this.n) {
            rep[i] = (y & 1L) == 1L ? (byte)1 : 0;
            y >>>= 1;
            ++i;
        }
        return rep;
    }

    public static void main(String[] args) {
        CombinationGenerator c = new CombinationGenerator(10, 5);
        boolean count = false;
        do {
            int l = c.toByte().length;
            int i = 0;
            while (i < l) {
                System.out.print(c.toByte()[i]);
                ++i;
            }
            System.out.println("\t" + c);
        } while (c.next());
    }
}

