#!	/usr/bin/perl	-w

=head1	header

	###########################################################
	#  
	#  This script exchange reference haplotype data into PLINK ped format
	#  
	#  perl make1000GHapToPed.pl Chr22_Ref_Ex
	#  
	#  Input : Chr22_Ref_Ex.hap
	#  Output : Chr22_Ref_Ex.ped
	#  
	#  1KG haplotype data is available from http://www.sph.umich.edu/csg/abecasis/MACH/download/
	#  
	#  Any questions to Yukinori Okada (http://plaza.umin.ac.jp/~yokada/datasource/software.htm   yokada@broadinstitute.org)

=cut



&main(@ARGV);
exit;

=head1	main
	
=cut

sub	main(@){
	my ($input_head)=@_;
	my $hap = $input_head.".hap";
	my $ped = $input_head.".ped";

		my $dip = 0;
		$numHap = 0;
		open (INPUT, "$hap");
		open (OUT, "> $ped");
		while(<INPUT>){
			chomp;
			my @inline = split(/ /);
			my @inline2 = split(//, $inline[2]);
			
			for(my $i=0;$i<@inline2;$i++){
				
				if ($i==0 && $dip==0) {
					print OUT $inline[0]."\t".$inline[0]."\t0\t0\t0\t1";
				}
				
				if ($dip == 0) {
					$geno[$i] = $inline2[$i];
				} else {
					my @tmp = sort($inline2[$i], $geno[$i]);
					$geno[$i] = $tmp[0]." ".$tmp[1];
					print OUT "\t".$geno[$i];
				}
			}
			
			if ($dip==0) {
				$dip = 1;
			} else {
				$dip = 0;
				print OUT "\n";
			}
			$numHap++;
		
		}
		close INPUT;
		

}
