/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLDdiff;

import Tool.ArrayTools;
import Tool.PlotTools;
import Tool.Quicksort;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class HaplotypeManageTool {
    public static void main(String[] args) {
        String[] HaplotypeSt = new String[]{"001", "100", "101", "011", "110", "000", "000", "110", "110", "111"};
        int numSNP = HaplotypeSt[0].length();
        int numHaplo = HaplotypeSt.length;
        long[] HaplotypeBN = HaplotypeManageTool.GetHaplotypeBN(HaplotypeSt);
        long[][] HaplotypeBNsum = HaplotypeManageTool.SummarizeHaplotypeBN(HaplotypeBN);
        double[] SNPFreq = HaplotypeManageTool.CalcSNPFreq(HaplotypeBNsum, numSNP, numHaplo);
        double[] Epsi = HaplotypeManageTool.CalcHaploEnt(HaplotypeSt);
        PlotTools.Array(Epsi);
    }

    public static double[] CalHaploEntDiff(String[] HaplotypeCase, String[] HaplotypeControl) throws Exception {
        double numSNP = HaplotypeCase[0].length();
        double numHaploCase = HaplotypeCase.length;
        double numHaploControl = HaplotypeCase.length;
        double df = Math.pow(2.0, numSNP) - (numSNP + 1.0);
        NormalDistributionImpl norm = new NormalDistributionImpl();
        FDistributionImpl fd = new FDistributionImpl(df, df);
        double[] StatCase = HaplotypeManageTool.CalcHaploEnt(HaplotypeCase);
        double[] StatControl = HaplotypeManageTool.CalcHaploEnt(HaplotypeControl);
        int numStat = StatCase.length;
        double DeltaDeltaS = StatCase[2] - StatControl[2];
        double DeltaDeltaStat = (DeltaDeltaS - df / 2.0 * (1.0 / numHaploCase - 1.0 / numHaploControl)) / Math.pow(df / 2.0 * (1.0 / Math.pow(numHaploCase, 2.0) + 1.0 / Math.pow(numHaploControl, 2.0)), 0.5);
        double RatioDeltaS = StatCase[2] / StatControl[2];
        double RatioDeltaStat = numHaploCase / numHaploControl * StatCase[2] / StatControl[2];
        double[] ret = new double[numStat * 2 + 6];
        int i = 0;
        while (i < numStat) {
            ret[i] = StatCase[i];
            ret[i + numStat] = StatControl[i];
            ++i;
        }
        ret[numStat * 2] = DeltaDeltaS;
        ret[numStat * 2 + 1] = DeltaDeltaStat;
        ret[numStat * 2 + 2] = 1.0 - norm.cumulativeProbability(DeltaDeltaStat);
        ret[numStat * 2 + 3] = RatioDeltaS;
        ret[numStat * 2 + 4] = RatioDeltaStat;
        ret[numStat * 2 + 5] = 1.0 - fd.cumulativeProbability(RatioDeltaStat);
        return ret;
    }

    public static double[] CalcHaploEnt(String[] HaplotypeSt) {
        double[] ret = new double[6];
        int numSNP = HaplotypeSt[0].length();
        int numHaplo = HaplotypeSt.length;
        long[] HaplotypeBN = HaplotypeManageTool.GetHaplotypeBN(HaplotypeSt);
        long[][] HaplotypeBNsum = HaplotypeManageTool.SummarizeHaplotypeBN(HaplotypeBN);
        double[] SNPFreq = HaplotypeManageTool.CalcSNPFreq(HaplotypeBNsum, numSNP, numHaplo);
        double EntObs = HaplotypeManageTool.CalcHaploEntObs(HaplotypeBNsum, numHaplo);
        double EntExp = HaplotypeManageTool.CalcHaploEntExp(SNPFreq);
        double DeltaS = EntExp - EntObs;
        double DeltaStat = 2.0 * (double)numHaplo * DeltaS;
        double Epsiron = (EntExp - EntObs) / EntExp;
        double EpsironPrime = Epsiron * (double)numSNP / (double)(numSNP - 1);
        ret[0] = EntObs;
        ret[1] = EntExp;
        ret[2] = DeltaS;
        ret[3] = DeltaStat;
        ret[4] = Epsiron;
        ret[5] = EpsironPrime;
        return ret;
    }

    public static double CalcHaploEntExp(double[] SNPFreq) {
        double ret = 0.0;
        int numSNP = SNPFreq.length;
        long i = 0L;
        while (i < (long)Math.pow(2.0, numSNP)) {
            String BN = Long.toBinaryString(i);
            int lenBN = BN.length();
            String BNfull = "";
            int j = 0;
            while (j < numSNP - lenBN) {
                BNfull = String.valueOf(BNfull) + "0";
                ++j;
            }
            j = 0;
            while (j < lenBN) {
                BNfull = String.valueOf(BNfull) + BN.substring(j, j + 1);
                ++j;
            }
            double Freq = 1.0;
            int j2 = 0;
            while (j2 < numSNP) {
                int Allele = Integer.parseInt(BNfull.substring(j2, j2 + 1));
                Freq = Allele == 1 ? (Freq *= SNPFreq[j2]) : (Freq *= 1.0 - SNPFreq[j2]);
                ++j2;
            }
            ret -= Freq * Math.log(Freq);
            ++i;
        }
        return ret;
    }

    public static double CalcHaploEntObs(long[][] HaplotypeBNsum, int numHaplo) {
        double ret = 0.0;
        int i = 0;
        while (i < HaplotypeBNsum.length) {
            double Freq = (double)HaplotypeBNsum[i][1] / (double)numHaplo;
            ret -= Freq * Math.log(Freq);
            ++i;
        }
        return ret;
    }

    public static double[] CalcSNPFreq(long[][] HaplotypeBNsum, int numSNP, int numHaplo) {
        double[] ret = new double[numSNP];
        ArrayTools.InitializeArray1(ret);
        int i = 0;
        while (i < HaplotypeBNsum.length) {
            String BN = Long.toBinaryString(HaplotypeBNsum[i][0]);
            int lenBN = BN.length();
            String BNfull = "";
            int j = 0;
            while (j < numSNP - lenBN) {
                BNfull = String.valueOf(BNfull) + "0";
                ++j;
            }
            j = 0;
            while (j < lenBN) {
                BNfull = String.valueOf(BNfull) + BN.substring(j, j + 1);
                ++j;
            }
            j = 0;
            while (j < numSNP) {
                int Allele = Integer.parseInt(BNfull.substring(j, j + 1));
                int n = j++;
                ret[n] = ret[n] + (double)Allele / (double)numHaplo * (double)HaplotypeBNsum[i][1];
            }
            ++i;
        }
        return ret;
    }

    public static long[][] SummarizeHaplotypeBN(long[] HaplotypeBN) {
        int counter = 0;
        int numHaplo = HaplotypeBN.length;
        long prev = -1L;
        long[] Array = ArrayTools.CopyArray1(HaplotypeBN);
        Quicksort.sortLong(Array);
        int i = 0;
        while (i < numHaplo) {
            if (Array[i] != prev) {
                prev = Array[i];
                ++counter;
            }
            ++i;
        }
        long[][] ret = new long[counter][2];
        counter = 0;
        prev = -1L;
        int i2 = 0;
        while (i2 < numHaplo) {
            if (Array[i2] != prev) {
                prev = Array[i2];
                ret[++counter - 1][0] = Array[i2];
                ret[counter - 1][1] = 1L;
            } else {
                long[] lArray = ret[counter - 1];
                lArray[1] = lArray[1] + 1L;
            }
            ++i2;
        }
        return ret;
    }

    public static long[] GetHaplotypeBN(String[] Haplotype) {
        int numSNP = Haplotype[0].length();
        int numHaplo = Haplotype.length;
        long[] ret = new long[numHaplo];
        int i = 0;
        while (i < numHaplo) {
            ret[i] = 0L;
            int j = 0;
            while (j < numSNP) {
                int n = i;
                ret[n] = ret[n] + (long)Math.pow(2.0, numSNP - j - 1) * Long.parseLong(Haplotype[i].substring(j, j + 1));
                ++j;
            }
            ++i;
        }
        return ret;
    }
}

