/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLD;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import multiSNPLD.HaploTools;
import multiSNPLD.MultiMarkerLD;
import multiSNPLD.MultiMarkerLDEnt;
import multiSNPLD.PairwiseAndMultiple;
import multiSNPLD.SummarizeHaplotypeAll;

public class multiSNPLDforHaploData {
    public static void main(String[] args) {
        int nslength;
        int nsMin = 2;
        int nsMax = 5;
        int repeat = 1000;
        int seedgiven = 0;
        int elem1 = 0;
        int elem2 = 1;
        int testtype = 2;
        int position = 0;
        int pairlength = 1;
        String inputfile = "test_haplo_1";
        String out = "";
        String outSum = "";
        boolean entropy = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-MinSNP")) {
                nsMin = Integer.parseInt(args[i + 1]);
            }
            if (nsMin < 2) {
                nsMin = 2;
            }
            if (args[i].equals("-MaxSNP")) {
                nsMax = Integer.parseInt(args[i + 1]);
            }
            if (nsMax <= nsMin) {
                nsMax = nsMin;
            }
            if (args[i].equals("-rep")) {
                repeat = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-type")) {
                testtype = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-ent")) {
                entropy = true;
            }
            ++i;
        }
        if (nsMax <= 10) {
            nslength = nsMax - nsMin + 1;
        } else {
            nsMin = 2;
            nslength = 9 + (int)Math.floor((double)(nsMax - 10) / 10.0);
        }
        if (testtype == 0) {
            nsMin = 0;
            nsMax = 0;
            nslength = 1;
        } else if (testtype == 3) {
            nsMin = 2;
            nsMax = 2;
            nslength = 1;
        } else if (testtype == 4) {
            nsMin = 2;
            nsMax = 2;
            nslength = 1;
        } else if (testtype == 5) {
            nsMin = nsMax;
            nslength = 1;
        }
        int[] ns = new int[nslength];
        int i2 = 0;
        while (i2 < ns.length) {
            ns[i2] = i2 <= 8 ? nsMin + i2 : ns[i2 - 1] + 10;
            ++i2;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        String outfileMain = String.valueOf(inputfile) + "_multiLD_result" + ".txt";
        String outfileLog = String.valueOf(inputfile) + "_multiLD_log.txt";
        String outfileSum = String.valueOf(inputfile) + "_multiLD_summary.txt";
        inputfile = String.valueOf(inputfile) + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileMain));
            bw[1] = new BufferedWriter(new FileWriter(outfileLog));
            bw[2] = new BufferedWriter(new FileWriter(outfileSum));
            byte[][] data = FileTools.readDatFileIOStringSPACEbyte(inputfile);
            System.out.println(String.valueOf(data.length) + ", " + data[0].length);
            int NumHaplo = data.length;
            int NumSNP = data[0].length;
            if (nsMax >= NumSNP) {
                nsMax = NumSNP;
            }
            if (testtype == 1) {
                repeat = NumSNP - 1;
            } else if (testtype == 0) {
                ns[0] = NumSNP;
                repeat = 1;
            } else if (testtype != 2) {
                if (testtype == 3) {
                    ns[0] = 2;
                    pairlength = repeat = NumSNP * (NumSNP - 1) / 2;
                } else if (testtype == 4) {
                    ns[0] = NumSNP;
                    repeat = 1;
                    nsMax = NumSNP;
                } else if (testtype == 5) {
                    ns[0] = nsMax;
                }
            }
            int[][] PairwiseSNPs = HaploTools.Pairwise(nsMax);
            out = "MultiSNPLD trial for:\t" + inputfile + "\nNumber_of_Haplotypes:\t" + NumHaplo + "\nNumber_of_SNPs:\t" + NumSNP + "\nBinary_code:\t" + elem1 + "\t" + elem2 + "\nTestType:\t" + testtype + "\nMinimum_SNPs_forCalc:\t" + nsMin + "\nMaximum_SNPs_forCalc:\t" + nsMax + "\nRepeat_times\t" + repeat + "\n";
            FileTools.out3File(bw[1], out);
            if (testtype == 3 || testtype == 4 || testtype == 5) {
                out = "repeat\tposi1\tposi2\t";
                outSum = entropy ? "repeat\trk\tr2mean\tr2sd\tchi2\tEpsiron\tEpsiron'\n" : "repeat\trk\tr2mean\tr2sd\n";
            } else {
                out = "repeat\tposition\t";
            }
            int i3 = 0;
            while (i3 < ns.length) {
                out = String.valueOf(out) + ns[i3] + "\t";
                ++i3;
            }
            out = String.valueOf(out) + "\n";
            FileTools.out3File(bw[0], out);
            FileTools.out3File(bw[2], outSum);
            bw[1].close();
            double LD = 0.0;
            double Epsi = 0.0;
            double EpsiP = 0.0;
            double chi2 = 0.0;
            int i4 = 0;
            while (i4 < repeat) {
                if (testtype == 1) {
                    position = i4;
                    out = String.valueOf(i4) + "\t" + position + "\t";
                } else if (testtype == 2) {
                    position = (int)Math.floor(mz.nextDouble() * (double)(NumSNP - nsMax + 1));
                    out = String.valueOf(i4) + "\t" + position + "\t";
                } else if (testtype == 0) {
                    position = 0;
                    out = String.valueOf(i4) + "\t" + position + "\t";
                } else if (testtype == 3) {
                    out = String.valueOf(i4) + "\t" + PairwiseSNPs[i4][0] + "\t" + PairwiseSNPs[i4][1] + "\t";
                } else if (testtype == 4) {
                    position = 0;
                    out = "";
                    outSum = String.valueOf(i4) + "\t";
                } else if (testtype == 5) {
                    position = (int)Math.floor(mz.nextDouble() * (double)(NumSNP - nsMax + 1));
                    out = "";
                    outSum = String.valueOf(i4) + "\t";
                }
                int j = 0;
                while (j < ns.length) {
                    if (position + ns[j] > NumSNP) {
                        LD = -99.0;
                        out = String.valueOf(out) + LD + "\t";
                        entropy = true;
                        if (true) {
                            out = String.valueOf(out) + "-99\t-99\t";
                        }
                    } else {
                        int[] posilabel = new int[ns[j]];
                        if (testtype == 3) {
                            posilabel[0] = PairwiseSNPs[i4][0];
                            posilabel[1] = PairwiseSNPs[i4][1];
                        } else {
                            int k = 0;
                            while (k < ns[j]) {
                                posilabel[k] = position + k;
                                ++k;
                            }
                        }
                        int[][] cutdata = HaploTools.CutHaplotype(data, posilabel);
                        if (testtype <= 3) {
                            SummarizeHaplotypeAll Haplo = new SummarizeHaplotypeAll(cutdata, elem1, elem2);
                            MultiMarkerLD multiLD = new MultiMarkerLD(Haplo.SumHaplo, Haplo.SumFreq);
                            LD = multiLD.chi;
                            out = String.valueOf(out) + LD + "\t";
                            if (entropy) {
                                MultiMarkerLDEnt multiLDEnt = new MultiMarkerLDEnt(Haplo.SumHaplo, Haplo.SumFreq);
                                Epsi = multiLDEnt.epsi;
                                EpsiP = multiLDEnt.epsiP;
                                chi2 = multiLDEnt.chi2;
                                out = String.valueOf(out) + Math.log10(chi2) + "\t" + Epsi + "\t" + EpsiP + "\t";
                            }
                        } else if (testtype == 4 || testtype == 5) {
                            PairwiseAndMultiple PairMulti = new PairwiseAndMultiple(cutdata, elem1, elem2);
                            int[][] Pairwise = PairMulti.PairwiseSNPs;
                            double[] r2 = PairMulti.r2;
                            double r2mean = PairMulti.r2mean;
                            double r2sd = PairMulti.r2sd;
                            double rk = PairMulti.rk;
                            if (entropy) {
                                Epsi = PairMulti.epsi;
                                EpsiP = PairMulti.epsiP;
                                chi2 = PairMulti.chi2;
                            }
                            int k = 0;
                            while (k < r2.length) {
                                out = String.valueOf(out) + i4 + "\t" + (Pairwise[k][0] + position) + "\t" + (Pairwise[k][1] + position) + "\t" + r2[k] + "\n";
                                ++k;
                            }
                            outSum = entropy ? String.valueOf(outSum) + rk + "\t" + r2mean + "\t" + r2sd + "\t" + Math.log(chi2) + "\t" + Epsi + "\t" + EpsiP + "\n" : String.valueOf(outSum) + rk + "\t" + r2mean + "\t" + r2sd + "\n";
                        }
                    }
                    ++j;
                }
                if (testtype <= 3) {
                    out = String.valueOf(out) + "\n";
                }
                FileTools.out3File(bw[0], out);
                FileTools.out3File(bw[2], outSum);
                ++i4;
            }
            bw[0].close();
            bw[2].close();
            if (testtype != 4 && testtype != 5) {
                FileTools.FileDelete(outfileSum);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

