/*
 * Decompiled with CFR 0.152.
 */
package WorksFromRY;

import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.FDistributionImpl;

public class LinearRegression {
    public int N;
    public double[] df;
    public double[] SumSq;
    public double[] MeanSq;
    public double f;
    public double p;
    public double rPearson;
    public double[] eqcof;

    public static void main(String[] args) {
        int N = 100;
        double[] x = new double[N];
        double[] y = new double[N];
        int i = 0;
        while (i < x.length) {
            x[i] = Math.random();
            y[i] = Math.random();
            ++i;
        }
        i = 0;
        while (i < x.length) {
            System.out.println(String.valueOf(x[i]) + "\t" + y[i]);
            ++i;
        }
        double avx = LinearRegression.mean(x);
        double avy = LinearRegression.mean(y);
        System.out.println("avx\t" + avx + "\tavy\t" + avy);
        double residx = LinearRegression.sxx(x);
        double residy = LinearRegression.sxx(y);
        System.out.println("residx\t" + residx + "\tresidy\t" + residy);
        double vx = LinearRegression.vx(x);
        double vy = LinearRegression.vx(y);
        System.out.println("vx\t" + vx + "\tvy\t" + vy);
        double sxy = LinearRegression.sxy(x, y);
        System.out.println("sxy\t" + sxy);
        double rPearson = LinearRegression.rPearson(x, y);
        System.out.println("rPearson\t" + rPearson);
        String st = LinearRegression.StringLinearRegression(x, y);
        System.out.println(st);
        double tss = LinearRegression.sxx(y);
        double ess = LinearRegression.ess(x, y);
        double ssr = LinearRegression.ssr(x, y);
        System.out.println("tss\t" + tss + "\tess\t" + ess + "\tssr\t" + ssr);
        double s2xy = LinearRegression.s2xy(x, y);
        double fstat = LinearRegression.fstat(x, y);
        System.out.println("s2xy\t" + s2xy + "\tfstat\t" + fstat);
        double ftestp = LinearRegression.ftestLinReg(x, y);
        System.out.println("ftestP\t" + ftestp);
        System.out.println("----------------------\n\n");
        LinearRegression lr = new LinearRegression(y, x);
        lr.PrintLinReg("\t", "\n");
    }

    public LinearRegression(double[] y, double[] x) {
        this.N = x.length;
        this.df = new double[3];
        this.SumSq = new double[3];
        this.MeanSq = new double[2];
        this.eqcof = new double[2];
        this.df[0] = 1.0;
        this.df[1] = this.N - 2;
        this.df[2] = this.N - 1;
        this.SumSq[0] = LinearRegression.ssr(x, y);
        this.SumSq[1] = LinearRegression.ess(x, y);
        this.SumSq[2] = LinearRegression.sxx(y);
        this.MeanSq[0] = this.SumSq[0];
        this.MeanSq[1] = LinearRegression.s2xy(x, y);
        this.f = LinearRegression.fstat(x, y);
        this.p = LinearRegression.ftestLinReg(x, y);
        this.rPearson = LinearRegression.rPearson(x, y);
        this.eqcof = LinearRegression.linearRegression(x, y);
    }

    public void PrintLinReg(String sep1, String sep2) {
        String ret = this.StringLinReg(sep1, sep2);
        System.out.println(ret);
    }

    public String StringLinReg(String sep1, String sep2) {
        String ret = "Linear Regression Equation" + sep1;
        ret = String.valueOf(ret) + "y=" + this.eqcof[0] + "*x+" + this.eqcof[1] + sep2;
        ret = String.valueOf(ret) + "Pearson's r" + sep1 + this.rPearson + sep2;
        ret = String.valueOf(ret) + "Ftest" + sep2;
        ret = String.valueOf(ret) + "df" + sep1;
        ret = String.valueOf(ret) + this.df[0] + sep1 + this.df[1] + sep1 + this.df[2] + sep2;
        ret = String.valueOf(ret) + "SumSq" + sep1 + this.SumSq[0] + sep1 + this.SumSq[1] + sep1 + this.SumSq[2] + sep2;
        ret = String.valueOf(ret) + "MeanSq" + sep1 + this.MeanSq[0] + sep1 + this.MeanSq[1] + sep2;
        ret = String.valueOf(ret) + "Fstat" + sep1 + this.f + sep2;
        ret = String.valueOf(ret) + "p" + sep1 + this.p + sep2;
        return ret;
    }

    public static double sum(double[] x) {
        double ret = 0.0;
        int i = 0;
        while (i < x.length) {
            ret += x[i];
            ++i;
        }
        return ret;
    }

    public static double mean(double[] x) {
        double ret = 0.0;
        if (x.length == 0) {
            ret = -9999.0;
        } else {
            ret = LinearRegression.sum(x);
            ret /= (double)x.length;
        }
        return ret;
    }

    public static double sxx(double[] x) {
        double avx = LinearRegression.mean(x);
        double ret = 0.0;
        int i = 0;
        while (i < x.length) {
            ret += (x[i] - avx) * (x[i] - avx);
            ++i;
        }
        return ret;
    }

    public static double vx(double[] x) {
        double ret = LinearRegression.sxx(x);
        return ret /= (double)(x.length - 1);
    }

    public static double sxy(double[] x, double[] y) {
        double avx = LinearRegression.mean(x);
        double avy = LinearRegression.mean(y);
        double ret = 0.0;
        int i = 0;
        while (i < x.length) {
            ret += (x[i] - avx) * (y[i] - avy);
            ++i;
        }
        return ret;
    }

    public static double rPearson(double[] x, double[] y) {
        double ret = LinearRegression.sxy(x, y) / Math.sqrt(LinearRegression.sxx(x) * LinearRegression.sxx(y));
        return ret;
    }

    public static double[] linearRegression(double[] x, double[] y) {
        double[] ret;
        ret = new double[]{LinearRegression.sxy(x, y) / LinearRegression.sxx(x), LinearRegression.mean(y) - ret[0] * LinearRegression.mean(x)};
        return ret;
    }

    public static String StringLinearRegression(double[] x, double[] y) {
        double[] tmp = LinearRegression.linearRegression(x, y);
        String ret = "y=" + tmp[0] + "*x+" + tmp[1];
        return ret;
    }

    public static double ess(double[] x, double[] y) {
        double[] linreg = LinearRegression.linearRegression(x, y);
        double ret = 0.0;
        int i = 0;
        while (i < y.length) {
            ret += (y[i] - (linreg[0] * x[i] + linreg[1])) * (y[i] - (linreg[0] * x[i] + linreg[1]));
            ++i;
        }
        return ret;
    }

    public static double ssr(double[] x, double[] y) {
        double[] linreg = LinearRegression.linearRegression(x, y);
        double avy = LinearRegression.mean(y);
        double ret = 0.0;
        int i = 0;
        while (i < y.length) {
            ret += (linreg[0] * x[i] + linreg[1] - avy) * (linreg[0] * x[i] + linreg[1] - avy);
            ++i;
        }
        return ret;
    }

    public static double s2xy(double[] x, double[] y) {
        double ret = LinearRegression.ess(x, y) / (double)(x.length - 2);
        return ret;
    }

    public static double fstat(double[] x, double[] y) {
        double ret = LinearRegression.ssr(x, y) / LinearRegression.s2xy(x, y);
        return ret;
    }

    public static double ftestLinReg(double[] x, double[] y) {
        double fstat = LinearRegression.fstat(x, y);
        double[] df = new double[]{1.0, (double)x.length - 2.0};
        FDistributionImpl fd = new FDistributionImpl(df[0], df[1]);
        double ret = 0.0;
        try {
            ret = 1.0 - fd.cumulativeProbability(fstat);
        }
        catch (MathException mathException) {
            // empty catch block
        }
        return ret;
    }
}

