/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Tool.GenoTools;
import Tool.PlotTools;
import Tool.Quicksort;
import Tool.RegressTools;
import Tool.Tools;

public class RankTools {
    public static void main(String[] args) {
        double[] array1 = new double[]{0.5, 1.0, 3.0, 0.2, 10.0, 5.0, 6.0, -1.0, -1.0, 2.0, 5.0, 4.0, 2.0, 2.0, 0.2};
        byte[] byArray = new byte[15];
        byArray[1] = 1;
        byArray[2] = 2;
        byArray[4] = 1;
        byArray[5] = 2;
        byArray[6] = -1;
        byArray[9] = 1;
        byArray[10] = 1;
        byArray[11] = 1;
        byArray[13] = 2;
        byte[] array2 = byArray;
        double[][] tmp = GenoTools.PhenotypeByGenotype(array2, array1, 3);
        double[] array3 = new double[]{56.0, 60.0, 66.0, 74.0, 68.0, 77.0, 83.0, 70.0, 88.0, 91.0, 95.0};
        byte[] byArray2 = new byte[11];
        byArray2[4] = 1;
        byArray2[5] = 1;
        byArray2[6] = 1;
        byArray2[7] = 2;
        byArray2[8] = 2;
        byArray2[9] = 2;
        byArray2[10] = 2;
        byte[] array4 = byArray2;
        double[][] tmp2 = GenoTools.PhenotypeByGenotype(array4, array3, 3);
        double[] array5 = new double[]{1.0, 4.0, 6.0, 2.0, 3.0, 2.0, 5.0, 1.0, 6.0, 2.0, 3.0, 4.0};
        byte[] byArray3 = new byte[12];
        byArray3[3] = 1;
        byArray3[4] = 1;
        byArray3[5] = 1;
        byArray3[6] = 1;
        byArray3[7] = 2;
        byArray3[8] = 2;
        byArray3[9] = 2;
        byArray3[10] = 2;
        byArray3[11] = 2;
        byte[] array6 = byArray3;
        double[] array7 = new double[]{17.0, 10.0, 20.0, 9.0, 13.0, 14.0, 17.0, 16.0, 19.0, 21.0, 19.0, 19.0, 19.0, 15.0, 13.0, 16.0, 15.0, 10.0};
        byte[] byArray4 = new byte[18];
        byArray4[6] = 1;
        byArray4[7] = 1;
        byArray4[8] = 1;
        byArray4[9] = 1;
        byArray4[10] = 1;
        byArray4[11] = 1;
        byArray4[12] = 2;
        byArray4[13] = 2;
        byArray4[14] = 2;
        byArray4[15] = 2;
        byArray4[16] = 2;
        byArray4[17] = 2;
        byte[] array8 = byArray4;
        double[] array9 = new double[]{15.0, 8.0, 13.0, 17.0, 16.0, 10.0, 16.0, 16.0, 18.0, 17.0, 19.0, 18.0, 18.0, 14.0, 11.0, 22.0, 22.0, 19.0, 17.0};
        byte[] byArray5 = new byte[19];
        byArray5[6] = 1;
        byArray5[7] = 1;
        byArray5[8] = 1;
        byArray5[9] = 1;
        byArray5[10] = 1;
        byArray5[11] = 1;
        byArray5[12] = 2;
        byArray5[13] = 2;
        byArray5[14] = 2;
        byArray5[15] = 2;
        byArray5[16] = 2;
        byArray5[17] = 2;
        byArray5[18] = 2;
        byte[] array10 = byArray5;
        double[] array11 = new double[]{192.0, 256.0, 166.0, 122.0, 202.0, 164.0, 248.0, 264.0, 270.0, 230.0, 224.0, 298.0, 332.0, 294.0};
        byte[] byArray6 = new byte[14];
        byArray6[5] = 1;
        byArray6[6] = 1;
        byArray6[7] = 1;
        byArray6[8] = 1;
        byArray6[9] = 1;
        byArray6[10] = 2;
        byArray6[11] = 2;
        byArray6[12] = 2;
        byArray6[13] = 2;
        byte[] array12 = byArray6;
        double[] array13 = new double[]{21.0, 14.5, 12.2, 9.0, 7.2, 6.8, 6.7, 5.9, 5.5, 4.7, 10.5, 7.0, 6.5, 5.8, 4.8, 11.4, 8.9, 8.0, 6.6, 6.4, 5.7, 5.4, 8.2, 6.9, 5.3, 5.2, 4.6, 4.4, 8.7, 8.5, 7.7, 6.3};
        byte[] byArray7 = new byte[32];
        byArray7[10] = 1;
        byArray7[11] = 1;
        byArray7[12] = 1;
        byArray7[13] = 1;
        byArray7[14] = 1;
        byArray7[15] = 2;
        byArray7[16] = 2;
        byArray7[17] = 2;
        byArray7[18] = 2;
        byArray7[19] = 2;
        byArray7[20] = 2;
        byArray7[21] = 2;
        byArray7[22] = 3;
        byArray7[23] = 3;
        byArray7[24] = 3;
        byArray7[25] = 3;
        byArray7[26] = 3;
        byArray7[27] = 3;
        byArray7[28] = 4;
        byArray7[29] = 4;
        byArray7[30] = 4;
        byArray7[31] = 4;
        byte[] array14 = byArray7;
        double[] array15 = new double[]{83.0, 91.0, 94.0, 89.0, 89.0, 96.0, 91.0, 92.0, 90.0, 91.0, 90.0, 81.0, 83.0, 84.0, 83.0, 88.0, 91.0, 89.0, 84.0, 101.0, 100.0, 91.0, 93.0, 96.0, 95.0, 94.0, 78.0, 82.0, 81.0, 77.0, 79.0, 81.0, 80.0, 81.0};
        byte[] byArray8 = new byte[34];
        byArray8[9] = 1;
        byArray8[10] = 1;
        byArray8[11] = 1;
        byArray8[12] = 1;
        byArray8[13] = 1;
        byArray8[14] = 1;
        byArray8[15] = 1;
        byArray8[16] = 1;
        byArray8[17] = 1;
        byArray8[18] = 1;
        byArray8[19] = 2;
        byArray8[20] = 2;
        byArray8[21] = 2;
        byArray8[22] = 2;
        byArray8[23] = 2;
        byArray8[24] = 2;
        byArray8[25] = 2;
        byArray8[26] = 3;
        byArray8[27] = 3;
        byArray8[28] = 3;
        byArray8[29] = 3;
        byArray8[30] = 3;
        byArray8[31] = 3;
        byArray8[32] = 3;
        byArray8[33] = 3;
        byte[] array16 = byArray8;
        double[] array17 = new double[]{1.0, 1.0, 1.0, 2.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0, 1.0, 2.0, 2.0, 2.0, 1.0, 0.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0, 2.0};
        byte[] byArray9 = new byte[27];
        byArray9[9] = 1;
        byArray9[10] = 1;
        byArray9[11] = 1;
        byArray9[12] = 1;
        byArray9[13] = 1;
        byArray9[14] = 1;
        byArray9[15] = 1;
        byArray9[16] = 1;
        byArray9[17] = 1;
        byArray9[18] = 2;
        byArray9[19] = 2;
        byArray9[20] = 2;
        byArray9[21] = 2;
        byArray9[22] = 2;
        byArray9[23] = 2;
        byArray9[24] = 2;
        byArray9[25] = 2;
        byArray9[26] = 2;
        byte[] array18 = byArray9;
        double[] array19 = new double[]{0.999999, 1.000001, -1.0E-6, 1.0E-6, -1.0E-6};
        byte[] array20 = new byte[]{-1, -1, -1, -1, -1};
        double[] ExcelRY1 = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 11.0, 12.0, 13.0, 14.0, 10.5, 11.5, 12.5, 13.5, 14.5, 15.5, 16.5, 17.5, 15.0, 16.0, 17.0, 18.0, 19.0, 20.0, 21.0, 22.0, 23.0, 24.0};
        byte[] byArray10 = new byte[32];
        byArray10[14] = 1;
        byArray10[15] = 1;
        byArray10[16] = 1;
        byArray10[17] = 1;
        byArray10[18] = 1;
        byArray10[19] = 1;
        byArray10[20] = 1;
        byArray10[21] = 1;
        byArray10[22] = 2;
        byArray10[23] = 2;
        byArray10[24] = 2;
        byArray10[25] = 2;
        byArray10[26] = 2;
        byArray10[27] = 2;
        byArray10[28] = 2;
        byArray10[29] = 2;
        byArray10[30] = 2;
        byArray10[31] = 2;
        byte[] ExcelRY2 = byArray10;
        double[][] tmp3 = GenoTools.PhenotypeByGenotype(array6, array5, 3);
        double[][] tmp4 = GenoTools.PhenotypeByGenotype(array8, array7, 3);
        double[][] tmp5 = GenoTools.PhenotypeByGenotype(array10, array9, 3);
        double[][] tmp6 = GenoTools.PhenotypeByGenotype(array12, array11, 3);
        double[][] tmp7 = GenoTools.PhenotypeByGenotype(array14, array13, 5);
        double[][] tmp8 = GenoTools.PhenotypeByGenotype(array16, array15, 4);
        double[][] tmp9 = GenoTools.PhenotypeByGenotype(array18, array17, 3);
        double[][] tmp10 = GenoTools.PhenotypeByGenotype(array20, array19, 3);
        double[][] ExcelRY = GenoTools.PhenotypeByGenotype(ExcelRY2, ExcelRY1, 3);
        PlotTools.Array2(tmp10);
        if (RankTools.Zerocheck(tmp10)) {
            System.out.println("zero!!\n");
        }
        System.out.println(RankTools.KruskalWallis(ExcelRY));
        System.out.println(RankTools.Jonckheere(tmp10));
        System.out.println(RankTools.Jonckheere(ExcelRY));
    }

    public static double[] QTLAnalysis(byte[] Genodata, double[] Phendata) {
        double[] ret = new double[8];
        double[] DoubleGeno = new double[Genodata.length];
        int i = 0;
        while (i < Genodata.length) {
            DoubleGeno[i] = Genodata[i];
            ++i;
        }
        double[][] array = GenoTools.PhenotypeByGenotype(Genodata, Phendata, 3);
        double[] Linear = RegressTools.LinearRegress(DoubleGeno, Phendata);
        ret[0] = RankTools.Jonckheere(array);
        ret[1] = RankTools.KruskalWallis(array);
        ret[2] = Linear[2];
        ret[3] = Linear[0];
        ret[4] = Linear[1];
        ret[5] = Linear[8];
        ret[6] = Linear[3];
        ret[7] = Linear[3] * Linear[3] * (double)Phendata.length;
        return ret;
    }

    public static boolean Zerocheck(double[][] array) {
        boolean ret = false;
        int sum = 0;
        int i = 0;
        while (i < array.length) {
            sum += array[i].length;
            ++i;
        }
        if (sum == 0) {
            ret = true;
        }
        return ret;
    }

    public static double Jonckheere(double[][] array) {
        double J = RankTools.MannWhitney(array);
        if (RankTools.Zerocheck(array)) {
            J = 0.0;
        } else {
            int[] TieNum = RankTools.RankWithTieDim2(array);
            double[][] rankSum = RankTools.RankSumNumDim2(array);
            double N = 0.0;
            double Nume = 0.0;
            double Denom1 = 0.0;
            double Denom2 = 0.0;
            double Denom3 = 0.0;
            double Denom4 = 0.0;
            double Denom5 = 0.0;
            double Denom6 = 0.0;
            int i = 0;
            while (i < array.length) {
                double tmpN = rankSum[i][1];
                N += tmpN;
                Nume += Math.pow(tmpN, 2.0);
                Denom1 += tmpN * (tmpN - 1.0) * (2.0 * tmpN + 5.0);
                Denom3 += tmpN * (tmpN - 1.0) * (tmpN - 2.0);
                Denom5 += tmpN * (tmpN - 1.0);
                ++i;
            }
            i = 0;
            while (i < TieNum.length) {
                double tmpT = TieNum[i];
                Denom2 += tmpT * (tmpT - 1.0) * (2.0 * tmpT + 5.0);
                Denom4 += tmpT * (tmpT - 1.0) * (tmpT - 2.0);
                Denom6 += tmpT * (tmpT - 1.0);
                ++i;
            }
            double E = (Math.pow(N, 2.0) - Nume) / 4.0;
            double V = (N * (N - 1.0) * (2.0 * N + 5.0) - Denom1 - Denom2) / 72.0 + Denom3 * Denom4 / (36.0 * N * (N - 1.0) * (N - 2.0)) + Denom5 * Denom6 / (8.0 * N * (N - 1.0));
            J = (J - E) * Math.pow(V, -0.5);
        }
        return J;
    }

    public static double KruskalWallis(double[][] array) {
        double H = 0.0;
        if (RankTools.Zerocheck(array)) {
            H = -99.0;
        } else {
            double N = 0.0;
            double Denom = 0.0;
            int[] TieNum = RankTools.RankWithTieDim2(array);
            double[][] rankSum = RankTools.RankSumNumDim2(array);
            int i = 0;
            while (i < array.length) {
                H += Math.pow(rankSum[i][0], 2.0) / rankSum[i][1];
                N += rankSum[i][1];
                ++i;
            }
            H = 12.0 / (N * (N + 1.0)) * H - 3.0 * (N + 1.0);
            i = 0;
            while (i < TieNum.length) {
                Denom += (double)(TieNum[i] - 1) * (double)TieNum[i] * (double)(TieNum[i] + 1);
                ++i;
            }
            H /= 1.0 - Denom / ((N - 1.0) * N * (N + 1.0));
        }
        return H;
    }

    public static double MannWhitney(double[][] array) {
        double U = 0.0;
        double Uinv = 0.0;
        int i = 0;
        while (i < array.length - 1) {
            int j = i + 1;
            while (j < array.length) {
                int k = 0;
                while (k < array[i].length) {
                    int l = 0;
                    while (l < array[j].length) {
                        if (array[i][k] < array[j][l]) {
                            U += 1.0;
                        } else if (array[i][k] == array[j][l]) {
                            U += 0.5;
                            Uinv += 0.5;
                        } else {
                            Uinv += 1.0;
                        }
                        ++l;
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return U;
    }

    public static int[] RankWithTieDim2(double[][] array) {
        double[][] arrayDim1 = RankTools.ArrayDim2to1(array);
        Quicksort.sortDouble2_x(arrayDim1, 0);
        double[] tmp = new double[arrayDim1.length];
        int i = 0;
        while (i < arrayDim1.length) {
            tmp[i] = arrayDim1[i][0];
            ++i;
        }
        int[] TieNum = RankTools.RankWithTie(tmp);
        int i2 = 0;
        while (i2 < arrayDim1.length) {
            array[(int)arrayDim1[i2][1]][(int)arrayDim1[i2][2]] = tmp[i2];
            ++i2;
        }
        return TieNum;
    }

    public static double[][] RankSumNumDim2(double[][] array) {
        double[][] ret = new double[array.length][2];
        int i = 0;
        while (i < array.length) {
            double sum = 0.0;
            int j = 0;
            while (j < array[i].length) {
                sum += array[i][j];
                ++j;
            }
            ret[i][0] = sum;
            ret[i][1] = array[i].length;
            ++i;
        }
        return ret;
    }

    public static double[][] ArrayDim2to1(double[][] array) {
        int len = 0;
        int counter = 0;
        int i = 0;
        while (i < array.length) {
            len += array[i].length;
            ++i;
        }
        double[][] ret = new double[len][3];
        int i2 = 0;
        while (i2 < array.length) {
            int j = 0;
            while (j < array[i2].length) {
                ret[counter][0] = array[i2][j];
                ret[counter][1] = i2;
                ret[counter][2] = j;
                ++counter;
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static int[] RankWithTie(double[] array) {
        double[] RankTie = new double[array.length];
        int[] tmpTray = new int[array.length];
        RankTie[0] = 1.0;
        boolean tie = false;
        boolean tielog = false;
        int counter = 0;
        int counter2 = 0;
        int counter3 = 0;
        int i = 1;
        while (i < RankTie.length) {
            int j;
            double mean;
            double[] tiearray;
            RankTie[i] = i + 1;
            tielog = tie;
            boolean bl = tie = array[i] == array[i - 1];
            if (tie) {
                ++counter;
            }
            if (!tie && tielog) {
                tiearray = new double[counter + 1];
                counter2 = 0;
                int j2 = i - counter - 1;
                while (j2 < i) {
                    tiearray[counter2] = RankTie[j2];
                    ++counter2;
                    ++j2;
                }
                mean = Tools.MeanVarSD(tiearray)[0];
                j = i - counter - 1;
                while (j < i) {
                    RankTie[j] = mean;
                    ++j;
                }
                tmpTray[counter3] = counter + 1;
                counter = 0;
                ++counter3;
            } else if (tie && i == RankTie.length - 1) {
                tiearray = new double[counter + 1];
                counter2 = 0;
                int j3 = i - counter;
                while (j3 < i + 1) {
                    tiearray[counter2] = RankTie[j3];
                    ++counter2;
                    ++j3;
                }
                mean = Tools.MeanVarSD(tiearray)[0];
                j = i - counter;
                while (j < i + 1) {
                    RankTie[j] = mean;
                    ++j;
                }
                tmpTray[counter3] = counter + 1;
                counter = 0;
                ++counter3;
            }
            ++i;
        }
        int[] ret = new int[counter3];
        int i2 = 0;
        while (i2 < counter3) {
            ret[i2] = tmpTray[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < RankTie.length) {
            array[i2] = RankTie[i2];
            ++i2;
        }
        return ret;
    }
}

