/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Tool.PlotTools;

public class PowerTools {
    public static void main(String[] args) {
        int[] array = new int[]{40, 60, 50, 50};
        int N = 10;
        double[] CombiLog = PowerTools.CombiLogArray(N);
        double[][] CombiLogDf2 = PowerTools.CombiLogArrayDf2(N);
        PlotTools.Array(CombiLog);
        PlotTools.Array2(CombiLogDf2);
    }

    public static double[] CalcLikeH0H1fromProb2x2(int[] array, double[] CombiLog) {
        double[] ret = new double[2];
        int a = array[0];
        int b = array[1];
        int c = array[2];
        int d = array[3];
        int R1 = a + b;
        int R2 = c + d;
        int C1 = a + c;
        int C2 = b + d;
        int N = R1 + R2;
        double p = (double)C1 / (double)N;
        double p1 = (double)a / (double)R1;
        double p2 = (double)c / (double)R2;
        return ret;
    }

    public static double[][] CombiLogArrayDf2(int N) {
        double[][] ret = new double[N + 1][0];
        int i = 0;
        while (i <= N) {
            ret[i] = new double[i + 1];
            int j = 0;
            while (j <= i) {
                ret[i][j] = 0.0;
                int k = 1;
                while (k <= j) {
                    double[] dArray = ret[i];
                    int n = j;
                    dArray[n] = dArray[n] + (Math.log(i - k + 1) - Math.log(k));
                    ++k;
                }
                ret[i][j] = Math.exp(ret[i][j]);
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double[] CombiLogArray(int N) {
        double[] ret = new double[N + 1];
        int k = 0;
        while (k <= N) {
            ret[k] = 0.0;
            int l = 1;
            while (l <= k) {
                int n = k;
                ret[n] = ret[n] + (Math.log(N - l + 1) - Math.log(l));
                ++l;
            }
            ret[k] = Math.exp(ret[k]);
            ++k;
        }
        return ret;
    }
}

