/*
 * Decompiled with CFR 0.152.
 */
package TablePlot2D;

import TablePlot2D.Prob2x2;
import Tool.ArrayTools;
import Tool.CorresTable;
import Tool.FileTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class CalcProb2x2XYZ_ver2 {
    public static void main(String[] args) {
        int N = 250;
        int ThresN = 300;
        int ThresK = 5;
        double ThresChi = 45.0;
        double ThresH = 2.0;
        double ThresL = 2.0;
        double ThresAdd = 1.5;
        double ThresVD = 0.205;
        double ThresC = 7.879439;
        double ThresCP = 0.005;
        double[] ThresSeq = new double[]{2.0};
        double[] CutValue = new double[]{0.0, 0.01, 0.03, 0.05, 0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.496, 0.5, 0.504, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 0.97, 0.99, 1.0};
        double[] ThresP = new double[]{1.1, 0.1, 0.01, 0.001, 1.0E-4, 1.0E-5, 1.0E-6, 1.0E-7, 1.0E-8, 1.0E-9, 1.0E-10, Math.pow(10.0, -20.0), Math.pow(10.0, -30.0), Math.pow(10.0, -40.0), Math.pow(10.0, -50.0), Math.pow(10.0, -60.0), Math.pow(10.0, -70.0), Math.pow(10.0, -80.0), Math.pow(10.0, -90.0), Math.pow(10.0, -100.0)};
        int[] CutValueInt = new int[CutValue.length];
        int i = 0;
        while (i < CutValue.length) {
            CutValueInt[i] = (int)Math.round((double)N * CutValue[i]);
            ++i;
        }
        int numThresSeq = ThresSeq.length;
        int numCondition = (CutValueInt.length * 2 + 1) * ThresP.length;
        int[][][] StateCounterC = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterY = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterR5 = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterNR5 = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5 = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5V = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5D = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5P = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5VP = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfR5DP = new int[numCondition][numThresSeq][4];
        int[][][] StateCounterAfP = new int[numCondition][numThresSeq][4];
        String[] StateStr = new String[numCondition];
        ArrayTools.InitialaizeArray3(StateCounterC);
        ArrayTools.InitialaizeArray3(StateCounterY);
        ArrayTools.InitialaizeArray3(StateCounterR5);
        ArrayTools.InitialaizeArray3(StateCounterNR5);
        ArrayTools.InitialaizeArray3(StateCounterAfR5);
        ArrayTools.InitialaizeArray3(StateCounterAfR5V);
        ArrayTools.InitialaizeArray3(StateCounterAfR5D);
        ArrayTools.InitialaizeArray3(StateCounterAfR5P);
        ArrayTools.InitialaizeArray3(StateCounterAfR5VP);
        ArrayTools.InitialaizeArray3(StateCounterAfR5DP);
        ArrayTools.InitialaizeArray3(StateCounterAfP);
        int counterS = 0;
        int i2 = 0;
        while (i2 < ThresP.length) {
            StateStr[counterS] = "All\t-\t" + Math.min(ThresP[i2], 1.0) + "\t";
            ++counterS;
            int j = 0;
            while (j < CutValueInt.length) {
                StateStr[counterS] = "x\t" + CutValueInt[j] + "\t" + Math.min(ThresP[i2], 1.0) + "\t";
                ++counterS;
                ++j;
            }
            j = 0;
            while (j < CutValueInt.length) {
                StateStr[counterS] = "z\t" + CutValueInt[j] + "\t" + Math.min(ThresP[i2], 1.0) + "\t";
                ++counterS;
                ++j;
            }
            ++i2;
        }
        String CorresFile = "P_Chi_CorresTable_mid.txt";
        String outfile = "TetraTable";
        String out = "";
        boolean all = false;
        boolean rule = false;
        boolean RatioLMH = false;
        boolean RatioRVP = true;
        int i3 = 0;
        while (i3 < args.length) {
            if (args[i3].equals("-N")) {
                N = Integer.parseInt(args[i3 + 1]);
            }
            if (args[i3].equals("-ThresChi")) {
                ThresChi = Double.parseDouble(args[i3 + 1]);
            }
            if (args[i3].equals("-out")) {
                outfile = args[i3 + 1];
            }
            if (args[i3].equals("-all")) {
                all = true;
            }
            if (args[i3].equals("-rule")) {
                rule = true;
            }
            ++i3;
        }
        outfile = String.valueOf(outfile) + "_rule" + ThresK + "_ChiP" + ThresCP;
        String outfile_all = String.valueOf(outfile) + "_" + N + "_XYZ_all.txt";
        String outfile_Exp5 = String.valueOf(outfile) + "_" + N + "_XYZ_Exp5.txt";
        String outfile_Obs5 = String.valueOf(outfile) + "_" + N + "_XYZ_Obs5.txt";
        String outfile_Exp5in = String.valueOf(outfile) + "_" + N + "_XYZ_Exp5in.txt";
        String outfile_RatioH = String.valueOf(outfile) + "_" + N + "_XYZ_RatioH.txt";
        String outfile_RatioM = String.valueOf(outfile) + "_" + N + "_XYZ_RatioM.txt";
        String outfile_RatioL = String.valueOf(outfile) + "_" + N + "_XYZ_RatioL.txt";
        String outfile_Count = String.valueOf(outfile) + "_" + N + "_XYZ_Count.txt";
        String outfile_AfR5V = String.valueOf(outfile) + "_" + N + "_XYZ_AfR5V.txt";
        String outfile_AfR5D = String.valueOf(outfile) + "_" + N + "_XYZ_AfR5D.txt";
        String outfile_AfR5P = String.valueOf(outfile) + "_" + N + "_XYZ_AfR5P.txt";
        String outfile_AfR5VP = String.valueOf(outfile) + "_" + N + "_XYZ_AfR5VP.txt";
        String outfile_AfR5DP = String.valueOf(outfile) + "_" + N + "_XYZ_AfR5DP.txt";
        String outfile_AfP = String.valueOf(outfile) + "_" + N + "_XYZ_AfP.txt";
        double[] logFact = new double[N + 1];
        int i4 = 0;
        while (i4 < N + 1) {
            logFact[i4] = Tools.factlog(i4);
            ++i4;
        }
        boolean df1 = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df1);
        BufferedWriter[] bw = new BufferedWriter[14];
        int i5 = 0;
        while (i5 < bw.length) {
            bw[i5] = null;
            ++i5;
        }
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfile_all));
            bw[1] = new BufferedWriter(new FileWriter(outfile_Exp5));
            bw[2] = new BufferedWriter(new FileWriter(outfile_Obs5));
            bw[3] = new BufferedWriter(new FileWriter(outfile_Exp5in));
            bw[4] = new BufferedWriter(new FileWriter(outfile_RatioH));
            bw[5] = new BufferedWriter(new FileWriter(outfile_RatioM));
            bw[6] = new BufferedWriter(new FileWriter(outfile_RatioL));
            bw[7] = new BufferedWriter(new FileWriter(outfile_Count));
            bw[8] = new BufferedWriter(new FileWriter(outfile_AfR5V));
            bw[9] = new BufferedWriter(new FileWriter(outfile_AfR5D));
            bw[10] = new BufferedWriter(new FileWriter(outfile_AfR5P));
            bw[11] = new BufferedWriter(new FileWriter(outfile_AfR5VP));
            bw[12] = new BufferedWriter(new FileWriter(outfile_AfR5DP));
            bw[13] = new BufferedWriter(new FileWriter(outfile_AfP));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            out = "x\ty\tz\tChi\tYates\tChiP\tYatesP\tExactP\tRatioCE\tRatioYE\trFive\n";
            FileTools.out3File(bw[0], out);
            out = "x\ty\tz\tExactP\tRatioCE\tRatioYE\n";
            FileTools.out3File(bw[1], out);
            FileTools.out3File(bw[2], out);
            FileTools.out3File(bw[3], out);
            out = "x\ty\tz\tRatioCE\n";
            FileTools.out3File(bw[4], out);
            FileTools.out3File(bw[5], out);
            FileTools.out3File(bw[6], out);
            FileTools.out3File(bw[8], out);
            FileTools.out3File(bw[9], out);
            FileTools.out3File(bw[10], out);
            FileTools.out3File(bw[11], out);
            FileTools.out3File(bw[12], out);
            FileTools.out3File(bw[13], out);
            int[] tmp = new int[4];
            int x = 0;
            while (x <= N) {
                System.out.println(x);
                int y = 0;
                while (y <= N) {
                    double logBase = logFact[x] + logFact[y] + logFact[N - x] + logFact[N - y] - logFact[N];
                    double[] logVar = new double[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    double[][] ProbP = new double[Math.min(x, y) - Math.max(0, x + y - N) + 1][10];
                    int[] ruleOfFiveExp = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfFiveObs = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfTenExp = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfVertex = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfDiamond = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int[] ruleOfPvalue = new int[Math.min(x, y) - Math.max(0, x + y - N) + 1];
                    int z = Math.max(0, x + y - N);
                    while (z <= Math.min(x, y)) {
                        int ord = z - Math.max(0, x + y - N);
                        tmp[0] = z;
                        tmp[1] = x - z;
                        tmp[2] = y - z;
                        tmp[3] = N - x - y + z;
                        ProbP[ord][0] = x;
                        ProbP[ord][1] = y;
                        ProbP[ord][2] = z;
                        double Chi = StatTools.Chi2Count(tmp);
                        double YatesChi = StatTools.Chi2CountYates(tmp);
                        ProbP[ord][3] = Chi;
                        ProbP[ord][4] = YatesChi;
                        ProbP[ord][5] = Chi == -99.0 ? -99.0 : (Chi <= ThresChi ? StatTools.TranslateToPdf1(Chi, chidf1) : CorresTable.ConvChitoPbyCorres(Chi, CorresTableChi, 1));
                        ProbP[ord][6] = YatesChi == -99.0 ? -99.0 : (YatesChi <= ThresChi ? StatTools.TranslateToPdf1(YatesChi, chidf1) : CorresTable.ConvChitoPbyCorres(YatesChi, CorresTableChi, 1));
                        ruleOfFiveExp[ord] = StatTools.ruleOfkExp(tmp, ThresK);
                        ruleOfFiveObs[ord] = StatTools.ruleOfkObs(tmp, ThresK - 2);
                        ruleOfTenExp[ord] = StatTools.ruleOfkExp(tmp, ThresK + 2);
                        ruleOfVertex[ord] = StatTools.ruleOfVertex(tmp, ThresVD);
                        ruleOfDiamond[ord] = StatTools.ruleOfDiamond(tmp, ThresVD);
                        ruleOfPvalue[ord] = StatTools.ruleOfChiP(tmp, ThresC);
                        Tools.NormalSort1arrayInt(tmp);
                        logVar[ord] = logFact[tmp[0]] + logFact[tmp[1]] + logFact[tmp[2]] + logFact[tmp[3]];
                        ++z;
                    }
                    z = Math.max(0, x + y - N);
                    while (z <= Math.min(x, y)) {
                        int ordz = z - Math.max(0, x + y - N);
                        double ExactP = 0.0;
                        int k = Math.max(0, x + y - N);
                        while (k <= Math.min(x, y)) {
                            int ordk = k - Math.max(0, x + y - N);
                            if (logVar[ordk] >= logVar[ordz]) {
                                ExactP += Math.exp(logBase - logVar[ordk]);
                            }
                            ++k;
                        }
                        if (Math.abs(1.0 - ExactP) < Math.pow(10.0, -7.0)) {
                            ExactP = 1.0;
                        }
                        ProbP[ordz][7] = ExactP;
                        ProbP[ordz][8] = ProbP[ordz][5] == -99.0 ? -99.0 : ProbP[ordz][5] / ExactP;
                        ProbP[ordz][9] = ProbP[ordz][6] == -99.0 ? -99.0 : ProbP[ordz][6] / ExactP;
                        k = 0;
                        while (k < numThresSeq) {
                            int RatioStateC = Prob2x2.DecideRatioStateOneThres(ProbP[ordz][8], ThresSeq[k]);
                            int RatioStateY = Prob2x2.DecideRatioStateOneThres(ProbP[ordz][9], ThresSeq[k]);
                            counterS = 0;
                            int i6 = 0;
                            while (i6 < ThresP.length) {
                                if (ExactP <= ThresP[i6]) {
                                    int[] nArray = StateCounterC[counterS][k];
                                    int n = RatioStateC;
                                    nArray[n] = nArray[n] + 1;
                                    int[] nArray2 = StateCounterY[counterS][k];
                                    int n2 = RatioStateY;
                                    nArray2[n2] = nArray2[n2] + 1;
                                    if (ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray3 = StateCounterR5[counterS][k];
                                        int n3 = RatioStateC;
                                        nArray3[n3] = nArray3[n3] + 1;
                                        int[] nArray4 = StateCounterAfR5[counterS][k];
                                        nArray4[2] = nArray4[2] + 1;
                                    } else {
                                        int[] nArray5 = StateCounterNR5[counterS][k];
                                        int n4 = RatioStateC;
                                        nArray5[n4] = nArray5[n4] + 1;
                                        int[] nArray6 = StateCounterAfR5[counterS][k];
                                        int n5 = RatioStateC;
                                        nArray6[n5] = nArray6[n5] + 1;
                                    }
                                    if (ruleOfVertex[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray7 = StateCounterAfR5V[counterS][k];
                                        nArray7[2] = nArray7[2] + 1;
                                    } else {
                                        int[] nArray8 = StateCounterAfR5V[counterS][k];
                                        int n6 = RatioStateC;
                                        nArray8[n6] = nArray8[n6] + 1;
                                    }
                                    if (ruleOfDiamond[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray9 = StateCounterAfR5D[counterS][k];
                                        nArray9[2] = nArray9[2] + 1;
                                    } else {
                                        int[] nArray10 = StateCounterAfR5D[counterS][k];
                                        int n7 = RatioStateC;
                                        nArray10[n7] = nArray10[n7] + 1;
                                    }
                                    if (ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray11 = StateCounterAfR5P[counterS][k];
                                        nArray11[2] = nArray11[2] + 1;
                                    } else {
                                        int[] nArray12 = StateCounterAfR5P[counterS][k];
                                        int n8 = RatioStateC;
                                        nArray12[n8] = nArray12[n8] + 1;
                                    }
                                    if (ruleOfVertex[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray13 = StateCounterAfR5VP[counterS][k];
                                        nArray13[2] = nArray13[2] + 1;
                                    } else {
                                        int[] nArray14 = StateCounterAfR5VP[counterS][k];
                                        int n9 = RatioStateC;
                                        nArray14[n9] = nArray14[n9] + 1;
                                    }
                                    if (ruleOfDiamond[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                        int[] nArray15 = StateCounterAfR5DP[counterS][k];
                                        nArray15[2] = nArray15[2] + 1;
                                    } else {
                                        int[] nArray16 = StateCounterAfR5DP[counterS][k];
                                        int n10 = RatioStateC;
                                        nArray16[n10] = nArray16[n10] + 1;
                                    }
                                    if (ruleOfPvalue[ordz] == 1) {
                                        int[] nArray17 = StateCounterAfP[counterS][k];
                                        nArray17[2] = nArray17[2] + 1;
                                    } else {
                                        int[] nArray18 = StateCounterAfP[counterS][k];
                                        int n11 = RatioStateC;
                                        nArray18[n11] = nArray18[n11] + 1;
                                    }
                                }
                                ++counterS;
                                int j = 0;
                                while (j < CutValueInt.length) {
                                    if (CutValueInt[j] == x && ExactP <= ThresP[i6]) {
                                        int[] nArray = StateCounterC[counterS][k];
                                        int n = RatioStateC;
                                        nArray[n] = nArray[n] + 1;
                                        int[] nArray19 = StateCounterY[counterS][k];
                                        int n12 = RatioStateY;
                                        nArray19[n12] = nArray19[n12] + 1;
                                        if (ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray20 = StateCounterR5[counterS][k];
                                            int n13 = RatioStateC;
                                            nArray20[n13] = nArray20[n13] + 1;
                                            int[] nArray21 = StateCounterAfR5[counterS][k];
                                            nArray21[2] = nArray21[2] + 1;
                                        } else {
                                            int[] nArray22 = StateCounterNR5[counterS][k];
                                            int n14 = RatioStateC;
                                            nArray22[n14] = nArray22[n14] + 1;
                                            int[] nArray23 = StateCounterAfR5[counterS][k];
                                            int n15 = RatioStateC;
                                            nArray23[n15] = nArray23[n15] + 1;
                                        }
                                        if (ruleOfVertex[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray24 = StateCounterAfR5V[counterS][k];
                                            nArray24[2] = nArray24[2] + 1;
                                        } else {
                                            int[] nArray25 = StateCounterAfR5V[counterS][k];
                                            int n16 = RatioStateC;
                                            nArray25[n16] = nArray25[n16] + 1;
                                        }
                                        if (ruleOfDiamond[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray26 = StateCounterAfR5D[counterS][k];
                                            nArray26[2] = nArray26[2] + 1;
                                        } else {
                                            int[] nArray27 = StateCounterAfR5D[counterS][k];
                                            int n17 = RatioStateC;
                                            nArray27[n17] = nArray27[n17] + 1;
                                        }
                                        if (ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray28 = StateCounterAfR5P[counterS][k];
                                            nArray28[2] = nArray28[2] + 1;
                                        } else {
                                            int[] nArray29 = StateCounterAfR5P[counterS][k];
                                            int n18 = RatioStateC;
                                            nArray29[n18] = nArray29[n18] + 1;
                                        }
                                        if (ruleOfVertex[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray30 = StateCounterAfR5VP[counterS][k];
                                            nArray30[2] = nArray30[2] + 1;
                                        } else {
                                            int[] nArray31 = StateCounterAfR5VP[counterS][k];
                                            int n19 = RatioStateC;
                                            nArray31[n19] = nArray31[n19] + 1;
                                        }
                                        if (ruleOfDiamond[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray32 = StateCounterAfR5DP[counterS][k];
                                            nArray32[2] = nArray32[2] + 1;
                                        } else {
                                            int[] nArray33 = StateCounterAfR5DP[counterS][k];
                                            int n20 = RatioStateC;
                                            nArray33[n20] = nArray33[n20] + 1;
                                        }
                                        if (ruleOfPvalue[ordz] == 1) {
                                            int[] nArray34 = StateCounterAfP[counterS][k];
                                            nArray34[2] = nArray34[2] + 1;
                                        } else {
                                            int[] nArray35 = StateCounterAfP[counterS][k];
                                            int n21 = RatioStateC;
                                            nArray35[n21] = nArray35[n21] + 1;
                                        }
                                    }
                                    ++counterS;
                                    ++j;
                                }
                                j = 0;
                                while (j < CutValueInt.length) {
                                    if (CutValueInt[j] == z && ExactP <= ThresP[i6]) {
                                        int[] nArray = StateCounterC[counterS][k];
                                        int n = RatioStateC;
                                        nArray[n] = nArray[n] + 1;
                                        int[] nArray36 = StateCounterY[counterS][k];
                                        int n22 = RatioStateY;
                                        nArray36[n22] = nArray36[n22] + 1;
                                        if (ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray37 = StateCounterR5[counterS][k];
                                            int n23 = RatioStateC;
                                            nArray37[n23] = nArray37[n23] + 1;
                                            int[] nArray38 = StateCounterAfR5[counterS][k];
                                            nArray38[2] = nArray38[2] + 1;
                                        } else {
                                            int[] nArray39 = StateCounterNR5[counterS][k];
                                            int n24 = RatioStateC;
                                            nArray39[n24] = nArray39[n24] + 1;
                                            int[] nArray40 = StateCounterAfR5[counterS][k];
                                            int n25 = RatioStateC;
                                            nArray40[n25] = nArray40[n25] + 1;
                                        }
                                        if (ruleOfVertex[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray41 = StateCounterAfR5V[counterS][k];
                                            nArray41[2] = nArray41[2] + 1;
                                        } else {
                                            int[] nArray42 = StateCounterAfR5V[counterS][k];
                                            int n26 = RatioStateC;
                                            nArray42[n26] = nArray42[n26] + 1;
                                        }
                                        if (ruleOfDiamond[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray43 = StateCounterAfR5D[counterS][k];
                                            nArray43[2] = nArray43[2] + 1;
                                        } else {
                                            int[] nArray44 = StateCounterAfR5D[counterS][k];
                                            int n27 = RatioStateC;
                                            nArray44[n27] = nArray44[n27] + 1;
                                        }
                                        if (ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray45 = StateCounterAfR5P[counterS][k];
                                            nArray45[2] = nArray45[2] + 1;
                                        } else {
                                            int[] nArray46 = StateCounterAfR5P[counterS][k];
                                            int n28 = RatioStateC;
                                            nArray46[n28] = nArray46[n28] + 1;
                                        }
                                        if (ruleOfVertex[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray47 = StateCounterAfR5VP[counterS][k];
                                            nArray47[2] = nArray47[2] + 1;
                                        } else {
                                            int[] nArray48 = StateCounterAfR5VP[counterS][k];
                                            int n29 = RatioStateC;
                                            nArray48[n29] = nArray48[n29] + 1;
                                        }
                                        if (ruleOfDiamond[ordz] == 1 || ruleOfPvalue[ordz] == 1 || ruleOfFiveExp[ordz] == 1) {
                                            int[] nArray49 = StateCounterAfR5DP[counterS][k];
                                            nArray49[2] = nArray49[2] + 1;
                                        } else {
                                            int[] nArray50 = StateCounterAfR5DP[counterS][k];
                                            int n30 = RatioStateC;
                                            nArray50[n30] = nArray50[n30] + 1;
                                        }
                                        if (ruleOfPvalue[ordz] == 1) {
                                            int[] nArray51 = StateCounterAfP[counterS][k];
                                            nArray51[2] = nArray51[2] + 1;
                                        } else {
                                            int[] nArray52 = StateCounterAfP[counterS][k];
                                            int n31 = RatioStateC;
                                            nArray52[n31] = nArray52[n31] + 1;
                                        }
                                    }
                                    ++counterS;
                                    ++j;
                                }
                                ++i6;
                            }
                            ++k;
                        }
                        ++z;
                    }
                    int i7 = 0;
                    while (i7 < ProbP.length) {
                        out = "";
                        int j = 0;
                        while (j < ProbP[0].length) {
                            out = String.valueOf(out) + ProbP[i7][j] + "\t";
                            ++j;
                        }
                        out = String.valueOf(out) + ruleOfFiveExp[i7] + "\n";
                        if (all) {
                            FileTools.out3File(bw[0], out);
                        }
                        out = String.valueOf(ProbP[i7][0]) + "\t" + ProbP[i7][1] + "\t" + ProbP[i7][2] + "\t" + ProbP[i7][7] + "\t" + ProbP[i7][8] + "\t" + ProbP[i7][9] + "\n";
                        if (rule) {
                            if (ruleOfFiveExp[i7] == 1) {
                                FileTools.out3File(bw[1], out);
                            }
                            if (ruleOfFiveObs[i7] == 1) {
                                FileTools.out3File(bw[2], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && (ruleOfFiveObs[i7] == 1 || ruleOfTenExp[i7] == 1)) {
                                FileTools.out3File(bw[3], out);
                            }
                        }
                        out = String.valueOf(ProbP[i7][0]) + "\t" + ProbP[i7][1] + "\t" + ProbP[i7][2] + "\t" + ProbP[i7][8] + "\n";
                        if (RatioLMH && (Math.random() < 0.2 || N < ThresN)) {
                            if (ProbP[i7][8] > ThresH) {
                                FileTools.out3File(bw[4], out);
                            } else if (ProbP[i7][8] <= ThresL && ProbP[i7][8] >= ThresAdd || ProbP[i7][8] >= 1.0 / ThresL && ProbP[i7][8] <= 1.0 / ThresAdd) {
                                FileTools.out3File(bw[5], out);
                            } else if (ProbP[i7][8] < 1.0 / ThresH && ProbP[i7][8] >= 0.0) {
                                FileTools.out3File(bw[6], out);
                            }
                        }
                        if (RatioRVP && (Math.random() < 0.2 || N < ThresN)) {
                            if (ruleOfFiveExp[i7] == 0 && ruleOfVertex[i7] == 0) {
                                FileTools.out3File(bw[8], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && ruleOfDiamond[i7] == 0) {
                                FileTools.out3File(bw[9], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && ruleOfPvalue[i7] == 0) {
                                FileTools.out3File(bw[10], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && ruleOfVertex[i7] == 0 && ruleOfPvalue[i7] == 0) {
                                FileTools.out3File(bw[11], out);
                            }
                            if (ruleOfFiveExp[i7] == 0 && ruleOfDiamond[i7] == 0 && ruleOfPvalue[i7] == 0) {
                                FileTools.out3File(bw[12], out);
                            }
                            if (ruleOfPvalue[i7] == 0) {
                                FileTools.out3File(bw[13], out);
                            }
                        }
                        ++i7;
                    }
                    ++y;
                }
                ++x;
            }
            String outTmp1 = "";
            String outTmp2 = "";
            int k = 0;
            while (k < numThresSeq) {
                if (k > 0) {
                    outTmp1 = String.valueOf(outTmp1) + "-\t";
                }
                outTmp1 = String.valueOf(outTmp1) + "-\t-\t-\t-\t-\t-\t-\t-\t";
                outTmp2 = String.valueOf(outTmp2) + "-99\t<" + 1.0 / ThresSeq[k] + "\tmid\t>" + ThresSeq[k] + "\tSum\t-99\t<" + 1.0 / ThresSeq[k] + "\tmid\t>" + ThresSeq[k] + "\t";
                ++k;
            }
            out = "rule_of_" + ThresK + "\t-\t-\t" + "Normal\t" + outTmp1 + "Yates\t" + outTmp1 + "RuleOf5\t" + outTmp1 + "NotRuleOf5\t" + outTmp1 + "AfRuleOf5\t" + outTmp1 + "AfRuleOf5Vertex\t" + outTmp1 + "AfRuleOf5Diamond\t" + outTmp1 + "AfRuleOf5Pvalue\t" + outTmp1 + "AfRuleOf5VP\t" + outTmp1 + "AfRuleOf5DP\t" + outTmp1 + "AfP\t" + outTmp1 + "\n";
            out = String.valueOf(out) + "Type\tCutVal\tP\t" + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + outTmp2 + "\n";
            FileTools.out3File(bw[7], out);
            int i8 = 0;
            while (i8 < numCondition) {
                out = StateStr[i8];
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterC, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterY, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterR5, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterNR5, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5V, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5D, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5P, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5VP, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfR5DP, i8);
                out = String.valueOf(out) + CalcProb2x2XYZ_ver2.AddStateCounterSeq(StateCounterAfP, i8);
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[7], out);
                ++i8;
            }
            i8 = 0;
            while (i8 < bw.length) {
                bw[i8].close();
                ++i8;
            }
            if (!all) {
                FileTools.FileDelete(outfile_all);
            }
            if (!rule) {
                FileTools.FileDelete(outfile_Exp5);
                FileTools.FileDelete(outfile_Obs5);
                FileTools.FileDelete(outfile_Exp5in);
            }
            if (!RatioLMH) {
                FileTools.FileDelete(outfile_RatioH);
                FileTools.FileDelete(outfile_RatioM);
                FileTools.FileDelete(outfile_RatioL);
            }
            if (!RatioRVP) {
                FileTools.FileDelete(outfile_AfR5V);
                FileTools.FileDelete(outfile_AfR5D);
                FileTools.FileDelete(outfile_AfR5P);
                FileTools.FileDelete(outfile_AfR5VP);
                FileTools.FileDelete(outfile_AfR5DP);
                FileTools.FileDelete(outfile_AfP);
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static String AddStateCounterSeq(int[][][] StateCounter, int nrow) {
        String out = "";
        int k = 0;
        while (k < StateCounter[0].length) {
            int i = 0;
            while (i < StateCounter[0][0].length) {
                out = String.valueOf(out) + StateCounter[nrow][k][i] + "\t";
                ++i;
            }
            double[] Freq = CalcProb2x2XYZ_ver2.CalcFreqStateSeq(StateCounter, nrow, k);
            int i2 = 0;
            while (i2 < Freq.length) {
                out = String.valueOf(out) + Freq[i2] + "\t";
                ++i2;
            }
            ++k;
        }
        return out;
    }

    public static double[] CalcFreqStateSeq(int[][][] StateCounter, int nrow, int k) {
        double[] ret = new double[StateCounter[0][0].length + 1];
        int sum = 0;
        int j = 0;
        while (j < StateCounter[0][0].length) {
            sum += StateCounter[nrow][k][j];
            ++j;
        }
        ret[0] = sum;
        j = 0;
        while (j < StateCounter[0][0].length) {
            ret[j + 1] = (double)StateCounter[nrow][k][j] / (double)sum;
            ++j;
        }
        return ret;
    }

    public static String AddStateCounter(int[][] StateCounter, int nrow) {
        String out = "";
        double[] Freq = CalcProb2x2XYZ_ver2.CalcFreqState(StateCounter, nrow);
        int i = 0;
        while (i < StateCounter[0].length) {
            out = String.valueOf(out) + StateCounter[nrow][i] + "\t";
            ++i;
        }
        i = 0;
        while (i < Freq.length) {
            out = String.valueOf(out) + Freq[i] + "\t";
            ++i;
        }
        return out;
    }

    public static double[] CalcFreqState(int[][] StateCounter, int nrow) {
        double[] ret = new double[StateCounter[0].length + 1];
        int sum = 0;
        int j = 0;
        while (j < StateCounter[0].length) {
            sum += StateCounter[nrow][j];
            ++j;
        }
        ret[0] = sum;
        j = 0;
        while (j < StateCounter[0].length) {
            ret[j + 1] = (double)StateCounter[nrow][j] / (double)sum;
            ++j;
        }
        return ret;
    }
}

