/*
 * Decompiled with CFR 0.152.
 */
package Mains;

import Algorithms.MersenneTwisterFast;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class MakeCausSNP {
    public static void main(String[] args) {
        int numsnp = 1000;
        int numcase = 100;
        int numcont = 400;
        double[] maf = new double[]{0.1, 0.5};
        double gRR = 1.5;
        double d = 0.2;
        double fst = 0.001;
        String out = "";
        String[] genotype = new String[]{"1 1", "1 2", "2 2"};
        String[] phenotype = new String[]{"1", "2"};
        String outfile = "";
        String outfileped = "";
        String outfilelog = "";
        String outfilelist = "";
        String outfilepar = "";
        int seedgiven = 0;
        boolean struc = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-numcase")) {
                numcase = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numcont")) {
                numcont = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numsnp")) {
                numsnp = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-maf")) {
                maf[0] = Double.parseDouble(args[i + 1]);
                maf[1] = Double.parseDouble(args[i + 2]);
            }
            if (args[i].equals("-gRR")) {
                gRR = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-d")) {
                d = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-fst")) {
                fst = Double.parseDouble(args[i + 1]);
                struc = true;
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-structure")) {
                struc = true;
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        outfile = String.valueOf(outfile) + out + "_nca" + numcase + "nco" + numcont + "maf" + maf[0] + "-" + maf[1] + "gRR" + gRR + "d" + d;
        if (struc) {
            outfile = String.valueOf(outfile) + "fst" + fst;
        }
        outfileped = String.valueOf(outfile) + ".ped";
        outfilelog = String.valueOf(outfile) + ".log";
        outfilelist = String.valueOf(outfile) + ".list";
        outfilepar = String.valueOf(outfile) + ".par";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null, null};
        try {
            int j;
            bw[0] = new BufferedWriter(new FileWriter(outfileped));
            bw[1] = new BufferedWriter(new FileWriter(outfilelog));
            bw[2] = new BufferedWriter(new FileWriter(outfilelist));
            bw[3] = new BufferedWriter(new FileWriter(outfilepar));
            byte[][] genoca = new byte[numsnp][numcase];
            byte[][] genoco = new byte[numsnp][numcont];
            double[][] geno = new double[3][2];
            gRR = 1.0 / gRR;
            int i2 = 0;
            while (i2 < numsnp) {
                double tmp = mz.nextDouble();
                double popafca = mz.nextDouble() * (maf[1] - maf[0]) + maf[0];
                geno = MakeCausSNP.CaseContAf(popafca, gRR, d);
                j = 0;
                while (j < numcase) {
                    genoca[i2][j] = MakeCausSNP.DesideGeno(geno[0][0], geno[1][0], geno[2][0], mz);
                    ++j;
                }
                double popafco = popafca;
                popafco = MakeCausSNP.AFfromFst(popafca, fst, mz);
                geno = MakeCausSNP.CaseContAf(popafco, gRR, d);
                out = String.valueOf(gRR) + "\t" + popafca + "\t" + popafco + "\t" + geno[0][0] + "\t" + geno[1][0] + "\t" + geno[2][0] + "\t" + geno[0][1] + "\t" + geno[1][1] + "\t" + geno[2][1] + "\n";
                MakeCausSNP.out3File(bw[1], out);
                j = 0;
                while (j < numcont) {
                    genoco[i2][j] = MakeCausSNP.DesideGeno(geno[0][1], geno[1][1], geno[2][1], mz);
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < numcase) {
                out = "CaseID" + i2 + "\t2\t3\t4\t5\t" + phenotype[1] + "\t";
                j = 0;
                while (j < numsnp) {
                    out = String.valueOf(out) + genotype[genoca[j][i2]] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                MakeCausSNP.out3File(bw[0], out);
                ++i2;
            }
            i2 = 0;
            while (i2 < numcont) {
                out = "ControlID" + i2 + "\t2\t3\t4\t5\t" + phenotype[0] + "\t";
                j = 0;
                while (j < numsnp) {
                    out = String.valueOf(out) + genotype[genoco[j][i2]] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                MakeCausSNP.out3File(bw[0], out);
                ++i2;
            }
            out = String.valueOf(outfileped) + "\t" + numsnp + "\n";
            MakeCausSNP.out3File(bw[2], out);
            out = "rootdir \t \nbatchfiledir \t \noutputdir \t \ngenotypefiledir \t \nbatchfile\t" + outfilelist + "\n" + "dattype" + "\t" + "0" + "\n" + "seed" + "\t" + "-99" + "\n" + "iter\t1\n";
            MakeCausSNP.out3File(bw[3], out);
            bw[0].close();
            bw[1].close();
            bw[2].close();
            bw[3].close();
        }
        catch (Exception e) {
            System.out.println("ERROR!!!!!");
            System.out.println(e);
        }
    }

    public static double[][] CaseContAf(double popaf, double gRR, double d) {
        double[][] ret = new double[3][2];
        double tmp = popaf * popaf + 2.0 * popaf * (1.0 - popaf) * gRR + (1.0 - popaf) * (1.0 - popaf) * gRR * gRR;
        double r = d / tmp;
        ret[0][0] = popaf * popaf / tmp;
        ret[1][0] = 2.0 * popaf * (1.0 - popaf) * gRR / tmp;
        ret[2][0] = (1.0 - popaf) * (1.0 - popaf) * gRR * gRR / tmp;
        tmp = popaf * popaf * (1.0 - r) + 2.0 * popaf * (1.0 - popaf) * (1.0 - r * gRR) + (1.0 - popaf) * (1.0 - popaf) * (1.0 - r * gRR * gRR);
        ret[0][1] = popaf * popaf * (1.0 - r) / tmp;
        ret[1][1] = 2.0 * popaf * (1.0 - popaf) * (1.0 - r * gRR) / tmp;
        ret[2][1] = (1.0 - popaf) * (1.0 - popaf) * (1.0 - r * gRR * gRR) / tmp;
        return ret;
    }

    public static byte DesideGeno(double t1, double t2, double t3, MersenneTwisterFast mz) {
        int ret = -1;
        double tmp = t1 + t2 + t3;
        t1 = Math.abs(t1 / tmp);
        t2 = Math.abs(t2 / tmp);
        t3 = Math.abs(t3 / tmp);
        tmp = mz.nextDouble();
        if (tmp <= t1) {
            ret = 0;
        } else if (tmp <= t1 + t2) {
            ret = 1;
        } else if (tmp <= t1 + t2 + t3) {
            ret = 2;
        }
        return (byte)ret;
    }

    public static void out3File(BufferedWriter bw1, String st) {
        try {
            bw1.write(st);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double AFfromFst(double p, double fst, MersenneTwisterFast mz) {
        double ret = 0.0;
        double std = Math.pow(p * (1.0 - p) * fst, 0.5);
        ret = p + std * mz.nextGaussian();
        if (ret < 0.0) {
            ret = 0.0;
        } else if (ret > 1.0) {
            ret = 1.0;
        }
        return ret;
    }
}

