/*
 * Decompiled with CFR 0.152.
 */
package Interaction;

import Algorithms.MersenneTwisterFast;
import Likelihood.TableManage;
import StatUtilsZ.MiscUtilX;
import Tool.FileTools;
import Tool.PlotTools;
import java.io.BufferedWriter;

public class TableManageInt {
    public static void main(String[] args) {
        int seed = 999999999;
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        double[][] FreqCont = new double[][]{{0.35, 0.1, 0.05}, {0.21, 0.06, 0.03}, {0.14, 0.04, 0.02}};
        double[][] FreqCase = new double[][]{{0.02, 0.02, 0.36}, {0.01, 0.01, 0.18}, {0.02, 0.02, 0.36}};
        int numcont = 10000;
        int numcase = 10000;
        int[][] geno = TableManageInt.SamplingTwoSNPGenoData(FreqCont, FreqCase, numcont, numcase, mz);
        int[][][] Table = TableManageInt.MakeTwoSNPTable3x3(geno, numcont, numcase);
        int[][] TableCont = TableManage.ExtractTable(Table, 0);
        int[][] TableCase = TableManage.ExtractTable(Table, 1);
        PlotTools.Array2(TableCont);
        PlotTools.Array2(FreqCont);
        PlotTools.Array2(TableCase);
        PlotTools.Array2(FreqCase);
    }

    public static void outputPhenArray(String[] Phenotype, int numcont, int numcase, BufferedWriter bw) {
        String out = "";
        int i = 0;
        while (i < numcont) {
            out = String.valueOf(out) + Phenotype[0] + "\t";
            ++i;
        }
        i = 0;
        while (i < numcase) {
            out = String.valueOf(out) + Phenotype[1] + "\t";
            ++i;
        }
        out = String.valueOf(out) + "\n";
        FileTools.out3File(bw, out);
    }

    public static void outGenArray2SNP(int[][] GenoArray, String[] Genotype, BufferedWriter bw) {
        String out0 = "";
        String out1 = "";
        int i = 0;
        while (i < GenoArray[0].length) {
            out0 = String.valueOf(out0) + Genotype[GenoArray[0][i]] + "\t";
            out1 = String.valueOf(out1) + Genotype[GenoArray[1][i]] + "\t";
            ++i;
        }
        out0 = String.valueOf(out0) + "\n" + out1 + "\n";
        FileTools.out3File(bw, out0);
    }

    public static double[] CumFreq3x3(double[][] GenoFreq) {
        int j;
        double[] ret = new double[GenoFreq.length * GenoFreq[0].length];
        double sum = 0.0;
        double sum2 = 0.0;
        int counter = 0;
        int i = 0;
        while (i < GenoFreq.length) {
            j = 0;
            while (j < GenoFreq[0].length) {
                sum += GenoFreq[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < GenoFreq.length) {
            j = 0;
            while (j < GenoFreq[0].length) {
                ret[counter] = (sum2 += GenoFreq[i][j]) / sum;
                ++counter;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static int DecideOrder(double[] CumFreq, double rand) {
        int ret = -99;
        int i = 0;
        while (i < CumFreq.length) {
            if (rand < CumFreq[i]) {
                ret = i;
                i = CumFreq.length;
            }
            ++i;
        }
        return ret;
    }

    public static int[][][] MakeTwoSNPTable3x3(int[][] GenArray, int numcont, int numcase) {
        int[][][] ret = new int[2][3][3];
        int phen = 0;
        int i = 0;
        while (i < ret.length) {
            int j = 0;
            while (j < ret[0].length) {
                int k = 0;
                while (k < ret[0][0].length) {
                    ret[i][j][k] = 0;
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numcont + numcase) {
            if (i == numcont) {
                phen = 1;
            }
            int[] nArray = ret[phen][GenArray[0][i]];
            int n = GenArray[1][i];
            nArray[n] = nArray[n] + 1;
            ++i;
        }
        return ret;
    }

    public static int[][] SamplingTwoSNPGenoData(double[][] GenoFreqCont, double[][] GenoFreqCase, int numcont, int numcase, MersenneTwisterFast mz) {
        int[] GenoOrder = new int[numcont + numcase];
        int[][] ret = new int[2][numcont + numcase];
        int counter = 0;
        double[] CumFreq = TableManageInt.CumFreq3x3(GenoFreqCont);
        int i = 0;
        while (i < numcont) {
            GenoOrder[counter] = TableManageInt.DecideOrder(CumFreq, mz.nextDouble());
            ++counter;
            ++i;
        }
        CumFreq = TableManageInt.CumFreq3x3(GenoFreqCase);
        i = 0;
        while (i < numcase) {
            GenoOrder[counter] = TableManageInt.DecideOrder(CumFreq, mz.nextDouble());
            ++counter;
            ++i;
        }
        i = 0;
        while (i < GenoOrder.length) {
            if (GenoOrder[i] == 0) {
                ret[0][i] = 0;
                ret[1][i] = 0;
            } else if (GenoOrder[i] == 1) {
                ret[0][i] = 0;
                ret[1][i] = 1;
            } else if (GenoOrder[i] == 2) {
                ret[0][i] = 0;
                ret[1][i] = 2;
            } else if (GenoOrder[i] == 3) {
                ret[0][i] = 1;
                ret[1][i] = 0;
            } else if (GenoOrder[i] == 4) {
                ret[0][i] = 1;
                ret[1][i] = 1;
            } else if (GenoOrder[i] == 5) {
                ret[0][i] = 1;
                ret[1][i] = 2;
            } else if (GenoOrder[i] == 6) {
                ret[0][i] = 2;
                ret[1][i] = 0;
            } else if (GenoOrder[i] == 7) {
                ret[0][i] = 2;
                ret[1][i] = 1;
            } else if (GenoOrder[i] == 8) {
                ret[0][i] = 2;
                ret[1][i] = 2;
            }
            ++i;
        }
        return ret;
    }

    public static double[][][] CalcGenoFreqCaseCont(double[][] RR, double[][] GenoFreq, double prev) {
        int j;
        double[][][] ret = new double[2][3][3];
        double[][] tmpArray = TableManage.MultipleTwoTable(GenoFreq, RR);
        double[][] GenoFreqCase = TableManage.NormarizeTable(tmpArray);
        double[][] GenoFreqCont = new double[3][3];
        double k = prev / TableManage.SumTable(tmpArray);
        int i = 0;
        while (i < GenoFreq.length) {
            j = 0;
            while (j < GenoFreq[0].length) {
                GenoFreqCont[i][j] = GenoFreq[i][j] - k * tmpArray[i][j];
                ++j;
            }
            ++i;
        }
        GenoFreqCont = TableManage.NormarizeTable(GenoFreqCont);
        i = 0;
        while (i < GenoFreq.length) {
            j = 0;
            while (j < GenoFreq[0].length) {
                ret[0][i][j] = GenoFreqCont[i][j];
                ret[1][i][j] = GenoFreqCase[i][j];
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double[][][] MakeRRTable3x3(double R1, double R2, double k) {
        double[][][] ret = new double[8][3][3];
        ret[0][0][0] = 1.0;
        ret[0][1][0] = R1;
        ret[0][2][0] = R1 * R1;
        ret[0][0][1] = R2;
        ret[0][1][1] = R1 * R2;
        ret[0][2][1] = R1 * R1 * R2;
        ret[0][0][2] = R2 * R2;
        ret[0][1][2] = R1 * R2 * R2;
        ret[0][2][2] = R1 * R1 * R2 * R2;
        ret[1][0][0] = 1.0;
        ret[1][1][0] = R1;
        ret[1][2][0] = R1;
        ret[1][0][1] = R2;
        ret[1][1][1] = R1 * R2;
        ret[1][2][1] = R1 * R2;
        ret[1][0][2] = R2;
        ret[1][1][2] = R1 * R2;
        ret[1][2][2] = R1 * R2;
        ret[2][0][0] = 1.0;
        ret[2][1][0] = 1.0;
        ret[2][2][0] = R1;
        ret[2][0][1] = 1.0;
        ret[2][1][1] = 1.0;
        ret[2][2][1] = R1;
        ret[2][0][2] = R2;
        ret[2][1][2] = R2;
        ret[2][2][2] = R1 * R2;
        ret[3][0][0] = 1.0;
        ret[3][1][0] = 1.0;
        ret[3][2][0] = 1.0;
        ret[3][0][1] = 1.0;
        ret[3][1][1] = R1 * R2;
        ret[3][2][1] = R1 * R1 * R2;
        ret[3][0][2] = 1.0;
        ret[3][1][2] = R1 * R2 * R2;
        ret[3][2][2] = R1 * R1 * R2 * R2;
        ret[4][0][0] = 1.0;
        ret[4][1][0] = 1.0;
        ret[4][2][0] = 1.0;
        ret[4][0][1] = 1.0;
        ret[4][1][1] = R1 * R2;
        ret[4][2][1] = R1 * R2;
        ret[4][0][2] = 1.0;
        ret[4][1][2] = R1 * R2;
        ret[4][2][2] = R1 * R2;
        ret[5][0][0] = 1.0;
        ret[5][1][0] = 1.0;
        ret[5][2][0] = 1.0;
        ret[5][0][1] = 1.0;
        ret[5][1][1] = 1.0;
        ret[5][2][1] = 1.0;
        ret[5][0][2] = 1.0;
        ret[5][1][2] = 1.0;
        ret[5][2][2] = R1 * R2;
        ret[6][0][0] = 1.0;
        ret[6][1][0] = 1.0;
        ret[6][2][0] = 1.0;
        ret[6][0][1] = 1.0;
        ret[6][1][1] = 1.0;
        ret[6][2][1] = 1.0;
        ret[6][0][2] = 1.0;
        ret[6][1][2] = 1.0;
        ret[6][2][2] = k;
        ret[7][0][0] = 1.0;
        ret[7][1][0] = R1;
        ret[7][2][0] = R1 * R1;
        ret[7][0][1] = R2;
        ret[7][1][1] = R1 * R2 * k;
        ret[7][2][1] = R1 * R1 * R2 * k;
        ret[7][0][2] = R2 * R2;
        ret[7][1][2] = R1 * R2 * R2 * k;
        ret[7][2][2] = R1 * R1 * R2 * R2 * k * k;
        return ret;
    }

    public static double Maxr2(double AF1, double AF2) {
        double MAF1 = Math.min(AF1, 1.0 - AF1);
        double MAF2 = Math.min(AF2, 1.0 - AF2);
        double F1 = Math.min(MAF1, MAF2);
        double F2 = Math.max(MAF1, MAF2);
        double ret = F1 / (1.0 - F1) * (1.0 - F2) / F2;
        return ret;
    }

    public static double Maxr2Dposi(double AF1, double AF2) {
        double ret = AF1 < AF2 ? AF1 * (1.0 - AF2) / (1.0 - AF1) / AF2 : (1.0 - AF1) * AF2 / AF1 / (1.0 - AF2);
        return ret;
    }

    public static double[][] ChangeAlleleHapTwoLoci(double AF1, double AF2, double d) {
        double[][] ret = new double[2][2];
        ret[0][0] = AF1 * AF2 + d;
        ret[0][1] = AF1 * (1.0 - AF2) - d;
        ret[1][0] = (1.0 - AF1) * AF2 - d;
        ret[1][1] = (1.0 - AF1) * (1.0 - AF2) + d;
        return ret;
    }

    public static double[] ChangeHapAlleleTwoLoci(double[][] HapFreq) {
        double[] ret = new double[4];
        double AF1 = HapFreq[0][0] + HapFreq[0][1];
        double AF2 = HapFreq[0][0] + HapFreq[1][0];
        double d = HapFreq[0][0] - AF1 * AF2;
        double r2 = Math.exp(Math.log(HapFreq[0][0] * HapFreq[1][1] - HapFreq[1][0] * HapFreq[0][1]) * 2.0 - Math.log(AF1) - Math.log(AF2) - Math.log(1.0 - AF1) - Math.log(1.0 - AF2));
        ret[0] = AF1;
        ret[1] = AF2;
        ret[2] = d;
        ret[3] = r2;
        return ret;
    }

    public static double[][] ChangeHapGenoTwoLoci(double[][] HapFreq) {
        double[][] ret = new double[3][3];
        ret[0][0] = HapFreq[0][0] * HapFreq[0][0];
        ret[1][0] = HapFreq[0][0] * HapFreq[1][0] * 2.0;
        ret[2][0] = HapFreq[1][0] * HapFreq[1][0];
        ret[0][1] = HapFreq[0][0] * HapFreq[0][1] * 2.0;
        ret[1][1] = HapFreq[1][0] * HapFreq[0][1] * 2.0 + HapFreq[0][0] * HapFreq[1][1] * 2.0;
        ret[2][1] = HapFreq[1][0] * HapFreq[1][1] * 2.0;
        ret[0][2] = HapFreq[0][1] * HapFreq[0][1];
        ret[1][2] = HapFreq[0][1] * HapFreq[1][1] * 2.0;
        ret[2][2] = HapFreq[1][1] * HapFreq[1][1];
        return ret;
    }

    public static double[][] pairwiseEM(double[][] g) {
        double[] ret = new double[]{1.0, 1.0, 1.0, 1.0};
        double[][] retfin = new double[2][2];
        MiscUtilX.standard(ret);
        int max = 10000;
        double thres = 1.0E-10;
        boolean go = true;
        int counter = 0;
        double[] fix4 = new double[]{g[0][0] * 2.0 + g[0][1] + g[1][0], g[0][1] + g[0][2] * 2.0 + g[1][2], g[2][0] * 2.0 + g[1][0] + g[2][1], g[2][2] * 2.0 + g[1][2] + g[2][1]};
        double unfix = 1.0 * g[1][1];
        while (go) {
            double fraction = ret[0] * ret[3] / (ret[0] * ret[3] + ret[1] * ret[2]);
            double[] tmpret = new double[]{fix4[0] + fraction * unfix, fix4[1] + (1.0 - fraction) * unfix, fix4[2] + (1.0 - fraction) * unfix, fix4[3] + fraction * unfix};
            MiscUtilX.standard(tmpret);
            ++counter;
            double tmpmaxdif = Math.abs(tmpret[0] - ret[0]);
            int i = 1;
            while (i < tmpret.length) {
                double tmp = Math.abs(tmpret[i] - ret[i]);
                if (tmpmaxdif < tmp) {
                    tmpmaxdif = tmp;
                }
                ++i;
            }
            if (tmpmaxdif < thres) {
                go = false;
            }
            if (counter > max) {
                go = false;
            }
            ret = MiscUtilX.DeepCopyDouble1(tmpret);
        }
        retfin[0][0] = ret[0];
        retfin[1][0] = ret[2];
        retfin[0][1] = ret[1];
        retfin[1][1] = ret[3];
        return retfin;
    }

    public static double[][] pairwiseEM(int[][] g) {
        double[] ret = new double[]{1.0, 1.0, 1.0, 1.0};
        double[][] retfin = new double[2][2];
        MiscUtilX.standard(ret);
        int max = 10000;
        double thres = 1.0E-10;
        boolean go = true;
        int counter = 0;
        double[] fix4 = new double[]{g[0][0] * 2 + g[0][1] + g[1][0], g[0][1] + g[0][2] * 2 + g[1][2], g[2][0] * 2 + g[1][0] + g[2][1], g[2][2] * 2 + g[1][2] + g[2][1]};
        double unfix = 1 * g[1][1];
        while (go) {
            double fraction = ret[0] * ret[3] / (ret[0] * ret[3] + ret[1] * ret[2]);
            double[] tmpret = new double[]{fix4[0] + fraction * unfix, fix4[1] + (1.0 - fraction) * unfix, fix4[2] + (1.0 - fraction) * unfix, fix4[3] + fraction * unfix};
            MiscUtilX.standard(tmpret);
            ++counter;
            double tmpmaxdif = Math.abs(tmpret[0] - ret[0]);
            int i = 1;
            while (i < tmpret.length) {
                double tmp = Math.abs(tmpret[i] - ret[i]);
                if (tmpmaxdif < tmp) {
                    tmpmaxdif = tmp;
                }
                ++i;
            }
            if (tmpmaxdif < thres) {
                go = false;
            }
            if (counter > max) {
                go = false;
            }
            ret = MiscUtilX.DeepCopyDouble1(tmpret);
        }
        retfin[0][0] = ret[0];
        retfin[1][0] = ret[2];
        retfin[0][1] = ret[1];
        retfin[1][1] = ret[3];
        return retfin;
    }
}

