/*
 * Decompiled with CFR 0.152.
 */
package StepWisePheno;

import StepWisePheno.MultiPhenoTools;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.PlotTools;
import Tool.StatTools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class RPEmethod {
    public int NumPheno;
    public int NumRPE;
    public int[] RPEPheno;
    public int[] RPEDf;
    public int[] AssocPheno;
    public double[] RPEChi;
    public double[] RPEP;
    public double[] AssocChi;
    public double[] AssocP;
    public double[][] AssocOR;
    public boolean[] RPEleft;

    public static void main(String[] args) {
        int[][] Array = new int[][]{{177, 28}, {68, 4}, {31, 16}, {5, 3}, {712, 90}, {57, 22}, {56, 15}, {6, 1}, {58, 22}, {124, 60}, {422, 96}, {30, 4}, {56, 13}, {56, 33}, {35, 4}, {91, 33}, {47, 18}, {19, 10}, {11, 22}, {34, 9}, {131, 44}, {228, 43}, {21, 3}, {17, 9}};
        double ThresP = 0.01;
        try {
            String CorresFile = "P_Chi_CorresTable_mid.txt";
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            boolean[] left = new boolean[Array.length];
            int i = 0;
            while (i < Array.length) {
                left[i] = true;
                ++i;
            }
            RPEmethod RPE = new RPEmethod(Array, ThresP, CorresTableChi, chidf1);
            PlotTools.Array(RPE.AssocChi);
            PlotTools.Array(RPE.AssocP);
            PlotTools.Array2(RPE.AssocOR);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public RPEmethod(int[][] Array, double ThresP, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        int counter = 0;
        int NumPheno = Array.length;
        int[] tmpRPEPheno = new int[NumPheno];
        int[] tmpRPEDf = new int[NumPheno];
        int[][] tmpArray = ArrayTools.CopyArray2(Array);
        double[] tmpRPEChi = new double[NumPheno];
        double[] tmpRPEP = new double[NumPheno];
        boolean iter = true;
        this.RPEleft = new boolean[NumPheno];
        int i = 0;
        while (i < NumPheno) {
            this.RPEleft[i] = true;
            ++i;
        }
        while (iter) {
            tmpRPEChi[counter] = RPEmethod.ChiTestKx2withFlag(tmpArray, this.RPEleft);
            tmpRPEDf[counter] = NumPheno - 1 - counter;
            tmpRPEP[counter] = StatTools.TranslateChitoP(tmpRPEChi[counter], tmpRPEDf[counter], CorresTableChi, chidf1);
            double[] tmpChi = RPEmethod.ChiforEachRowMerged(tmpArray, this.RPEleft);
            tmpRPEPheno[counter] = RPEmethod.MaxValuePosi(tmpChi);
            if (tmpRPEP[counter] >= ThresP) {
                iter = false;
            } else {
                this.RPEleft[tmpRPEPheno[counter]] = false;
            }
            ++counter;
        }
        this.NumRPE = counter;
        this.RPEPheno = new int[this.NumRPE];
        this.RPEDf = new int[this.NumRPE];
        this.RPEChi = new double[this.NumRPE];
        this.RPEP = new double[this.NumRPE];
        i = 0;
        while (i < this.NumRPE) {
            this.RPEPheno[i] = tmpRPEPheno[i];
            this.RPEDf[i] = tmpRPEDf[i];
            this.RPEChi[i] = tmpRPEChi[i];
            this.RPEP[i] = tmpRPEP[i];
            ++i;
        }
        this.AssocPheno = new int[this.NumRPE - 1];
        this.AssocChi = new double[this.NumRPE - 1];
        this.AssocP = new double[this.NumRPE - 1];
        this.AssocOR = new double[this.NumRPE - 1][3];
        int[][] BaseArray = new int[][]{new int[2], new int[2]};
        counter = 0;
        int i2 = 0;
        while (i2 < NumPheno) {
            if (this.RPEleft[i2]) {
                int[] nArray = BaseArray[0];
                nArray[0] = nArray[0] + Array[i2][0];
                int[] nArray2 = BaseArray[0];
                nArray2[1] = nArray2[1] + Array[i2][1];
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < NumPheno) {
            if (!this.RPEleft[i2]) {
                this.AssocPheno[counter] = i2;
                BaseArray[1][0] = Array[i2][0];
                BaseArray[1][1] = Array[i2][1];
                this.AssocChi[counter] = MultiPhenoTools.ChiTestKx2(BaseArray);
                this.AssocP[counter] = StatTools.TranslateChitoP(this.AssocChi[counter], 1, CorresTableChi, chidf1);
                double[] tmp = StatTools.WoolfORwith95CI(BaseArray[1][0], BaseArray[1][1], BaseArray[0][0], BaseArray[0][1]);
                this.AssocOR[counter][0] = tmp[0];
                this.AssocOR[counter][1] = tmp[1];
                this.AssocOR[counter][2] = tmp[2];
                ++counter;
            }
            ++i2;
        }
    }

    public static double ChiTestKx2withFlag(int[][] Array, boolean[] flag) {
        int orglen = Array.length;
        int len = 0;
        int i = 0;
        while (i < orglen) {
            if (flag[i]) {
                ++len;
            }
            ++i;
        }
        int[][] SubstrArray = new int[len][Array[0].length];
        int counter = 0;
        int i2 = 0;
        while (i2 < orglen) {
            if (flag[i2]) {
                int j = 0;
                while (j < Array[0].length) {
                    SubstrArray[counter][j] = Array[i2][j];
                    ++j;
                }
                ++counter;
            }
            ++i2;
        }
        double ret = MultiPhenoTools.ChiTestKx2(SubstrArray);
        return ret;
    }

    public static int MaxValuePosi(double[] data) {
        int ret = -1;
        double tmp = -99.0;
        int i = 0;
        while (i < data.length) {
            if (data[i] > tmp) {
                tmp = data[i];
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static double[] ChiforEachRowMerged(int[][] Array, boolean[] flag) {
        int len = Array.length;
        double[] ret = new double[len];
        int i = 0;
        while (i < len) {
            if (flag[i]) {
                int[][] tmpArray = new int[2][2];
                ArrayTools.InitialaizeArray2(tmpArray);
                int j = 0;
                while (j < len) {
                    if (flag[j]) {
                        int k;
                        if (j != i) {
                            k = 0;
                            while (k < 2) {
                                int[] nArray = tmpArray[0];
                                int n = k;
                                nArray[n] = nArray[n] + Array[j][k];
                                ++k;
                            }
                        } else {
                            k = 0;
                            while (k < 2) {
                                int[] nArray = tmpArray[1];
                                int n = k;
                                nArray[n] = nArray[n] + Array[j][k];
                                ++k;
                            }
                        }
                    }
                    ++j;
                }
                ret[i] = MultiPhenoTools.ChiTestKx2(tmpArray);
            } else {
                ret[i] = -99.0;
            }
            ++i;
        }
        return ret;
    }
}

