/*
 * Decompiled with CFR 0.152.
 */
package QTLAnalysis;

import Algorithms.MersenneTwisterFast;
import QTLAnalysis.SerialDataGenerator;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.Tools;
import WorksFromRY.LinearRegression;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class PowerCalcLinear {
    public static void main(String[] args) {
        int N = 30000;
        int[] Nrep = new int[]{1000, 2000, 3000, 4000, 5000, 6000, 7000, 8000, 9000, 10000};
        int Iter = 5000;
        double AF1 = 0.513;
        double AF2 = 0.25;
        double[] AF1rep = new double[]{0.123, 0.42, 0.697, 0.619, 0.698, 0.668, 0.005, 0.466, 0.093, 0.422, 0.044, 0.6812};
        double[] AF2rep = new double[]{0.351, 0.513, 0.337, 0.303, 0.658, 0.544, 0.368, 0.466, 0.404, 0.505, 0.296, 0.4638};
        double Beta = 0.048;
        double[] BetaBMI = new double[]{0.08625, 0.03295, -0.01936};
        double[] Alpha = new double[]{0.05, 0.01, 0.001, 1.0E-4, 5.0E-5, 1.0E-5, 5.0E-6, 1.0E-6, 5.0E-7, 1.0E-7, 5.0E-8};
        String out = "";
        String prefix = "TestPower2";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                N = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Iter")) {
                Iter = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-AF1")) {
                AF1 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AF2")) {
                AF2 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-Beta")) {
                Beta = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        String CorresFile = "P_Chi_CorresTable_high.txt";
        int seed = 0;
        int x = 10000000;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
        String OutFile = String.valueOf(prefix) + "_N" + N + "_Iter" + Iter + "_Beta" + Beta + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(OutFile));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            int i2 = 0;
            while (i2 < AF1rep.length) {
                out = String.valueOf(AF1rep[i2]) + "\t" + AF2rep[i2] + "\t";
                double[] res = PowerCalcLinear.PowerCalcLinearTwoSNP(N, Iter, AF1rep[i2], AF2rep[i2], BetaBMI, Alpha, CorresTableChi, mz, chidf1);
                int j = 0;
                while (j < res.length) {
                    out = String.valueOf(out) + res[j] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[0], out);
                ++i2;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double[] PowerCalcLinearTwoSNP(int N, int Iter, double p1, double p2, double[] Beta, double[] Alpha, double[][] CorresTableChi, MersenneTwisterFast mz, ChiSquaredDistributionImpl chidf1) throws Exception {
        int numAlpha = Alpha.length;
        int[] Counter = new int[numAlpha];
        int[][] GenoCount = new int[3][3];
        ArrayTools.InitializeArray1(Counter);
        double[] Phen = new double[N];
        double[] Geno = new double[N];
        double[] ret = new double[numAlpha];
        double[][] GenoFreq = GenoTools.DecideGenoFreqHWE_2D(p1, p2);
        double[][] Mean = new double[3][3];
        double[] Var = new double[3];
        int i = 0;
        while (i < 3) {
            Mean[i][0] = 2.0 * Beta[i] * (p2 - 1.0);
            Mean[i][1] = Beta[i] * (2.0 * p2 - 1.0);
            Mean[i][2] = 2.0 * Beta[i] * p2;
            Var[i] = 1.0 - 2.0 * Beta[i] * Beta[i] * p2 * (1.0 - p2);
            ++i;
        }
        i = 0;
        while (i < Iter) {
            GenoCount = GenoTools.DecideGenoCount_2D(N, GenoFreq, mz);
            double[] Phen00 = SerialDataGenerator.RandNormalDist(Mean[0][0], Var[0], GenoCount[0][0], CorresTableChi, mz, chidf1);
            double[] Phen01 = SerialDataGenerator.RandNormalDist(Mean[0][1], Var[0], GenoCount[0][1], CorresTableChi, mz, chidf1);
            double[] Phen02 = SerialDataGenerator.RandNormalDist(Mean[0][2], Var[0], GenoCount[0][2], CorresTableChi, mz, chidf1);
            double[] Phen10 = SerialDataGenerator.RandNormalDist(Mean[1][0], Var[1], GenoCount[1][0], CorresTableChi, mz, chidf1);
            double[] Phen11 = SerialDataGenerator.RandNormalDist(Mean[1][1], Var[1], GenoCount[1][1], CorresTableChi, mz, chidf1);
            double[] Phen12 = SerialDataGenerator.RandNormalDist(Mean[1][2], Var[1], GenoCount[1][2], CorresTableChi, mz, chidf1);
            double[] Phen20 = SerialDataGenerator.RandNormalDist(Mean[2][0], Var[2], GenoCount[2][0], CorresTableChi, mz, chidf1);
            double[] Phen21 = SerialDataGenerator.RandNormalDist(Mean[2][1], Var[2], GenoCount[2][1], CorresTableChi, mz, chidf1);
            double[] Phen22 = SerialDataGenerator.RandNormalDist(Mean[2][2], Var[2], GenoCount[2][2], CorresTableChi, mz, chidf1);
            double[] Geno00 = ArrayTools.RepeatArray(GenoCount[0][0], 0.0);
            double[] Geno01 = ArrayTools.RepeatArray(GenoCount[0][1], 1.0);
            double[] Geno02 = ArrayTools.RepeatArray(GenoCount[0][2], 2.0);
            double[] Geno10 = ArrayTools.RepeatArray(GenoCount[1][0], 0.0);
            double[] Geno11 = ArrayTools.RepeatArray(GenoCount[1][1], 1.0);
            double[] Geno12 = ArrayTools.RepeatArray(GenoCount[1][2], 2.0);
            double[] Geno20 = ArrayTools.RepeatArray(GenoCount[2][0], 0.0);
            double[] Geno21 = ArrayTools.RepeatArray(GenoCount[2][1], 1.0);
            double[] Geno22 = ArrayTools.RepeatArray(GenoCount[2][2], 2.0);
            Phen = Tools.MixArray3(Tools.MixArray3(Phen00, Phen01, Phen02), Tools.MixArray3(Phen10, Phen11, Phen12), Tools.MixArray3(Phen20, Phen21, Phen22));
            Geno = Tools.MixArray3(Tools.MixArray3(Geno00, Geno01, Geno02), Tools.MixArray3(Geno10, Geno11, Geno12), Tools.MixArray3(Geno20, Geno21, Geno22));
            LinearRegression lr = new LinearRegression(Phen, Geno);
            double P = lr.p;
            int j = 0;
            while (j < numAlpha) {
                if (P < Alpha[j]) {
                    int n = j;
                    Counter[n] = Counter[n] + 1;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < numAlpha) {
            ret[i] = (double)Counter[i] / (double)Iter;
            ++i;
        }
        return ret;
    }

    public static double[] PowerCalcLineaarOneSNP(int N, int Iter, double p, double Beta, double[] Alpha, double[][] CorresTableChi, MersenneTwisterFast mz, ChiSquaredDistributionImpl chidf1) throws Exception {
        int numAlpha = Alpha.length;
        int[] GenoCount = new int[3];
        int[] Counter = new int[numAlpha];
        ArrayTools.InitializeArray1(Counter);
        double[] Phen = new double[N];
        double[] Geno = new double[N];
        double[] ret = new double[numAlpha];
        double[] GenoFreq = new double[3];
        double[] Mean = new double[3];
        GenoFreq[0] = p * p;
        GenoFreq[1] = 2.0 * p * (1.0 - p);
        GenoFreq[2] = (1.0 - p) * (1.0 - p);
        Mean[0] = 2.0 * Beta * (p - 1.0);
        Mean[1] = Beta * (2.0 * p - 1.0);
        Mean[2] = 2.0 * Beta * p;
        double Var = 1.0 - 2.0 * Beta * Beta * p * (1.0 - p);
        int i = 0;
        while (i < Iter) {
            GenoCount = SerialDataGenerator.CountData1SNP(N, GenoFreq, mz);
            int counter = 0;
            int j = 0;
            while (j < GenoCount.length) {
                int k = 0;
                while (k < GenoCount[j]) {
                    Geno[counter] = j;
                    ++counter;
                    ++k;
                }
                ++j;
            }
            double[] Phen0 = SerialDataGenerator.RandNormalDist(Mean[0], Var, GenoCount[0], CorresTableChi, mz, chidf1);
            double[] Phen1 = SerialDataGenerator.RandNormalDist(Mean[1], Var, GenoCount[1], CorresTableChi, mz, chidf1);
            double[] Phen2 = SerialDataGenerator.RandNormalDist(Mean[2], Var, GenoCount[2], CorresTableChi, mz, chidf1);
            Phen = Tools.MixArray3(Phen0, Phen1, Phen2);
            LinearRegression lr = new LinearRegression(Phen, Geno);
            double P = lr.p;
            int j2 = 0;
            while (j2 < numAlpha) {
                if (P < Alpha[j2]) {
                    int n = j2;
                    Counter[n] = Counter[n] + 1;
                }
                ++j2;
            }
            ++i;
        }
        i = 0;
        while (i < numAlpha) {
            ret[i] = (double)Counter[i] / (double)Iter;
            ++i;
        }
        return ret;
    }
}

