/*
 * Decompiled with CFR 0.152.
 */
package QTLAnalysis;

import Algorithms.MersenneTwisterFast;
import QTLAnalysis.SerialDataGenerator;
import Tool.FileTools;
import Tool.Quicksort;
import Tool.RegressTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class PartialPerm {
    public static void main(String[] args) {
        int N = 1000;
        int PartN = 150;
        int Perm = 100;
        double AF = 0.5;
        double ThresFinBeta = 0.1;
        double ThresPartBeta = 0.1;
        String prefix = "PartialPermTime";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                N = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-PartN")) {
                PartN = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Perm")) {
                Perm = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-AF")) {
                AF = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-ThresFinBeta")) {
                ThresFinBeta = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-ThresPartBeta")) {
                ThresPartBeta = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        double[] genofreq = new double[]{AF * AF, 2.0 * AF * (1.0 - AF), (1.0 - AF) * (1.0 - AF)};
        String CorresFile = "P_Chi_CorresTable_high.txt";
        int seed = (int)(1.0E7 * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
        BufferedWriter bwLog = null;
        String outfile = String.valueOf(prefix) + "_N" + N + "_PartN" + PartN + "_Perm" + Perm + "_AF" + AF + "_TFB" + ThresFinBeta + "_TPB" + ThresPartBeta + "_log.txt";
        try {
            bwLog = new BufferedWriter(new FileWriter(outfile));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            double[] x = SerialDataGenerator.RandNormalDist(0.0, 1.0, N, CorresTableChi, mz, chidf1);
            double[] y = SerialDataGenerator.SerialData1SNP(N, genofreq, mz);
            double[] noise = SerialDataGenerator.RandNormalDist(0.0, 0.001, N, CorresTableChi, mz, chidf1);
            int i2 = 0;
            while (i2 < N) {
                y[i2] = y[i2] + noise[i2];
                ++i2;
            }
            double[] y2 = new double[N];
            long timeSt = System.currentTimeMillis();
            int i3 = 0;
            while (i3 < Perm) {
                y2 = PartialPerm.PartialPerm(x, y, PartN, ThresFinBeta, ThresPartBeta, mz);
                ++i3;
            }
            long timeEd = System.currentTimeMillis();
            double meantime = ((double)timeEd - (double)timeSt) / (double)Perm / 1000.0;
            String out = "N\tPartN\tPerm\tAF\tTFB\tTPB\tmeanTime\n";
            out = String.valueOf(out) + prefix + "\t" + N + "\t" + PartN + "\t" + Perm + "\t" + AF + "\t" + ThresFinBeta + "\t" + ThresPartBeta + "\t" + meantime + "\n";
            FileTools.out3File(bwLog, out);
            bwLog.close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double[] PartialPerm(double[] x, double[] y, int PartN, double ThresFinBeta, double ThresPartBeta, MersenneTwisterFast mz) {
        int N = y.length;
        double[] ret = PartialPerm.Perm(y, mz);
        double[] Partret = new double[PartN];
        double[] Partx = new double[PartN];
        double[][] array = new double[N][2];
        boolean Rep = true;
        boolean PartRep = true;
        while (Rep) {
            double Beta = RegressTools.LinearRegress(x, ret)[1];
            if (ThresFinBeta >= 0.0 && Beta >= ThresFinBeta || ThresFinBeta < 0.0 && Beta <= ThresFinBeta) {
                Rep = false;
                continue;
            }
            int i = 0;
            while (i < N) {
                array[i][0] = i;
                array[i][1] = mz.nextDouble();
                ++i;
            }
            Quicksort.sortDouble2_2(array);
            int j = 0;
            while (j < PartN) {
                Partret[j] = ret[(int)array[j][0]];
                Partx[j] = x[(int)array[j][0]];
                ++j;
            }
            PartRep = true;
            while (PartRep) {
                double PartBeta = RegressTools.LinearRegress(Partx, Partret)[1];
                if (ThresPartBeta >= 0.0 && PartBeta >= ThresPartBeta || ThresPartBeta < 0.0 && Beta <= ThresPartBeta) {
                    PartRep = false;
                    continue;
                }
                Partret = PartialPerm.Perm(Partret, mz);
            }
            j = 0;
            while (j < PartN) {
                ret[(int)array[j][0]] = Partret[j];
                ++j;
            }
        }
        return ret;
    }

    public static double[] Perm(double[] y, MersenneTwisterFast mz) {
        int N = y.length;
        double[] ret = new double[N];
        double[][] array = new double[N][2];
        int i = 0;
        while (i < N) {
            array[i][0] = y[i];
            array[i][1] = mz.nextDouble();
            ++i;
        }
        Quicksort.sortDouble2_2(array);
        i = 0;
        while (i < N) {
            ret[i] = array[i][0];
            ++i;
        }
        return ret;
    }
}

