/*
 * Decompiled with CFR 0.152.
 */
package PairLD;

import PairLD.LDTools;
import PairLD.LDinflation;
import Tool.FileTools;
import Tool.GenoTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class PairwiseLDinflation {
    public static void main(String[] args) {
        double[] af = new double[2];
        byte[] byArray = new byte[9];
        byArray[1] = 1;
        byArray[2] = 1;
        byArray[3] = 2;
        byArray[4] = -1;
        byArray[5] = -1;
        byArray[6] = -1;
        byArray[7] = -1;
        byArray[8] = -1;
        byte[] genotypeNum = byArray;
        String inputfile = "test_serial_1";
        String inputfileList = "";
        String inputfilePheno = "";
        String[] genotype = new String[]{"1 1", "1 2", "2 1", "2 2", "0 0", "0 1", "1 0", "0 2", "2 0"};
        String outfileBlock = "";
        String outfileSum = "";
        String out = "";
        boolean list = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-SNPlist")) {
                list = true;
            }
            ++i;
        }
        outfileBlock = String.valueOf(outfileBlock) + inputfile + "_LDinfla_Block.txt";
        outfileSum = String.valueOf(outfileSum) + inputfile + "_LDinfla.txt";
        inputfileList = String.valueOf(inputfile) + ".info";
        inputfilePheno = String.valueOf(inputfile) + ".phen";
        inputfile = String.valueOf(inputfile) + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        try {
            int i2;
            bw[0] = new BufferedWriter(new FileWriter(outfileBlock));
            bw[1] = new BufferedWriter(new FileWriter(outfileSum));
            byte[][] GenoArray = GenoTools.GenotypeConvert(inputfile, genotype, genotypeNum);
            int numSNP = GenoArray[0].length;
            int numSample = GenoArray.length;
            String[] SNPlist = new String[numSNP];
            byte[] Phen = new byte[numSample];
            if (list) {
                String[][] tmpS = FileTools.readDatFileIOStringTABString(inputfileList);
                i2 = 0;
                while (i2 < numSNP) {
                    SNPlist[i2] = tmpS[i2][0];
                    ++i2;
                }
            } else {
                i2 = 0;
                while (i2 < numSNP) {
                    SNPlist[i2] = "SNP" + (i2 + 1);
                    ++i2;
                }
            }
            byte[][] tmpB = FileTools.readDatFileIOStringTABbyte(inputfilePheno);
            i2 = 0;
            while (i2 < numSample) {
                Phen[i2] = tmpB[i2][0];
                ++i2;
            }
            byte[] SNP1 = new byte[numSample];
            byte[] SNP2 = new byte[numSample];
            double[][] LDBlock = new double[numSNP][numSNP];
            double prev = 0.01;
            double minDiff = -1.0;
            double maxDiff = 1.0;
            double keta = 1.0E-14;
            int kizami = 100;
            int H0 = 50;
            int[][] geno = new int[3][3];
            int[][][] genoSep = new int[2][3][3];
            int[][] geno1 = new int[3][3];
            int[][] geno2 = new int[3][3];
            double[] riskDiff = new double[kizami + 1];
            double Diff = (maxDiff - minDiff) / (double)kizami;
            int i3 = 0;
            while (i3 < kizami + 1) {
                riskDiff[i3] = minDiff + (double)i3 * Diff;
                ++i3;
            }
            out = "SNP1\tSNP2\t11_11\t12_11\t22_11\t11_12\t12_12\t22_12\t11_22\t12_22\t22_22\t11_11-2\t12_11-2\t22_11-2\t11_12-2\t12_12-2\t22_12-2\t11_22-2\t12_22-2\t22_22-2\t11_11-1\t12_11-1\t22_11-1\t11_12-1\t12_12-1\t22_12-1\t11_22-1\t12_22-1\t22_22-1\taf_1\taf_2\thf_12\thf_1\thf_2\thf_\t";
            out = String.valueOf(out) + "like12\tlike10\tlike02\tldiff10\tldiff02\n";
            FileTools.out3File(bw[1], out);
            i3 = 0;
            while (i3 < numSNP - 1) {
                int j = i3 + 1;
                while (j < numSNP) {
                    int k = 0;
                    while (k < numSample) {
                        SNP1[k] = GenoArray[k][i3];
                        SNP2[k] = GenoArray[k][j];
                        ++k;
                    }
                    geno = LDTools.make3x3table(SNP1, SNP2);
                    geno1 = LDTools.make3x3tablePheno(SNP1, SNP2, Phen, 1);
                    geno2 = LDTools.make3x3tablePheno(SNP1, SNP2, Phen, 2);
                    genoSep = LDTools.Combine3x3table(geno1, geno2);
                    double[] hf = LDTools.pairwiseEM(geno);
                    af[0] = hf[0] + hf[1];
                    af[1] = hf[0] + hf[2];
                    double[] LDLike = LDinflation.FindMaxLike2(LDinflation.LDinflationLike(genoSep, prev, minDiff, maxDiff, kizami), H0, H0);
                    double r2 = LDTools.Rsq(hf);
                    double D = LDTools.D(hf);
                    double Dprime = LDTools.Dprime(hf);
                    LDBlock[i3][j] = r2;
                    LDBlock[j][i3] = Math.abs(Dprime);
                    out = String.valueOf(SNPlist[i3]) + "\t" + SNPlist[j] + "\t" + geno[0][0] + "\t" + geno[0][1] + "\t" + geno[0][2] + "\t" + geno[1][0] + "\t" + geno[1][1] + "\t" + geno[1][2] + "\t" + geno[2][0] + "\t" + geno[2][1] + "\t" + geno[2][2] + "\t" + geno2[0][0] + "\t" + geno2[0][1] + "\t" + geno2[0][2] + "\t" + geno2[1][0] + "\t" + geno2[1][1] + "\t" + geno2[1][2] + "\t" + geno2[2][0] + "\t" + geno2[2][1] + "\t" + geno2[2][2] + "\t" + geno1[0][0] + "\t" + geno1[0][1] + "\t" + geno1[0][2] + "\t" + geno1[1][0] + "\t" + geno1[1][1] + "\t" + geno1[1][2] + "\t" + geno1[2][0] + "\t" + geno1[2][1] + "\t" + geno1[2][2] + "\t" + af[1] + "\t" + af[0] + "\t" + hf[0] + "\t" + hf[2] + "\t" + hf[1] + "\t" + hf[3] + "\t";
                    out = String.valueOf(out) + LDLike[0] + "\t" + LDLike[2] + "\t" + LDLike[1] + "\t" + (LDLike[0] - LDLike[2]) + "\t" + (LDLike[0] - LDLike[1]) + "\t" + riskDiff[(int)LDLike[3]] + "\t" + riskDiff[(int)LDLike[4]] + "\t" + riskDiff[(int)LDLike[6]] + "\t" + riskDiff[(int)LDLike[5]] + "\t" + LDLike[8] + "\t" + LDLike[7] + "\n";
                    FileTools.out3File(bw[1], out);
                    ++j;
                }
                ++i3;
            }
            out = "-/-\t";
            i3 = 0;
            while (i3 < numSNP) {
                out = String.valueOf(out) + SNPlist[i3] + "\t";
                ++i3;
            }
            out = String.valueOf(out) + "\n";
            FileTools.out3File(bw[0], out);
            int j = 0;
            while (j < numSNP) {
                out = String.valueOf(SNPlist[j]) + "\t";
                LDBlock[j][j] = 0.0;
                int i4 = 0;
                while (i4 < numSNP) {
                    out = String.valueOf(out) + LDBlock[i4][j] + "\t";
                    ++i4;
                }
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[0], out);
                ++j;
            }
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

