/*
 * Decompiled with CFR 0.152.
 */
package Mains_meta;

import Algorithms.MersenneTwisterFast;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class RefMatrixHeteroAFs {
    public static void main(String[] args) {
        int AFgrids = 50;
        int numGroup = 2;
        int numStoreSNP = 5000;
        int seedgiven = 0;
        String prefix = "test_grid";
        String out = "";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-AFgrids")) {
                AFgrids = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numGroup")) {
                numGroup = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numStoreSNP")) {
                numStoreSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        double[] OR = new double[numGroup];
        short[] numCase = new short[numGroup];
        short[] numCont = new short[numGroup];
        String outfilelog = String.valueOf(prefix) + "_log.txt";
        String[] outfiledata = new String[numGroup];
        int i2 = 0;
        while (i2 < numGroup) {
            OR[i2] = 1.0;
            numCase[i2] = 1000;
            numCont[i2] = 1000;
            outfiledata[i2] = String.valueOf(prefix) + "_data_" + i2 + ".txt";
            ++i2;
        }
        i2 = 0;
        while (i2 < args.length) {
            int j;
            if (args[i2].equals("-OR")) {
                j = 0;
                while (j < numGroup) {
                    OR[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-numCase")) {
                j = 0;
                while (j < numGroup) {
                    numCase[j] = Short.parseShort(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-numCont")) {
                j = 0;
                while (j < numGroup) {
                    numCont[j] = Short.parseShort(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-thres")) {
                j = 0;
                while (j < numGroup) {
                    numCont[j] = Short.parseShort(args[i2 + 1 + j]);
                    ++j;
                }
            }
            ++i2;
        }
        BufferedWriter[] bw1 = new BufferedWriter[numGroup];
        try {
            out = "Log file of RefMatrixHeteroAFs.java\nprefix\t" + prefix + "\nNo. group:\t" + numGroup + "\nAF grids:\t" + AFgrids + "\nNo. storeSNPs:\t" + numStoreSNP + "\nGroup/OR/No. case/No. control:\n";
            BufferedWriter bw0 = new BufferedWriter(new FileWriter(outfilelog));
            int i3 = 0;
            while (i3 < numGroup) {
                bw1[i3] = new BufferedWriter(new FileWriter(outfiledata[i3]));
                out = String.valueOf(out) + "\t" + i3 + "\t" + OR[i3] + "\t" + numCase[i3] + "\t" + numCont[i3] + "\n";
                ++i3;
            }
            out = String.valueOf(out) + "seed:\t" + seed + "\nStarted at:" + "\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw0, out);
            double[] AFrange = new double[AFgrids + 1];
            double[][] CausGenoCase = new double[3][2];
            double[][] CausGenoCont = new double[3][2];
            int i4 = 0;
            while (i4 < AFgrids + 1) {
                AFrange[i4] = 1.0 / (double)AFgrids * (double)i4;
                ++i4;
            }
            i4 = 0;
            while (i4 < numGroup) {
                boolean Next = false;
                int[] AFcount = new int[AFgrids];
                int AFcountTotal = 0;
                int j = 0;
                while (j < AFgrids) {
                    AFcount[j] = 0;
                    ++j;
                }
                while (!Next) {
                    int WhichAF;
                    int[] tmpCont;
                    int[] tmpCase;
                    double tmpAf;
                    double tmpAfCaseOR = tmpAf = mz.nextDouble();
                    double tmpAfContOR = tmpAf;
                    if (OR[i4] != 1.0) {
                        CausGenoCase = GenoTools.CaseContAf(tmpAfCaseOR, 1.0 / OR[i4], 1.0E-5);
                        tmpCase = GenoTools.ChangeAddsinglesingle(GenoTools.GenoCountCausal(numCase[i4], CausGenoCase[0][0], CausGenoCase[1][0], CausGenoCase[2][0], 1.0, mz));
                        CausGenoCont = GenoTools.CaseContAf(tmpAfContOR, OR[i4], 1.0E-5);
                        tmpCont = GenoTools.ChangeAddsinglesingle(GenoTools.GenoCountCausal(numCont[i4], CausGenoCont[0][1], CausGenoCont[1][1], CausGenoCont[2][1], 1.0, mz));
                    } else {
                        tmpCase = GenoTools.ChangeAddsinglesingle(GenoTools.GenoCount(numCase[i4], tmpAfCaseOR, 1.0, mz));
                        tmpCont = GenoTools.ChangeAddsinglesingle(GenoTools.GenoCount(numCont[i4], tmpAfContOR, 1.0, mz));
                    }
                    double tmpAfCase = (double)tmpCase[0] / (double)(tmpCase[0] + tmpCase[1]);
                    double tmpAfCont = (double)tmpCont[0] / (double)(tmpCont[0] + tmpCont[1]);
                    if (tmpAfCase * (1.0 - tmpAfCase) * tmpAfCont * (1.0 - tmpAfCont) == 0.0 || AFcount[WhichAF = ArrayTools.WhichSegment(AFrange, tmpAfCont)] >= numStoreSNP) continue;
                    out = String.valueOf(WhichAF) + "\t" + AFcount[WhichAF] + "\t" + tmpCase[0] + "\t" + tmpCase[1] + "\t" + tmpCont[0] + "\t" + tmpCont[1] + "\n";
                    FileTools.out3File(bw1[i4], out);
                    int n = WhichAF;
                    AFcount[n] = AFcount[n] + 1;
                    if (AFcount[WhichAF] != numStoreSNP) continue;
                    System.out.println(++AFcountTotal);
                    if (AFcountTotal != AFgrids) continue;
                    Next = true;
                }
                ++i4;
            }
            out = "Ended at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw0, out);
            bw0.close();
            i4 = 0;
            while (i4 < numGroup) {
                bw1[i4].close();
                ++i4;
            }
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

