/*
 * Decompiled with CFR 0.152.
 */
package Likelihood;

import Likelihood.TableManage;
import Tool.PlotTools;

public class TableLike3x3x2LD {
    public static void main(String[] args) {
        int Pk = 100;
        int Maxrep = 1000;
        int testtype = 0;
        int[][][] data3x3 = new int[][][]{new int[][]{{82, 105, 62}, {146, 240, 126}, {69, 115, 55}}, new int[][]{{42, 109, 100}, {82, 234, 165}, {37, 131, 100}}};
        double kizOR = 1.01;
        double ThresL = Math.pow(10.0, -10.0);
        double boost = 50.0;
        boolean[] H1flag = new boolean[]{true, true};
        PlotTools.Array(TableLike3x3x2LD.CalcMaxLike3x3(data3x3, H1flag, testtype, Pk, kizOR, Maxrep, ThresL, boost));
        PlotTools.Array2(TableLike3x3x2LD.CalcLike3x3H0H1(data3x3, testtype, Pk, kizOR, Maxrep, ThresL, boost));
    }

    public static double[][] CalcLike3x3H0H1(int[][][] array, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[][] ret = new double[4][4];
        boolean[] H0H0 = new boolean[2];
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] H1H0 = blArray;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        boolean[] H0H1 = blArray2;
        boolean[] H1H1 = new boolean[]{true, true};
        double[] LikeH0H0 = TableLike3x3x2LD.CalcMaxLike3x3(array, H0H0, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH1H0 = TableLike3x3x2LD.CalcMaxLike3x3(array, H1H0, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH0H1 = TableLike3x3x2LD.CalcMaxLike3x3(array, H0H1, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH1H1 = TableLike3x3x2LD.CalcMaxLike3x3(array, H1H1, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        int i = 0;
        while (i < LikeH0H0.length) {
            ret[0][i] = LikeH0H0[i];
            ret[1][i] = LikeH1H0[i];
            ret[2][i] = LikeH0H1[i];
            ret[3][i] = LikeH1H1[i];
            ++i;
        }
        return ret;
    }

    public static double[] CalcMaxLike3x3(int[][][] array, boolean[] H1flag, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[] ret = new double[4];
        int boostcounter = 0;
        int[] flagOR = new int[2];
        int[][] TotalArray = TableManage.CombineTable(array);
        int[][] ContArray = TableManage.ExtractTable(array, 0);
        int[][] CaseArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] ContFreq = TableManage.GetFreq(ContArray);
        double[][] CaseFreq = TableManage.GetFreq(CaseArray);
        double[] OR = new double[]{};
        double[] tmpOR = TableLike3x3x2LD.CalcBaseRiskFrom3x3(CaseArray, ContArray, testtype);
        double[] tmpOR0 = new double[2];
        double[] tmpOR1 = new double[2];
        double counter = 0.0;
        double L = -9.99999999E8;
        boolean iter = true;
        if (!H1flag[0]) {
            tmpOR[0] = 1.0;
        }
        if (!H1flag[1]) {
            tmpOR[1] = 1.0;
        }
        while (iter) {
            if (H1flag[0]) {
                tmpOR0[0] = tmpOR[0] / kizOR;
                tmpOR0[1] = tmpOR[0] * kizOR;
                tmpOR1[0] = tmpOR[1];
                tmpOR1[1] = tmpOR[1];
                flagOR[0] = TableLike3x3x2LD.FindHighestLikeORs(L, ContArray, CaseArray, ContFreq, tmpOR0, tmpOR1, testtype);
            } else {
                tmpOR0[0] = 1.0;
                tmpOR0[1] = 1.0;
                tmpOR1[0] = tmpOR[1];
                tmpOR1[1] = tmpOR[1];
                flagOR[0] = -99;
            }
            if (H1flag[1]) {
                tmpOR0[0] = tmpOR[0];
                tmpOR0[1] = tmpOR[0];
                tmpOR1[0] = tmpOR[1] / kizOR;
                tmpOR1[1] = tmpOR[1] * kizOR;
                flagOR[1] = TableLike3x3x2LD.FindHighestLikeORs(L, ContArray, CaseArray, ContFreq, tmpOR0, tmpOR1, testtype);
            } else {
                tmpOR0[0] = tmpOR[0];
                tmpOR0[1] = tmpOR[0];
                tmpOR1[0] = 1.0;
                tmpOR1[1] = 1.0;
                flagOR[1] = -99;
            }
            tmpOR = TableLike3x3x2LD.DecideORsfromFlag(tmpOR, flagOR, kizOR);
            double[][] tmpRArray = TableLike3x3x2LD.CalcRisk3x3FromR1R2(tmpOR[0], tmpOR[1], testtype);
            double[][][] tmpFreq = TableLike3x3x2LD.EstimateFreqFrom3x3OR(ContFreq, tmpRArray);
            double[][] tmpContFreq = TableManage.ExtractTable(tmpFreq, 0);
            double[][] tmpCaseFreq = TableManage.ExtractTable(tmpFreq, 1);
            double tmpL = TableLike3x3x2LD.LikeArray(ContArray, tmpContFreq) + TableLike3x3x2LD.LikeArray(CaseArray, tmpCaseFreq);
            if (tmpL - L > ThresL) {
                L = tmpL;
                OR = tmpOR;
            } else {
                kizOR = 1.0 + (kizOR - 1.0) / boost;
                if (boostcounter == 1) {
                    iter = false;
                }
                ++boostcounter;
            }
            counter += 1.0;
        }
        ret[0] = OR[0];
        ret[1] = OR[1];
        ret[2] = L;
        ret[3] = counter;
        return ret;
    }

    public static double[] DecideORsfromFlag(double[] tmpOR, int[] flag, double kizOR) {
        double[] ret = new double[tmpOR.length];
        int i = 0;
        while (i < tmpOR.length) {
            if (flag[i] == 0) {
                ret[i] = tmpOR[i] / kizOR;
            } else if (flag[i] == 1) {
                ret[i] = tmpOR[i] * kizOR;
            } else if (flag[i] == -99) {
                ret[i] = tmpOR[i];
            }
            ++i;
        }
        return ret;
    }

    public static int FindHighestLikeORs(double BaseL, int[][] ContArray, int[][] CaseArray, double[][] ContFreq, double[] OR1, double[] OR2, int testtype) {
        int len = OR1.length;
        int ret = -99;
        int i = 0;
        while (i < len) {
            double[][] tmpRArray = TableLike3x3x2LD.CalcRisk3x3FromR1R2(OR1[i], OR2[i], testtype);
            double[][][] tmpFreq = TableLike3x3x2LD.EstimateFreqFrom3x3OR(ContFreq, tmpRArray);
            double[][] tmpContFreq = TableManage.ExtractTable(tmpFreq, 0);
            double[][] tmpCaseFreq = TableManage.ExtractTable(tmpFreq, 1);
            double tmpL = TableLike3x3x2LD.LikeArray(ContArray, tmpContFreq) + TableLike3x3x2LD.LikeArray(CaseArray, tmpCaseFreq);
            if (tmpL > BaseL) {
                BaseL = tmpL;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static double LikeArray(int[][] array, double[][] Freq) {
        double L = 0.0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                if (Freq[i][j] != 0.0 && array[i][j] != 0) {
                    L += (double)array[i][j] * Math.log(Freq[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return L;
    }

    public static double[][][] EstimateFreqFrom3x3OR(double[][] ContFreq, double[][] ORArray) {
        int j;
        double[][][] ret = new double[2][ContFreq.length][ContFreq[0].length];
        double N = 0.0;
        int i = 0;
        while (i < ContFreq.length) {
            j = 0;
            while (j < ContFreq[0].length) {
                ret[0][i][j] = ContFreq[i][j];
                ret[1][i][j] = ContFreq[i][j] * ORArray[i][j];
                N += ContFreq[i][j] * ORArray[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ContFreq.length) {
            j = 0;
            while (j < ContFreq[0].length) {
                double[] dArray = ret[1][i];
                int n = j++;
                dArray[n] = dArray[n] / N;
            }
            ++i;
        }
        return ret;
    }

    public static double[][] CalcRisk3x3FromR1R2(double R1, double R2, int testtype) {
        double[][] ret = new double[3][3];
        if (testtype == 0) {
            ret[0][0] = 1.0 / (R1 * R2);
            ret[1][0] = 1.0 / R2;
            ret[2][0] = R1 / R2;
            ret[0][1] = 1.0 / R1;
            ret[1][1] = 1.0;
            ret[2][1] = R1;
            ret[0][2] = R2 / R1;
            ret[1][2] = R2;
            ret[2][2] = R1 * R2;
        } else if (testtype != 1) {
            if (testtype == 2) {
                ret[0][0] = 1.0 / (R1 * R2);
                ret[1][0] = 1.0 / R2;
                ret[2][0] = 1.0 / R2;
                ret[0][1] = 1.0 / R1;
                ret[1][1] = 1.0;
                ret[2][1] = 1.0;
                ret[0][2] = 1.0 / R1;
                ret[1][2] = 1.0;
                ret[2][2] = 1.0;
            } else if (testtype == 3) {
                ret[0][0] = 1.0;
                ret[1][0] = 1.0;
                ret[2][0] = R1;
                ret[0][1] = 1.0;
                ret[1][1] = 1.0;
                ret[2][1] = R1;
                ret[0][2] = R2;
                ret[1][2] = R2;
                ret[2][2] = R1 * R2;
            }
        }
        return ret;
    }

    public static double[] CalcBaseRiskFrom3x3(int[][] ContArray, int[][] CaseArray, int testtype) {
        double[] ret = new double[2];
        double[] tmpAF = new double[2];
        int[][] Array = TableLike3x3x2LD.Change3x3x2To3x2(ContArray, CaseArray);
        int i = 0;
        while (i < 2) {
            if (testtype == 0) {
                tmpAF[1] = (double)(Array[i][5] * 2 + Array[i][4]) / ((double)(Array[i][3] + Array[i][4] + Array[i][5]) * 2.0);
                tmpAF[0] = (double)(Array[i][2] * 2 + Array[i][1]) / ((double)(Array[i][0] + Array[i][1] + Array[i][2]) * 2.0);
                ret[i] = tmpAF[0] / (1.0 - tmpAF[0]) * (1.0 - tmpAF[1]) / tmpAF[1];
            } else if (testtype != 1) {
                if (testtype == 2) {
                    tmpAF[1] = (double)(Array[i][5] + Array[i][4]) / (double)(Array[i][3] + Array[i][4] + Array[i][5]);
                    tmpAF[0] = (double)(Array[i][2] + Array[i][1]) / (double)(Array[i][2] + Array[i][1] + Array[i][0]);
                    ret[i] = tmpAF[0] / (1.0 - tmpAF[0]) * (1.0 - tmpAF[1]) / tmpAF[1];
                } else if (testtype == 3) {
                    tmpAF[1] = (double)Array[i][5] / (double)(Array[i][3] + Array[i][4] + Array[i][5]);
                    tmpAF[0] = (double)Array[i][2] / (double)(Array[i][2] + Array[i][1] + Array[i][0]);
                    ret[i] = tmpAF[0] / (1.0 - tmpAF[0]) * (1.0 - tmpAF[1]) / tmpAF[1];
                }
            }
            ++i;
        }
        return ret;
    }

    public static int[][] Change3x3x2To3x2(int[][] ContArray, int[][] CaseArray) {
        int[][] ret = new int[2][6];
        ret[0][0] = ContArray[0][0] + ContArray[0][1] + ContArray[0][2];
        ret[0][1] = ContArray[1][0] + ContArray[1][1] + ContArray[1][2];
        ret[0][2] = ContArray[2][0] + ContArray[2][1] + ContArray[2][2];
        ret[0][3] = CaseArray[0][0] + CaseArray[0][1] + CaseArray[0][2];
        ret[0][4] = CaseArray[1][0] + CaseArray[1][1] + CaseArray[1][2];
        ret[0][5] = CaseArray[2][0] + CaseArray[2][1] + CaseArray[2][2];
        ret[1][0] = ContArray[0][0] + ContArray[1][0] + ContArray[2][0];
        ret[1][1] = ContArray[0][1] + ContArray[1][1] + ContArray[2][1];
        ret[1][2] = ContArray[0][2] + ContArray[1][2] + ContArray[2][2];
        ret[1][3] = CaseArray[0][0] + CaseArray[1][0] + CaseArray[2][0];
        ret[1][4] = CaseArray[0][1] + CaseArray[1][1] + CaseArray[2][1];
        ret[1][5] = CaseArray[0][2] + CaseArray[1][2] + CaseArray[2][2];
        return ret;
    }
}

