/*
 * Decompiled with CFR 0.152.
 */
package ImputedGeno;

import Algorithms.MersenneTwisterFast;
import ImputedGeno.PermTools;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.Quicksort;
import Tool.RegressTools;
import Tool.StatTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;
import org.apache.commons.math.distribution.NormalDistributionImpl;

public class TransEthnicPerm {
    public static void main(String[] args) {
        String prefix = "All_PLINK_Meta12_tmp_4digit";
        String addprefix = "";
        String outfileLog = "";
        String outfilePerm = "";
        String out = "";
        String out1 = "";
        String out2 = "";
        String outM = "";
        String CorresFile = "P_Chi_CorresTable_high.txt";
        int Perm = 10;
        int numPop1 = 381;
        int numPop2 = 286;
        int Bit = 31;
        int x = 10000001;
        double MAF = 0.007;
        boolean GCcorrection = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            if (args[i].equals("-addprefix")) {
                addprefix = args[i + 1];
            }
            if (args[i].equals("-Perm")) {
                Perm = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numPop1")) {
                numPop1 = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numPop2")) {
                numPop2 = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Bit")) {
                Bit = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-seed")) {
                x = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-MAF")) {
                MAF = Double.parseDouble(args[i + 1]);
            }
            ++i;
        }
        int Pop1str = 0;
        int Pop1end = numPop1 - 1;
        int Pop2str = numPop1;
        int Pop2end = numPop1 + numPop2 - 1;
        int seed = (int)((double)x * Math.random());
        String GenoFile = String.valueOf(prefix) + ".geno";
        String InfoFile = String.valueOf(prefix) + ".info";
        String SampleFile = String.valueOf(prefix) + ".sample";
        prefix = String.valueOf(prefix) + addprefix;
        outfileLog = String.valueOf(prefix) + "_Perm_log.txt";
        outfilePerm = String.valueOf(prefix) + "_Perm_res.txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileLog));
            bw[1] = new BufferedWriter(new FileWriter(outfilePerm));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
            NormalDistributionImpl norm = new NormalDistributionImpl();
            String[][] Sample = FileTools.readDatFileIOStringTABString(SampleFile);
            String[][] Info = FileTools.readDatFileIOStringTABString(InfoFile);
            int numSample = Sample.length;
            int numSNP = Info.length;
            if (numPop1 + numPop2 != numSample) {
                throw new Exception("Total number of subjects do not match sample file !!");
            }
            out = "Log for TransEthnicPerm.java\n\nInput_File:\t" + prefix + ".geno\n\tNo.Samples:\t" + numSample + "\n\tNo.Samples_Pop1:\t" + numPop1 + "\n\tNo.Samples_Pop2:\t" + numPop2 + "\n\tNo.SNPs:\t" + numSNP + "\n\tMAF:\t" + MAF + "\n\tBit:\t" + Bit + "\n\tIteration:\t" + Perm + "\n\tGC_correction:\t" + GCcorrection + "\n\n";
            out = String.valueOf(out) + "Calculation started at:\t" + Tools.GetTime() + "\n\n";
            FileTools.out3File(bw[0], out);
            String[][] GenoFdigit = FileTools.readDatFileIOStringTABString(GenoFile);
            int numFdigit = GenoFdigit[0].length;
            int numSNPF = numFdigit * Bit;
            int counter = 0;
            int ValidCount1 = 0;
            int ValidCount2 = 0;
            int ValidCountM = 0;
            int[][] GenoTdigit = new int[numSample][Bit];
            int[] tmpTdigit = new int[Bit];
            int[] GenoPop1 = new int[numPop1];
            int[] GenoPop2 = new int[numPop2];
            int[] Phen1 = Tools.MixArray2(ArrayTools.RepeatArrayInt(numPop1 - numPop1 / 2, 2), ArrayTools.RepeatArrayInt(numPop1 / 2, 1));
            int[] Phen2 = Tools.MixArray2(ArrayTools.RepeatArrayInt(numPop2 - numPop2 / 2, 2), ArrayTools.RepeatArrayInt(numPop2 / 2, 1));
            int[] Table1 = new int[6];
            int[] Table2 = new int[6];
            int[] MetaN = new int[]{numPop1, numPop2};
            int[] TopSNP = new int[]{1};
            double[] P1 = new double[numSNPF];
            double[] P2 = new double[numSNPF];
            double[] PM = new double[numSNPF];
            double[] GenLabel = new double[]{0.0, 1.0, 2.0};
            double[] PhenLabel = new double[]{2.0, 1.0};
            double[] MetaP = new double[2];
            out = "Loading Genotype data ended at:\t" + Tools.GetTime() + "\n\n";
            FileTools.out3File(bw[0], out);
            int i2 = 0;
            while (i2 < Perm) {
                Phen1 = Tool.PermTools.ShuffleArray1(Phen1, mz);
                Phen2 = Tool.PermTools.ShuffleArray1(Phen2, mz);
                counter = 0;
                ValidCount1 = 0;
                ValidCount2 = 0;
                ValidCountM = 0;
                out1 = "";
                out2 = "";
                outM = "";
                int j = 0;
                while (j < numFdigit) {
                    int k = 0;
                    while (k < numSample) {
                        tmpTdigit = PermTools.TranslateFdigitStringToIntArray(GenoFdigit[k][j], Bit);
                        int l = 0;
                        while (l < Bit) {
                            GenoTdigit[k][l] = tmpTdigit[l];
                            ++l;
                        }
                        ++k;
                    }
                    int l = 0;
                    while (l < Bit) {
                        int m = Pop1str;
                        while (m <= Pop1end) {
                            GenoPop1[m - Pop1str] = GenoTdigit[m][l];
                            ++m;
                        }
                        m = Pop2str;
                        while (m <= Pop2end) {
                            GenoPop2[m - Pop2str] = GenoTdigit[m][l];
                            ++m;
                        }
                        Table1 = GenoTools.GenotypeCount0123(GenoPop1, Phen1);
                        Table2 = GenoTools.GenotypeCount0123(GenoPop2, Phen2);
                        boolean Pop1Flag = GenoTools.AfCheckCaCo(Table1, MAF, 1.0 - MAF);
                        boolean Pop2Flag = GenoTools.AfCheckCaCo(Table2, MAF, 1.0 - MAF);
                        if (Pop1Flag) {
                            P1[counter] = StatTools.TranslateChitoP(RegressTools.CorTrend(Table1, GenLabel, PhenLabel)[0], 1, CorresTableChi, chidf1);
                            ++ValidCount1;
                        } else {
                            P1[counter] = -99.0;
                        }
                        if (Pop2Flag) {
                            P2[counter] = StatTools.TranslateChitoP(RegressTools.CorTrend(Table2, GenLabel, PhenLabel)[0], 1, CorresTableChi, chidf1);
                            ++ValidCount2;
                        } else {
                            P2[counter] = -99.0;
                        }
                        if (Pop1Flag && Pop2Flag) {
                            MetaP[0] = P1[counter];
                            MetaP[1] = P2[counter];
                            PM[counter] = StatTools.Weighted_Zmeta(MetaP, MetaN, norm);
                            ++ValidCountM;
                        } else if (Pop1Flag) {
                            PM[counter] = P1[counter];
                            ++ValidCountM;
                        } else if (Pop2Flag) {
                            PM[counter] = P2[counter];
                            ++ValidCountM;
                        } else {
                            PM[counter] = -99.0;
                        }
                        ++counter;
                        ++l;
                    }
                    ++j;
                }
                Quicksort.sortDouble(P1);
                Quicksort.sortDouble(P2);
                Quicksort.sortDouble(PM);
                double lambdaP1 = ValidCount1 > 0 ? chidf1.inverseCumulativeProbability(1.0 - P1[numSNPF - ValidCount1 + ValidCount1 / 2]) / chidf1.inverseCumulativeProbability(0.5) : 1.0;
                double lambdaP2 = ValidCount2 > 0 ? chidf1.inverseCumulativeProbability(1.0 - P2[numSNPF - ValidCount2 + ValidCount2 / 2]) / chidf1.inverseCumulativeProbability(0.5) : 1.0;
                double lambdaPM = ValidCountM > 0 ? chidf1.inverseCumulativeProbability(1.0 - PM[numSNPF - ValidCountM + ValidCountM / 2]) / chidf1.inverseCumulativeProbability(0.5) : 1.0;
                out1 = String.valueOf(out1) + ValidCount1 + "\t" + lambdaP1;
                out2 = String.valueOf(out2) + ValidCount2 + "\t" + lambdaP2;
                outM = String.valueOf(outM) + ValidCountM + "\t" + lambdaPM;
                if (lambdaP1 < 1.0) {
                    lambdaP1 = 1.0;
                }
                if (lambdaP2 < 1.0) {
                    lambdaP2 = 1.0;
                }
                if (lambdaPM < 1.0) {
                    lambdaPM = 1.0;
                }
                j = 0;
                while (j < TopSNP.length) {
                    if (GCcorrection) {
                        out1 = String.valueOf(out1) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(P1[numSNPF - ValidCount1 + TopSNP[j] - 1], CorresTableChi, chidf1) / lambdaP1, 1, CorresTableChi, chidf1);
                        out2 = String.valueOf(out2) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(P2[numSNPF - ValidCount2 + TopSNP[j] - 1], CorresTableChi, chidf1) / lambdaP2, 1, CorresTableChi, chidf1);
                        outM = String.valueOf(outM) + "\t" + StatTools.TranslateChitoP(StatTools.TranslatePtoChiDf1(PM[numSNPF - ValidCountM + TopSNP[j] - 1], CorresTableChi, chidf1) / lambdaPM, 1, CorresTableChi, chidf1);
                    } else {
                        out1 = String.valueOf(out1) + "\t" + P1[numSNPF - ValidCount1 + TopSNP[j] - 1];
                        out2 = String.valueOf(out2) + "\t" + P2[numSNPF - ValidCount2 + TopSNP[j] - 1];
                        outM = String.valueOf(outM) + "\t" + PM[numSNPF - ValidCountM + TopSNP[j] - 1];
                    }
                    ++j;
                }
                out = String.valueOf(i2 + 1) + "\t" + out1 + "\t" + out2 + "\t" + outM + "\n";
                FileTools.out3File(bw[1], out);
                ++i2;
            }
            out = "Calculation ended at:\t" + Tools.GetTime() + "\n\n";
            FileTools.out3File(bw[0], out);
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

