	rm(list = ls(all = TRUE));
	setwd("C:/WORK/HP_WORK/yokada/files/LDRangeAsssign"); # Please define your working directory
	
	EUR_LD <- read.table("EUR_LDdata.txt", header=T); # LD information file for Europeans
	ASN_LD <- read.table("ASN_LDdata.txt", header=T); # LD information file for Asians
	SNP <- read.table("LandSNPs.txt", header=F); # SNP list
	numSNP <- length(SNP[,1]);
	
	LD = 0.5; # minimum r2 value to include in the SNP LD region
	Posi = 25000; #  minimum position lendth fromt the SNP to include in the SNP LD region
	
	write(file=paste("LDrange_r2_", LD, ".txt", sep=""), "SNPID\tSNPposition\tEUR_LD_start\tEUR_LD_end\tEUR_LD_length\tASN_LD_start\tASN_LD_end\tASN_LD_length\tEUR+ASN_LD+Posi_start\tEUR+ASN_LD+Posi_end\tEUR+ASN_LD+Posi_length", append=F);
	for (i in 1:numSNP) {
		flagE <- EUR_LD[,1]==as.character(SNP[i,1]) & EUR_LD[,5]>=LD;
		flagA <- ASN_LD[,1]==as.character(SNP[i,1]) & ASN_LD[,5]>=LD;

		out <- paste(SNP[i,1], SNP[i,2], min(EUR_LD[flagE,4]), max(EUR_LD[flagE,4]), max(EUR_LD[flagE,4])-min(EUR_LD[flagE,4]), min(ASN_LD[flagA,4]), max(ASN_LD[flagA,4]), max(ASN_LD[flagA,4])-min(ASN_LD[flagA,4]), min(EUR_LD[flagE,4], ASN_LD[flagA,4], SNP[i,2]-Posi), max(EUR_LD[flagE,4], ASN_LD[flagA,4], SNP[i,2]+Posi), max(EUR_LD[flagE,4], ASN_LD[flagA,4], SNP[i,2]+Posi)-min(EUR_LD[flagE,4], ASN_LD[flagA,4], SNP[i,2]-Posi), sep="\t");
		write(file=paste("LDrange_r2_", LD, ".txt", sep=""), out, append=T);
	}

