/*
 * Decompiled with CFR 0.152.
 */
package multiSNPLDdiff;

import Algorithms.MersenneTwisterFast;

public class NullHaploGenerator {
    public static void main(String[] args) {
        int numSNP = 10;
        int numSample = 100;
        int numCase = 1000;
        double AF1 = 0.1;
        double AF2 = 0.9;
        double OR1 = 1.0;
        double OR2 = 1.0;
        int seedgiven = 0;
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        double[] AlleleFreq = NullHaploGenerator.GenetAlleleFreq(numSNP, AF1, AF2, mz);
    }

    public static double[] GenetAlleleFreqCase(double[] Freq, double OR1, double OR2, MersenneTwisterFast mz) {
        double[] ret = new double[Freq.length];
        int i = 0;
        while (i < Freq.length) {
            double tmpOR = Math.pow(Math.E, Math.log(OR1) + (Math.log(OR2) - Math.log(OR1)) * mz.nextDouble());
            ret[i] = tmpOR * Freq[i] / (1.0 - Freq[i] + tmpOR * Freq[i]);
            ++i;
        }
        return ret;
    }

    public static String[] DecideMultiHaplotypeNull(int numSNP, int numSample, double[] AlleleFreq, MersenneTwisterFast mz) {
        String[] ret = new String[numSample * 2];
        int i = 0;
        while (i < numSample * 2) {
            ret[i] = NullHaploGenerator.DecideOneHaplotypeNull(numSNP, AlleleFreq, mz);
            ++i;
        }
        return ret;
    }

    public static String DecideOneHaplotypeNull(int numSNP, double[] AlleleFreq, MersenneTwisterFast mz) {
        String ret = "";
        int i = 0;
        while (i < numSNP) {
            ret = mz.nextDouble() < AlleleFreq[i] ? String.valueOf(ret) + "1" : String.valueOf(ret) + "0";
            ++i;
        }
        return ret;
    }

    public static double[] GenetAlleleFreq(int numSNP, double AF1, double AF2, MersenneTwisterFast mz) {
        double tmpAF2;
        double tmpAF1;
        double[] ret = new double[numSNP];
        if (AF1 <= AF2) {
            tmpAF1 = AF1;
            tmpAF2 = AF2;
        } else {
            tmpAF1 = AF2;
            tmpAF2 = AF1;
        }
        int i = 0;
        while (i < numSNP) {
            ret[i] = tmpAF1 + (tmpAF2 - tmpAF1) * mz.nextDouble();
            ++i;
        }
        return ret;
    }
}

