/*
 * Decompiled with CFR 0.152.
 */
package Tool;

import Tool.ArrayTools;
import Tool.CorresTable;
import Tool.FileTools;
import Tool.Tools;
import WorksFromRY.Chi2DistributionMore;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class StatTools {
    public static void main(String[] args) {
        String CorresFile = "P_Chi_CorresTable_mid.txt";
        int[][] data = new int[][]{{3, 35, 3, 36}, {7, 107, 14, 102}, {5, 64, 11, 82}, {102, 1431, 127, 1393}, {28, 327, 27, 338}, {4, 55, 6, 46}, {98, 847, 152, 787}, {60, 572, 48, 423}, {25, 253, 37, 245}, {138, 1778, 188, 1733}, {64, 809, 52, 531}, {45, 218, 47, 219}, {9, 282, 16, 277}, {57, 801, 45, 838}, {25, 129, 31, 116}, {65, 1130, 62, 1138}, {17, 281, 34, 275}};
        int[][] data2 = new int[][]{{31, 1969, 35, 1965}, {16, 1984, 12, 1988}};
        int[][] data3 = new int[][]{{17, 1983, 18, 1982}, {22, 1978, 21, 1979}};
        int[][] data4 = new int[][]{{36, 1964, 18, 1982}, {653, 1347, 685, 1315}};
        int[][] dataCCR6 = new int[][]{{2397, 2205, 3103, 3633}, {3664, 3660, 14681, 17065}, {1129, 1083, 1394, 1578}};
        int[][] EGR2 = new int[][]{{873, 781, 889, 865}, {1239, 971, 962, 916}};
        double[] tmp = StatTools.MetaTest(EGR2);
        int maxN = 2000;
        double[] LogFact = new double[maxN * 2 + 1];
        int i = 0;
        while (i < maxN * 2 + 1) {
            LogFact[i] = Tools.factlog(i);
            ++i;
        }
        int[] tmp2 = new int[]{11, 12, 13, 14};
        boolean df1 = true;
        int df2 = 2;
        int df3 = 3;
        int df4 = 4;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df1);
        ChiSquaredDistributionImpl chidf2 = new ChiSquaredDistributionImpl((double)df2);
        ChiSquaredDistributionImpl chidf3 = new ChiSquaredDistributionImpl((double)df3);
        ChiSquaredDistributionImpl chidf4 = new ChiSquaredDistributionImpl((double)df4);
        try {
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            int testN = 100;
            int i2 = 0;
            while (i2 <= 400) {
                double testP = Math.pow(10.0, -1.0 * (double)i2 / 10.0);
                String out = String.valueOf(testP) + "\t" + StatTools.TranslatePtoChiDf1(testP, CorresTableChi, chidf1);
                System.out.println(out);
                ++i2;
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public static double TranslatePtoChiDf1(double P, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double ret = -99.0;
        double Thres = Math.pow(10.0, -12.0);
        if (P > 1.0) {
            P = 1.0;
        }
        if (P < Math.pow(10.0, -300.0)) {
            P = Math.pow(10.0, -299.0);
        }
        ret = P >= Thres ? chidf1.inverseCumulativeProbability(1.0 - P) : CorresTable.ConvPtoChibyCorresDf1(P, CorresTableChi);
        return ret;
    }

    public static double TranslateChitoP(double Chi, int df, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double ret = -1.0;
        double[] ThresChi = new double[]{50.84413, 64.47238, 68.27299};
        if (Chi < 0.0) {
            Chi = 0.0;
        }
        if (df == 1) {
            if (Chi > 1373.873) {
                Chi = 1373.0;
            }
            ret = Chi < ThresChi[df - 1] ? 1.0 - chidf1.cumulativeProbability(Chi) : CorresTable.ConvChitoPbyCorres(Chi, CorresTableChi, 1);
        } else {
            ret = df <= 3 ? (Chi < ThresChi[df - 1] ? Chi2DistributionMore.upper(df, Chi) : CorresTable.ConvChitoPbyCorres(Chi, CorresTableChi, df)) : Chi2DistributionMore.upper(df, Chi);
        }
        return ret;
    }

    public static double TranslateToPdf1(double Chi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double ret = -1.0;
        ret = 1.0 - chidf1.cumulativeProbability(Chi);
        return ret;
    }

    public static double TranslateToPdf2(double Chi, ChiSquaredDistributionImpl chidf2) throws Exception {
        double ret = -1.0;
        ret = 1.0 - chidf2.cumulativeProbability(Chi);
        return ret;
    }

    public static double TranslateToPdf3(double Chi, ChiSquaredDistributionImpl chidf3) throws Exception {
        double ret = -1.0;
        ret = 1.0 - chidf3.cumulativeProbability(Chi);
        return ret;
    }

    public static double TranslateToPdf4(double Chi, ChiSquaredDistributionImpl chidf4) throws Exception {
        double ret = -1.0;
        ret = 1.0 - chidf4.cumulativeProbability(Chi);
        return ret;
    }

    public static double Chi2fromCount(int a, int b, int c, int d) {
        double ret = 0.0;
        if (a + b != 0 && a + c != 0 && b + d != 0 && c + d != 0) {
            double tmp1 = Math.log(Math.abs(a * d - b * c));
            double tmp2 = Math.log(a + c + b + d);
            double tmp3 = Math.log(a + b) + Math.log(a + c) + Math.log(b + d) + Math.log(c + d);
            ret = tmp1 * 2.0 + tmp2 - tmp3;
            ret = Math.exp(ret);
        }
        return ret;
    }

    public static double[][] TheoDistMarginal2x2(int[] array, double[] LogFact) {
        int R1 = array[0];
        int R2 = array[1];
        int C1 = array[2];
        int C2 = array[3];
        int N = R1 + R2;
        int Mina = Math.max(0, C1 - R2);
        int Maxa = Math.min(C1, R1);
        int len = Maxa - Mina + 1;
        double CommonFact = LogFact[C1] + LogFact[C2] + LogFact[R1] + LogFact[R2] - LogFact[N];
        double Prob = CommonFact - (LogFact[array[0]] + LogFact[array[2]] + (LogFact[array[1]] + LogFact[array[3]]));
        double[] Problist = new double[len];
        double[][] ret = new double[len][3];
        int i = Mina;
        while (i < Maxa + 1) {
            Problist[i - Mina] = CommonFact - (LogFact[i] + LogFact[C1 - i] + (LogFact[R1 - i] + LogFact[C2 - R1 + i]));
            ret[i][2] = StatTools.Chi2fromCount(i, R1 - i, C1 - i, C2 - R1 + i);
            ++i;
        }
        i = 0;
        while (i < len) {
            ret[i][0] = Math.exp(Problist[i]);
            ret[i][1] = StatTools.ProbCompare(Problist[i], Problist);
            ++i;
        }
        return ret;
    }

    public static double[][] TheoDistMarginal2x2OnlyFish(int[] array, double[] LogFact) {
        int R1 = array[0];
        int R2 = array[1];
        int C1 = array[2];
        int C2 = array[3];
        int N = R1 + R2;
        int Mina = Math.max(0, C1 - R2);
        int Maxa = Math.min(C1, R1);
        int len = Maxa - Mina + 1;
        double CommonFact = LogFact[C1] + LogFact[C2] + LogFact[R1] + LogFact[R2] - LogFact[N];
        double Prob = CommonFact - (LogFact[array[0]] + LogFact[array[2]] + (LogFact[array[1]] + LogFact[array[3]]));
        double[] Problist = new double[len];
        double[][] ret = new double[len][2];
        int i = Mina;
        while (i < Maxa + 1) {
            Problist[i - Mina] = CommonFact - (LogFact[i] + LogFact[C1 - i] + (LogFact[R1 - i] + LogFact[C2 - R1 + i]));
            ++i;
        }
        i = 0;
        while (i < len) {
            ret[i][0] = Math.exp(Problist[i]);
            ret[i][1] = StatTools.ProbCompare(Problist[i], Problist);
            ++i;
        }
        return ret;
    }

    public static double FisherCount2x2(int[] array, double[] LogFact) {
        double ret = 0.0;
        int R1 = array[0] + array[1];
        int R2 = array[2] + array[3];
        int C1 = array[0] + array[2];
        int C2 = array[1] + array[3];
        int N = R1 + R2;
        int Mina = Math.max(0, C1 - R2);
        int Maxa = Math.min(C1, R1);
        double CommonFact = LogFact[C1] + LogFact[C2] + LogFact[R1] + LogFact[R2] - LogFact[N];
        double Prob = CommonFact - (LogFact[array[0]] + LogFact[array[2]] + (LogFact[array[1]] + LogFact[array[3]]));
        double[] Problist = new double[Maxa - Mina + 1];
        int i = Mina;
        while (i < Maxa + 1) {
            Problist[i - Mina] = CommonFact - (LogFact[i] + LogFact[C1 - i] + (LogFact[R1 - i] + LogFact[C2 - R1 + i]));
            ++i;
        }
        ret = StatTools.ProbCompare(Prob, Problist);
        return ret;
    }

    public static double[] FisherCountMidP2x2(int[] array, double[] LogFact) {
        double[] ret = new double[]{0.0, 0.0, 0.0};
        int R1 = array[0] + array[1];
        int R2 = array[2] + array[3];
        int C1 = array[0] + array[2];
        int C2 = array[1] + array[3];
        int N = R1 + R2;
        int Mina = Math.max(0, C1 - R2);
        int Maxa = Math.min(C1, R1);
        double CommonFact = LogFact[C1] + LogFact[C2] + LogFact[R1] + LogFact[R2] - LogFact[N];
        double Prob = CommonFact - (LogFact[array[0]] + LogFact[array[2]] + (LogFact[array[1]] + LogFact[array[3]]));
        double[] Problist = new double[Maxa - Mina + 1];
        int i = Mina;
        while (i < Maxa + 1) {
            Problist[i - Mina] = CommonFact - (LogFact[i] + LogFact[C1 - i] + (LogFact[R1 - i] + LogFact[C2 - R1 + i]));
            ++i;
        }
        ret = StatTools.ProbCompareMidP(Prob, Problist);
        return ret;
    }

    public static double[] FisherCountMidP2x3(int[] array, double[] LogFact) {
        double[] ret = new double[]{0.0, 0.0, 0.0};
        int R1 = array[0] + array[1] + array[2];
        int R2 = array[3] + array[4] + array[5];
        int C1 = array[0] + array[3];
        int C2 = array[1] + array[4];
        int C3 = array[2] + array[5];
        int[] Cells = new int[array.length];
        int i = 0;
        while (i < array.length) {
            Cells[i] = array[i];
            ++i;
        }
        Tools.NormalSort1arrayInt(Cells);
        int N = R1 + R2;
        double CommonFact = LogFact[C1] + LogFact[C2] + LogFact[C3] + LogFact[R1] + LogFact[R2] - LogFact[N];
        double Prob = CommonFact - (LogFact[Cells[0]] + LogFact[Cells[1]] + LogFact[Cells[2]] + LogFact[Cells[3]] + LogFact[Cells[4]] + LogFact[Cells[5]]);
        int Mina = Math.max(0, C1 - R2);
        int Maxa = Math.min(C1, R1);
        int len = 0;
        int counter = 0;
        int i2 = Mina;
        while (i2 < Maxa + 1) {
            len += Math.min(C2, R1 - i2) - Math.max(0, C1 + C2 - R2 - i2) + 1;
            ++i2;
        }
        double[] Problist = new double[len];
        int i3 = Mina;
        while (i3 < Maxa + 1) {
            int Minb = Math.max(0, C1 + C2 - R2 - i3);
            int Maxb = Math.min(C2, R1 - i3);
            int j = Minb;
            while (j < Maxb + 1) {
                Cells[0] = i3;
                Cells[1] = j;
                Cells[2] = R1 - i3 - j;
                Cells[3] = C1 - i3;
                Cells[4] = C2 - j;
                Cells[5] = C3 - R1 + i3 + j;
                Tools.NormalSort1arrayInt(Cells);
                Problist[counter] = CommonFact - (LogFact[Cells[0]] + LogFact[Cells[1]] + LogFact[Cells[2]] + LogFact[Cells[3]] + LogFact[Cells[4]] + LogFact[Cells[5]]);
                ++counter;
                ++j;
            }
            ret = StatTools.ProbCompareMidP(Prob, Problist);
            ++i3;
        }
        return ret;
    }

    public static int ruleOfkObs(int[] array, int k) {
        int ret = 0;
        if (array[0] < k || array[1] < k || array[2] < k || array[3] < k) {
            ret = 1;
        }
        return ret;
    }

    public static int ruleOfkExp(int[] array, int k) {
        int ret = 0;
        int R1 = array[0] + array[1];
        int R2 = array[2] + array[3];
        int C1 = array[0] + array[2];
        int C2 = array[1] + array[3];
        int N = R1 + R2;
        if ((double)R1 * (double)C1 / (double)N < (double)k || (double)R1 * (double)C2 / (double)N < (double)k || (double)R2 * (double)C1 / (double)N < (double)k || (double)R2 * (double)C2 / (double)N < (double)k) {
            ret = 1;
        }
        return ret;
    }

    public static int ruleOfDiamond(int[] array, double Thres) {
        int ret = 0;
        int N = array[0] + array[1] + array[2] + array[3];
        int[] array2 = ArrayTools.CopyArray1(array);
        Thres = (double)N * Thres;
        Tools.NormalSort1arrayInt(array2);
        if ((double)array2[0] <= Thres && (double)array2[1] <= Thres && (double)array2[2] <= Thres) {
            ret = 1;
        }
        return ret;
    }

    public static int ruleOfVertex(int[] array, double Thres) {
        int ret = 0;
        int N = array[0] + array[1] + array[2] + array[3];
        if ((double)array[0] >= (Thres = (double)N * (1.0 - Thres)) || (double)array[1] >= Thres || (double)array[2] >= Thres || (double)array[3] >= Thres) {
            ret = 1;
        }
        return ret;
    }

    public static int ruleOfChiP(int[] array, double ThresC) {
        int ret = 0;
        double Chi = StatTools.Chi2Count(array);
        if (Chi >= ThresC) {
            ret = 1;
        }
        return ret;
    }

    public static double Chi2Count(int[] array) {
        double ret = -99.0;
        int a = array[0];
        int b = array[1];
        int c = array[2];
        int d = array[3];
        if (a + b != 0 && a + c != 0 && b + d != 0 && c + d != 0) {
            double tmp1 = Math.log(Math.abs((double)a * (double)d - (double)b * (double)c));
            double tmp2 = Math.log(a + c + b + d);
            double tmp3 = Math.log(a + b) + Math.log(a + c) + Math.log(b + d) + Math.log(c + d);
            ret = tmp1 * 2.0 + tmp2 - tmp3;
            ret = Math.exp(ret);
        }
        return ret;
    }

    public static double[] WoolfORwith95CI(int a, int b, int c, int d) {
        double[] ret = new double[3];
        ret[0] = (double)a * (double)d / (double)(b * c);
        double com = 1.959964 * Math.pow(1.0 / (double)a + 1.0 / (double)b + 1.0 / (double)c + 1.0 / (double)d, 0.5);
        ret[1] = ret[0] * Math.exp(com * -1.0);
        ret[2] = ret[0] * Math.exp(com);
        return ret;
    }

    public static double Chi2CountYates(int[] array) {
        double ret = -99.0;
        int a = array[0];
        int b = array[1];
        int c = array[2];
        int d = array[3];
        if (a + b != 0 && a + c != 0 && b + d != 0 && c + d != 0) {
            double tmp0 = Math.abs((double)a * (double)d - (double)b * (double)c) - 0.5 * (double)(a + b + c + d);
            if (tmp0 < 0.0) {
                tmp0 = 0.0;
            }
            double tmp1 = Math.log(Math.abs(tmp0));
            double tmp2 = Math.log(a + c + b + d);
            double tmp3 = Math.log(a + b) + Math.log(a + c) + Math.log(b + d) + Math.log(c + d);
            ret = tmp1 * 2.0 + tmp2 - tmp3;
            ret = Math.exp(ret);
        }
        return ret;
    }

    public static double Chi2x3Count(int[] array) {
        double ret = -99.0;
        int R1 = array[0] + array[1] + array[2];
        int R2 = array[3] + array[4] + array[5];
        int C1 = array[0] + array[3];
        int C2 = array[1] + array[4];
        int C3 = array[2] + array[5];
        int N = R1 + R2;
        if (R1 != 0 && R2 != 0 && C1 != 0 && C2 != 0 && C3 != 0) {
            double[] Exp = new double[]{(double)R1 * (double)C1 / (double)N, (double)R1 * (double)C2 / (double)N, (double)R1 * (double)C3 / (double)N, (double)R2 * (double)C1 / (double)N, (double)R2 * (double)C2 / (double)N, (double)R2 * (double)C3 / (double)N};
            ret = 0.0;
            int i = 0;
            while (i < array.length) {
                ret += Math.pow((double)array[i] - Exp[i], 2.0) / Exp[i];
                ++i;
            }
        }
        return ret;
    }

    public static double Armitage2x3Array(int[][] array) {
        int[] input = new int[]{array[0][0], array[0][1], array[0][2], array[1][0], array[1][1], array[1][2]};
        double ret = StatTools.Armitage2x3(input);
        return ret;
    }

    public static double Armitage2x3(int[] array) {
        double ret = -99.0;
        int R1 = array[0] + array[1] + array[2];
        int R2 = array[3] + array[4] + array[5];
        int C1 = array[0] + array[3];
        int C2 = array[1] + array[4];
        int C3 = array[2] + array[5];
        int N = R1 + R2;
        if (C2 != 0 || C2 == 0 && C1 != 0 && C3 != 0) {
            ret = Math.log(N) + Math.log(Math.abs(N * (array[1] + 2 * array[2]) - R1 * (C2 + 2 * C3))) * 2.0 - Math.log(R1) - Math.log(N - R1) - Math.log((double)(N * (C2 + 4 * C3)) - Math.pow(C2 + 2 * C3, 2.0));
            ret = Math.exp(ret);
            ret = ret * (double)(N - 1) / (double)N;
        }
        if (C1 == 0 && C3 == 0) {
            ret = -99.0;
        }
        return ret;
    }

    public static double ProbCompare(double prob, double[] problist) {
        double ret = 0.0;
        int i = 0;
        while (i < problist.length) {
            boolean added = false;
            if (prob == problist[i]) {
                added = true;
            } else if (prob > problist[i]) {
                added = true;
            }
            if (added) {
                ret += Math.exp(problist[i]);
            }
            ++i;
        }
        if (ret > 1.0) {
            ret = 1.0;
        }
        return ret;
    }

    public static double[] ProbCompareMidP(double prob, double[] problist) {
        double[] ret = new double[]{0.0, 0.0, 0.0};
        int i = 0;
        while (i < problist.length) {
            int added = 0;
            if (prob == problist[i]) {
                added = 2;
            } else if (prob > problist[i]) {
                added = 1;
            }
            if (added == 2) {
                ret[0] = ret[0] + Math.exp(problist[i]);
                ret[1] = ret[1] + Math.exp(problist[i]) * 0.5;
                ret[2] = ret[2] + 1.0;
            } else if (added == 1) {
                ret[0] = ret[0] + Math.exp(problist[i]);
                ret[1] = ret[1] + Math.exp(problist[i]);
            }
            ++i;
        }
        if (ret[0] > 1.0) {
            ret[0] = 1.0;
        }
        if (ret[1] > 1.0) {
            ret[1] = 1.0;
        }
        return ret;
    }

    public static double[] lamdacheck(double[][] data, double[] lamda) {
        double[] ret = new double[lamda.length];
        int counter = lamda.length - 1;
        int i = data.length - 1;
        while (i > 0) {
            if (data[i][0] >= lamda[counter] && data[i - 1][0] <= lamda[counter]) {
                ret[counter] = data[i][1];
                ++i;
                if (--counter < 0) {
                    i = 0;
                }
            }
            --i;
        }
        return ret;
    }

    public static double[] CockranQ(int[][] data) {
        double[] ret = new double[3];
        int len = data.length;
        double[] ORi = new double[len];
        double[] wiAsym = new double[len];
        double Sig_w = 0.0;
        double Sig_R = 0.0;
        double CockQ = 0.0;
        int i = 0;
        while (i < len) {
            int ni = data[i][0] + data[i][1] + data[i][2] + data[i][3];
            ORi[i] = (double)data[i][0] * (double)data[i][3] / (double)(data[i][1] * data[i][2]);
            double wi = (double)data[i][1] * (double)data[i][2] / (double)ni;
            wiAsym[i] = 1.0 / (double)data[i][0] + 1.0 / (double)data[i][1] + 1.0 / (double)data[i][2] + 1.0 / (double)data[i][3];
            double Ri = (double)data[i][0] * (double)data[i][3] / (double)ni;
            Sig_w += wi;
            Sig_R += Ri;
            ++i;
        }
        double MantOR = Sig_R / Sig_w;
        i = 0;
        while (i < len) {
            CockQ += Math.pow(Math.log(ORi[i]) - Math.log(MantOR), 2.0) / wiAsym[i];
            ++i;
        }
        double I2 = Math.max((CockQ - (double)(len - 1)) / CockQ, 0.0);
        ret[0] = CockQ;
        ret[1] = len;
        ret[2] = I2;
        return ret;
    }

    public static double[] MetaTestBeta(int numStudy, double[] Beta, double[] SE, double[] P, double[] N, double[] lambda, double[][] CorresTableChi, ChiSquaredDistributionImpl chidf1) throws Exception {
        double[] ret = new double[10];
        double[] z = new double[numStudy];
        double[] z_oneSide = new double[numStudy];
        double[] w = new double[numStudy];
        double N_total = 0.0;
        double Weighted_z = 0.0;
        double Alternative_z = 0.0;
        double Alternative_P = 0.0;
        double Weighted_z_oneSide = 0.0;
        double Weighted_P_oneSide = 0.0;
        double nume = 0.0;
        double denom = 0.0;
        boolean eq_1 = false;
        int i = 0;
        while (i < numStudy) {
            if (lambda[i] < 1.0) {
                lambda[i] = 1.0;
            }
            z[i] = Math.pow(StatTools.TranslatePtoChiDf1(P[i], CorresTableChi, chidf1) / lambda[i], 0.5);
            z_oneSide[i] = P[i] <= 0.5 ? Math.pow(StatTools.TranslatePtoChiDf1(P[i] * 2.0, CorresTableChi, chidf1) / lambda[i], 0.5) : Math.pow(StatTools.TranslatePtoChiDf1((1.0 - P[i]) * 2.0, CorresTableChi, chidf1) / lambda[i], 0.5) * -1.0;
            if (P[i] == 1.0) {
                eq_1 = true;
            }
            if (Beta[i] < 0.0) {
                z[i] = z[i] * -1.0;
            }
            SE[i] = SE[i] * Math.pow(lambda[i], 0.5);
            N_total += N[i];
            ++i;
        }
        i = 0;
        while (i < numStudy) {
            w[i] = Math.pow(N[i] / N_total, 0.5);
            Weighted_z += w[i] * z[i];
            Weighted_z_oneSide += w[i] * z_oneSide[i];
            nume += Beta[i] / (SE[i] * SE[i]);
            denom += 1.0 / (SE[i] * SE[i]);
            Alternative_z += w[i] * Beta[i] / SE[i];
            ++i;
        }
        double Inverse_Beta = nume / denom;
        double Inverse_SE = Math.pow(1.0 / denom, 0.5);
        double Inverse_z = Inverse_Beta / Inverse_SE;
        double Weighted_P = StatTools.TranslateChitoP(Weighted_z * Weighted_z, 1, CorresTableChi, chidf1);
        double Inverse_P = StatTools.TranslateChitoP(Inverse_z * Inverse_z, 1, CorresTableChi, chidf1);
        Alternative_P = StatTools.TranslateChitoP(Alternative_z * Alternative_z, 1, CorresTableChi, chidf1);
        Weighted_P_oneSide = StatTools.TranslateChitoP(Weighted_z_oneSide * Weighted_z_oneSide, 1, CorresTableChi, chidf1) / 2.0;
        if (Weighted_z_oneSide < 0.0) {
            Weighted_P_oneSide = 1.0 - Weighted_P_oneSide;
        }
        if (eq_1) {
            Weighted_P_oneSide = 1.0;
        }
        ret[0] = N_total;
        ret[1] = Weighted_z;
        ret[2] = Weighted_P;
        ret[3] = Inverse_Beta;
        ret[4] = Inverse_SE;
        ret[5] = Inverse_z;
        ret[6] = Inverse_P;
        ret[7] = Alternative_z;
        ret[8] = Alternative_P;
        ret[9] = Weighted_P_oneSide;
        return ret;
    }

    public static double[] MetaTest(int[][] data) {
        double[] ret = new double[22];
        int len = data.length;
        double[] ORi = new double[len];
        double[] wiAsym = new double[len];
        double[] VarORlog = new double[len];
        double[] sol = new double[2];
        double Sig_w = 0.0;
        double Sig_w2 = 0.0;
        double Sig_wAsym = 0.0;
        double Sig_wAsym2 = 0.0;
        double Sig_wDSL = 0.0;
        double Sig_wDSLOR = 0.0;
        double Sig_P = 0.0;
        double Sig_R = 0.0;
        double Sig_PR = 0.0;
        double Sig_PS_QR = 0.0;
        double Sig_QS = 0.0;
        double Sig_OE = 0.0;
        double Sig_OE2V = 0.0;
        double Sig_V = 0.0;
        double Sig_VarORlogwAsym = 0.0;
        double MantHetero = 0.0;
        double VarHetero = 0.0;
        double BDTHetero = 0.0;
        int i = 0;
        while (i < len) {
            int ni = data[i][0] + data[i][1] + data[i][2] + data[i][3];
            ORi[i] = (double)data[i][0] * (double)data[i][3] / (double)(data[i][1] * data[i][2]);
            double wi = (double)data[i][1] * (double)data[i][2] / (double)ni;
            wiAsym[i] = 1.0 / (double)data[i][0] + 1.0 / (double)data[i][1] + 1.0 / (double)data[i][2] + 1.0 / (double)data[i][3];
            double Pi = (double)(data[i][0] + data[i][3]) / (double)ni;
            double Qi = (double)(data[i][1] + data[i][2]) / (double)ni;
            double Ri = (double)data[i][0] * (double)data[i][3] / (double)ni;
            double Ei = ((double)data[i][0] + (double)data[i][1]) * ((double)data[i][0] + (double)data[i][2]) / (double)ni;
            double Vi = ((double)data[i][0] + (double)data[i][1]) * ((double)data[i][2] + (double)data[i][3]) * ((double)data[i][0] + (double)data[i][2]) * ((double)data[i][1] + (double)data[i][3]) / ((double)ni * (double)ni * (double)(ni - 1));
            VarORlog[i] = Math.log((double)data[i][0] * (double)data[i][3] / ((double)data[i][1] * (double)data[i][2]));
            Sig_w += wi;
            Sig_wAsym += Math.pow(wiAsym[i], -1.0);
            Sig_wAsym2 += Math.pow(wiAsym[i], -2.0);
            Sig_w2 += Math.pow(wi, 2.0);
            Sig_P += Pi;
            Sig_R += Ri;
            Sig_PR += Pi * Ri;
            Sig_PS_QR += Pi * wi + Qi * Ri;
            Sig_QS += Qi * wi;
            Sig_OE += (double)data[i][0] - Ei;
            Sig_OE2V += Math.pow((double)data[i][0] - Ei, 2.0) / Vi;
            Sig_V += Vi;
            Sig_VarORlogwAsym += Math.pow(wiAsym[i], -1.0) * VarORlog[i];
            ++i;
        }
        double MantChi = Math.pow(Math.abs(Sig_OE), 2.0) / Sig_V;
        double MantOR = Sig_R / Sig_w;
        double MantORvar = Sig_PR / (2.0 * Math.pow(Sig_R, 2.0)) + Sig_PS_QR / (2.0 * Sig_R * Sig_w) + Sig_QS / (2.0 * Math.pow(Sig_w, 2.0));
        double MantORlow = MantOR * Math.exp(-1.96 * Math.sqrt(MantORvar));
        double MantORup = MantOR * Math.exp(1.96 * Math.sqrt(MantORvar));
        double PetoChi = Sig_OE2V - Math.pow(Sig_OE, 2.0) / Sig_V;
        double PetoOR = Math.exp(Sig_OE / Sig_V);
        double PetoORlow = PetoOR * Math.exp(-1.96 * Math.pow(Sig_V, -0.5));
        double PetoORup = PetoOR * Math.exp(1.96 * Math.pow(Sig_V, -0.5));
        double VarOR = Math.exp(Sig_VarORlogwAsym / Sig_wAsym);
        double VarChi = Math.pow(Math.log(VarOR), 2.0) * Sig_wAsym;
        double VarORlow = VarOR * Math.exp(-1.96 * Math.pow(Sig_wAsym, -0.5));
        double VarORup = VarOR * Math.exp(1.96 * Math.pow(Sig_wAsym, -0.5));
        i = 0;
        while (i < len) {
            double ei;
            MantHetero += Math.pow(Math.log(ORi[i]) - Math.log(MantOR), 2.0) / wiAsym[i];
            VarHetero += Math.pow(wiAsym[i], -1.0) * Math.pow(VarORlog[i] - Math.log(VarOR), 2.0);
            double a = MantOR - 1.0;
            double b = (double)(data[i][0] - data[i][3]) - (double)(data[i][0] + data[i][1] + data[i][0] + data[i][2]) * MantOR;
            double c = (double)(data[i][0] + data[i][1]) * (double)(data[i][0] + data[i][2]) * MantOR;
            if (Math.abs(a) < Math.pow(10.0, -15.0)) {
                ei = (double)(data[i][0] + data[i][1]) * (double)(data[i][0] + data[i][2]) / (double)(data[i][0] + data[i][1] + data[i][2] + data[i][3]);
            } else {
                sol[0] = (-1.0 * b + Math.pow(b * b - 4.0 * a * c, 0.5)) / (2.0 * a);
                sol[1] = (-1.0 * b - Math.pow(b * b - 4.0 * a * c, 0.5)) / (2.0 * a);
                ei = (double)Math.max(0, data[i][0] - data[i][1]) <= sol[0] && (double)Math.min(data[i][0] + data[i][1], data[i][0] + data[i][2]) >= sol[0] ? sol[0] : sol[1];
            }
            BDTHetero += Math.pow(1.0 / ei + 1.0 / ((double)(data[i][0] + data[i][1]) - ei) + 1.0 / ((double)(data[i][0] + data[i][2]) - ei) + 1.0 / ((double)(data[i][3] - data[i][0]) + ei), 1.0) * Math.pow((double)data[i][0] - ei, 2.0);
            ++i;
        }
        double I2 = Math.max((MantHetero - (double)(len - 1)) / MantHetero, 0.0);
        double tau = Math.max((VarHetero - (double)(len - 1)) / (Sig_wAsym - Sig_wAsym2 / Sig_wAsym), 0.0);
        i = 0;
        while (i < len) {
            double wiDSL = Math.pow(wiAsym[i] + tau, -1.0);
            Sig_wDSL += wiDSL;
            Sig_wDSLOR += wiDSL * Math.log(ORi[i]);
            ++i;
        }
        double DSLOR = Math.exp(Sig_wDSLOR / Sig_wDSL);
        double DSLORlow = DSLOR * Math.exp(-1.96 * Math.pow(Sig_wDSL, -0.5));
        double DSLORup = DSLOR * Math.exp(1.96 * Math.pow(Sig_wDSL, -0.5));
        double DSLChi = Math.pow(Math.log(DSLOR), 2.0) * Sig_wDSL;
        ret[0] = len;
        ret[1] = MantChi;
        ret[2] = MantOR;
        ret[3] = MantORlow;
        ret[4] = MantORup;
        ret[5] = MantHetero;
        ret[6] = I2;
        ret[7] = DSLChi;
        ret[8] = DSLOR;
        ret[9] = DSLORlow;
        ret[10] = DSLORup;
        ret[11] = tau;
        ret[12] = PetoChi;
        ret[13] = PetoOR;
        ret[14] = PetoORlow;
        ret[15] = PetoORup;
        ret[16] = VarChi;
        ret[17] = VarOR;
        ret[18] = VarORlow;
        ret[19] = VarORup;
        ret[20] = VarHetero;
        ret[21] = BDTHetero;
        return ret;
    }
}

