/*
 * Decompiled with CFR 0.152.
 */
package QTLAnalysis;

import Algorithms.MersenneTwisterFast;
import QTLAnalysis.PowerCalcLinear;
import Tool.FileTools;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class PowerCalcLinearGrid {
    public static void main(String[] args) {
        int N = 2500;
        int Iter = 2500;
        double AF1 = 0.1;
        double AF2st = 0.1;
        double AF2ed = 0.9;
        double AF2kiz = 0.1;
        double[] Beta = new double[]{0.08625, 0.03295, -0.01936};
        double[] Alpha = new double[]{0.05, 0.01, 0.001, 1.0E-4, 5.0E-5, 1.0E-5, 5.0E-6, 1.0E-6, 5.0E-7, 1.0E-7, 5.0E-8};
        String prefix = "test";
        String out = "";
        String CorresFile = "P_Chi_CorresTable_high.txt";
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-N")) {
                N = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Iter")) {
                Iter = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-AF1")) {
                AF1 = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AF2st")) {
                AF2st = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AF2ed")) {
                AF2ed = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-AF2kiz")) {
                AF2kiz = Double.parseDouble(args[i + 1]);
            }
            if (args[i].equals("-Beta")) {
                Beta[0] = Double.parseDouble(args[i + 1]);
                Beta[1] = Double.parseDouble(args[i + 2]);
                Beta[2] = Double.parseDouble(args[i + 3]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        String OutFile = String.valueOf(prefix) + "_N" + N + "_Iter" + Iter + "_AF" + AF1 + "-" + AF2st + "-" + AF2ed + "-" + AF2kiz + ".txt";
        int seed = 0;
        int x = 10000000;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl(1.0);
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(OutFile));
            double[][] CorresTableChi = FileTools.readDatFileIOStringTAB(CorresFile);
            double i2 = AF2st;
            while (i2 < AF2ed + 1.0E-4) {
                out = String.valueOf(AF1) + "\t" + i2 + "\t";
                double[] res = PowerCalcLinear.PowerCalcLinearTwoSNP(N, Iter, AF1, i2, Beta, Alpha, CorresTableChi, mz, chidf1);
                int j = 0;
                while (j < res.length) {
                    out = String.valueOf(out) + res[j] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[0], out);
                i2 += AF2kiz;
            }
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

