/*
 * Decompiled with CFR 0.152.
 */
package Mains_meta;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.GenoTools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class MakeMetaData {
    public static void main(String[] args) {
        int numgroup = 3;
        int rep = 1;
        String outfile = "test";
        String outfileCond = "";
        String outfileMeta = "";
        String outfileLog = "";
        String out = "";
        int seedgiven = 0;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-numgroup")) {
                numgroup = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-rep")) {
                rep = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-out")) {
                outfile = args[i + 1];
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        int[] numstudy = new int[numgroup];
        int[] numcase = new int[numgroup];
        int[] numcont = new int[numgroup];
        int totalstudy = 0;
        int totalcase = 0;
        int totalcont = 0;
        double[] mafcont = new double[numgroup];
        double[] OR = new double[numgroup];
        double[] miss = new double[numgroup];
        int i2 = 0;
        while (i2 < numgroup) {
            numstudy[i2] = 3;
            numcase[i2] = 1000;
            numcont[i2] = 1000;
            mafcont[i2] = 0.2;
            OR[i2] = 1.2;
            miss[i2] = 0.99;
            ++i2;
        }
        i2 = 0;
        while (i2 < args.length) {
            int j;
            if (args[i2].equals("-numcase")) {
                j = 0;
                while (j < numgroup) {
                    numcase[j] = Integer.parseInt(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-numcont")) {
                j = 0;
                while (j < numgroup) {
                    numcont[j] = Integer.parseInt(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-numstudy")) {
                j = 0;
                while (j < numgroup) {
                    numstudy[j] = Integer.parseInt(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-mafcont")) {
                j = 0;
                while (j < numgroup) {
                    mafcont[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-OR")) {
                j = 0;
                while (j < numgroup) {
                    OR[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            if (args[i2].equals("-miss")) {
                j = 0;
                while (j < numgroup) {
                    miss[j] = Double.parseDouble(args[i2 + 1 + j]);
                    ++j;
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < numgroup) {
            totalcase += numcase[i2] * numstudy[i2];
            totalcont += numcont[i2] * numstudy[i2];
            totalstudy += numstudy[i2];
            ++i2;
        }
        outfile = String.valueOf(outfile) + "_numgroup" + numgroup + "_study" + totalstudy + "_ca" + totalcase + "_co" + totalcont + "_rep" + rep;
        outfileCond = String.valueOf(outfile) + "_condition.txt";
        outfileMeta = String.valueOf(outfile) + "_metadata.txt";
        outfileLog = String.valueOf(outfile) + "_log.txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileCond));
            bw[1] = new BufferedWriter(new FileWriter(outfileMeta));
            bw[2] = new BufferedWriter(new FileWriter(outfileLog));
            out = "repeat\tgroup\tCaseNum\tContNum\tTotal\tOddsRatio\tMAF_Case\tMAF_Cont\tMissingRate\n";
            FileTools.out3File(bw[0], out);
            out = "Data created by MakeMetaData.java\nTotal_Study\t" + totalstudy + "\nTotal_Case:\t" + totalcase + "\nTotal_Control\t" + totalcont + "\nTotal_Sample\t" + (totalcase + totalcont) + "\nrepeat\t" + rep + "\ngroup\t" + numgroup + "\n\ngroup\tstudy\tCaseNum\tContNum\tTotal\tOddsRatio\tMAF_Case\tMAF_Cont\tMissingRate\n";
            int i3 = 0;
            while (i3 < numgroup) {
                double tmp = GenoTools.AFfromOR(mafcont[i3], OR[i3]);
                out = String.valueOf(out) + (i3 + 1) + "\t" + numstudy[i3] + "\t" + numcase[i3] + "\t" + numcont[i3] + "\t" + (numcase[i3] + numcont[i3]) + "\t" + OR[i3] + "\t" + tmp + "\t" + mafcont[i3] + "\t" + miss[i3] + "\n";
                ++i3;
            }
            FileTools.out3File(bw[2], out);
            int[] CountCase = new int[3];
            int[] CountCont = new int[3];
            int i4 = 0;
            while (i4 < rep) {
                int j = 0;
                while (j < numgroup) {
                    int k = 0;
                    while (k < numstudy[j]) {
                        int Case = numcase[j];
                        int Cont = numcont[j];
                        double MafCont = mafcont[j];
                        double ORtmp = OR[j];
                        double Miss = miss[j];
                        double MafCase = GenoTools.AFfromOR(MafCont, ORtmp);
                        CountCase = GenoTools.GenoCount(Case, MafCase, Miss, mz);
                        CountCont = GenoTools.GenoCount(Cont, MafCont, Miss, mz);
                        out = String.valueOf(i4 + 1) + "\t" + (j + 1) + "\t" + Case + "\t" + Cont + "\t" + (Case + Cont) + "\t" + ORtmp + "\t" + MafCase + "\t" + MafCont + "\t" + Miss + "\n";
                        FileTools.out3File(bw[0], out);
                        out = String.valueOf(CountCase[0]) + "\t" + CountCase[1] + "\t" + CountCase[2] + "\t" + CountCont[0] + "\t" + CountCont[1] + "\t" + CountCont[2] + "\n";
                        FileTools.out3File(bw[1], out);
                        ++k;
                    }
                    ++j;
                }
                ++i4;
            }
            bw[0].close();
            bw[1].close();
            bw[2].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

