/*
 * Decompiled with CFR 0.152.
 */
package Mains_GC;

import Algorithms.MersenneTwisterFast;
import Tool.FileTools;
import Tool.GenoTools;
import Tool.StatTools;
import Tool.Tools;
import WorksFromRY.Fisher;
import java.io.BufferedWriter;
import java.io.FileWriter;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class CountDataAnalysisTrendExact {
    public static void main(String[] args) {
        String inputfile = "metadata";
        String outfileMain = "";
        String outfileMed = "";
        String inputfileNum = "";
        String out = "";
        int num = 0;
        int rep = 1;
        int seedgiven = 0;
        int maxN = 10000;
        int thresnum = 0;
        boolean DividedData = false;
        boolean thres = false;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-file")) {
                inputfile = args[i + 1];
            }
            if (args[i].equals("-num") && (num = Integer.parseInt(args[i + 1])) <= 1) {
                num = 0;
            }
            if (args[i].equals("-divided")) {
                DividedData = true;
            }
            if (args[i].equals("-seed")) {
                seedgiven = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-thresNum")) {
                thres = true;
                thresnum = Integer.parseInt(args[i + 1]);
            }
            ++i;
        }
        int seed = 0;
        if (seedgiven == 0) {
            int x = 10000000;
            seed = (int)((double)x * Math.random());
        } else {
            seed = seedgiven;
        }
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        boolean df = true;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df);
        double[] alphaPtmp = new double[]{1.0E-4, 0.001, 0.01, 0.05};
        double[] alphaPthres = new double[thresnum];
        int i2 = 0;
        while (i2 < args.length) {
            if (args[i2].equals("-thres") && thres) {
                int j = 0;
                while (j < thresnum) {
                    alphaPthres[j] = Double.parseDouble(args[i2 + j + 1]);
                    ++j;
                }
            }
            ++i2;
        }
        double[] alphaP = new double[alphaPtmp.length + alphaPthres.length];
        double[] alphaC = new double[alphaP.length];
        alphaP = Tools.MixArray2(alphaPtmp, alphaPthres);
        Tools.NormalSort1array(alphaP);
        outfileMain = String.valueOf(inputfile) + "_result_trend.txt";
        outfileMed = String.valueOf(inputfile) + "_summaryORG_trend.txt";
        inputfileNum = String.valueOf(inputfile) + "Num.txt";
        inputfile = String.valueOf(inputfile) + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null, null};
        try {
            bw[0] = new BufferedWriter(new FileWriter(outfileMain));
            bw[1] = new BufferedWriter(new FileWriter(outfileMed));
            int[][] data = FileTools.readDatFileIOStringTABint(inputfile);
            int datalength = data.length;
            if (num != 0 & num <= datalength) {
                rep = (int)Math.floor(datalength / num);
            } else if (num > datalength | num == 0) {
                num = datalength;
            }
            if (DividedData) {
                rep = FileTools.readDatFileIOStringTABint(inputfileNum).length;
            }
            int[] array = new int[6];
            int[][] array2x3 = new int[2][3];
            double[] MainTest = new double[2];
            double[][] tmparray = new double[num][MainTest.length];
            double[] tmpRep1 = new double[rep];
            double[] tmpRep2 = new double[rep];
            double[][] MedianRet = new double[rep][MainTest.length];
            double[] tmpAlpha = new double[alphaP.length];
            double[][][] alphaRet = new double[rep][MainTest.length][alphaP.length];
            double[] LogFact = new double[maxN * 2 + 1];
            int i3 = 0;
            while (i3 < maxN * 2 + 1) {
                LogFact[i3] = Tools.factlog(i3);
                ++i3;
            }
            i3 = 0;
            while (i3 < alphaP.length) {
                alphaC[i3] = chidf1.inverseCumulativeProbability(1.0 - alphaP[i3]);
                ++i3;
            }
            double[] LogFactRY = Fisher.serialLogfact(maxN * 2 + 1);
            int[] numArray = new int[rep];
            int[] numArrayQuant = new int[rep];
            int tmpint = 0;
            if (DividedData) {
                int[][] NumData = FileTools.readDatFileIOStringTABint(inputfileNum);
                int i4 = 0;
                while (i4 < rep) {
                    numArray[i4] = NumData[i4][0];
                    numArrayQuant[i4] = tmpint;
                    tmpint += NumData[i4][0];
                    ++i4;
                }
            } else {
                int i5 = 0;
                while (i5 < rep) {
                    numArray[i5] = num;
                    numArrayQuant[i5] = tmpint;
                    tmpint += num;
                    ++i5;
                }
            }
            int i6 = 0;
            while (i6 < rep) {
                int j = 0;
                while (j < numArray[i6]) {
                    int k = 0;
                    while (k < 6) {
                        array[k] = data[numArrayQuant[i6] + j][k];
                        ++k;
                    }
                    int[] arrayAdd = GenoTools.ChangeAddsingle(array);
                    array2x3[0][0] = array[0];
                    array2x3[0][1] = array[1];
                    array2x3[0][2] = array[2];
                    array2x3[1][0] = array[3];
                    array2x3[1][1] = array[4];
                    array2x3[1][2] = array[5];
                    MainTest[0] = Fisher.FisherAlleleFrom2x3_2(array2x3, LogFactRY);
                    MainTest[1] = StatTools.Armitage2x3(array);
                    out = "";
                    int k2 = 0;
                    while (k2 < MainTest.length) {
                        tmparray[j][k2] = MainTest[k2];
                        out = String.valueOf(out) + MainTest[k2] + "\t";
                        ++k2;
                    }
                    out = String.valueOf(out) + "\n";
                    FileTools.out3File(bw[0], out);
                    ++j;
                }
                double[] tmp = new double[numArray[i6]];
                int k = 0;
                while (k < MainTest.length) {
                    int j2 = 0;
                    while (j2 < numArray[i6]) {
                        tmp[j2] = tmparray[j2][k];
                        ++j2;
                    }
                    MedianRet[i6][k] = k == 0 ? chidf1.inverseCumulativeProbability(1.0 - Math.max(Tools.Median(tmp), Math.pow(10.0, -10.0))) : Math.min(Tools.Median(tmp), 40.0);
                    tmpAlpha = Tools.AlphaCheck(tmp, alphaP, alphaC);
                    int l = 0;
                    while (l < tmpAlpha.length) {
                        alphaRet[i6][k][l] = tmpAlpha[l];
                        ++l;
                    }
                    ++k;
                }
                ++i6;
            }
            out = "thres\tExactTrend\tTrend\n";
            int l = 0;
            while (l < alphaP.length) {
                int i7 = 0;
                while (i7 < rep) {
                    tmpRep1[i7] = alphaRet[i7][0][l];
                    tmpRep2[i7] = alphaRet[i7][1][l];
                    out = String.valueOf(out) + alphaP[l] + "\t" + tmpRep1[i7] + "\t" + tmpRep2[i7] + "\n";
                    ++i7;
                }
                out = String.valueOf(out) + "Mean\t" + Tools.MeanVarSD(tmpRep1)[0] + "\t" + Tools.MeanVarSD(tmpRep2)[0] + "\t\nSD\t" + Tools.MeanVarSD(tmpRep1)[2] + "\t" + Tools.MeanVarSD(tmpRep2)[2] + "\n";
                ++l;
            }
            i6 = 0;
            while (i6 < rep) {
                tmpRep1[i6] = MedianRet[i6][0];
                tmpRep2[i6] = MedianRet[i6][1];
                out = String.valueOf(out) + "0.5\t" + tmpRep1[i6] + "\t" + tmpRep2[i6] + "\n";
                ++i6;
            }
            out = String.valueOf(out) + "Mean\t" + Tools.MeanVarSD(tmpRep1)[0] + "\t" + Tools.MeanVarSD(tmpRep2)[0] + "\t\nSD\t" + Tools.MeanVarSD(tmpRep1)[2] + "\t" + Tools.MeanVarSD(tmpRep2)[2] + "\n";
            FileTools.out3File(bw[1], out);
            bw[0].close();
            bw[1].close();
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

