/*
 * Decompiled with CFR 0.152.
 */
package LOCH_Mapping;

import LOCH_Mapping.LOCH_MappingTools;
import Tool.ArrayTools;
import Tool.FileTools;
import Tool.PedTools;
import Tool.Tools;
import java.io.BufferedWriter;
import java.io.FileWriter;

public class LOCH_MappingPedwithControl_GWA {
    public static void main(String[] args) {
        int Windowkb = 1000;
        int Stretchkb = 3000;
        int StretchkbControl = 3000;
        int numGapSNP = 1;
        int numMinSNP = 20;
        int counter = 0;
        int maxN = 100;
        String prefix = "Test";
        String out = "";
        boolean tmpFlag = true;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-Windowkb")) {
                Windowkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-Stretchkb")) {
                Stretchkb = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-StretchkbControl")) {
                StretchkbControl = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numGapSNP")) {
                numGapSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-numMinSNP")) {
                numMinSNP = Integer.parseInt(args[i + 1]);
            }
            if (args[i].equals("-prefix")) {
                prefix = args[i + 1];
            }
            ++i;
        }
        String inputfilePed = String.valueOf(prefix) + ".ped";
        String inputfileMap = String.valueOf(prefix) + ".map";
        String inputfileCase = String.valueOf(prefix) + ".case";
        String outfile1 = String.valueOf(prefix) + "_LOCM_MappingCount_Windowkb" + Windowkb + "_Stretchkb" + Stretchkb + "StretchkbControl" + StretchkbControl + "_GapSNP" + numGapSNP + ".txt";
        BufferedWriter[] bw = new BufferedWriter[]{null};
        try {
            String[] tmp;
            bw[0] = new BufferedWriter(new FileWriter(outfile1));
            String[] DataPed = FileTools.readDatFileIOStringSingle(inputfilePed);
            String[] DataMap = FileTools.readDatFileIOStringSingle(inputfileMap);
            String[] CaseID = FileTools.readDatFileIOStringSingle(inputfileCase);
            String[] SampleID = PedTools.ExtractSampleIDfromPed(DataPed);
            int numSNP = DataMap.length;
            int numCase = CaseID.length;
            int numSample = SampleID.length;
            int numControl = numSample - numCase;
            int numPoint = numSNP;
            String[] ControlID = new String[numControl];
            String[] CaseControlID = new String[numCase + 1];
            String[] PointID = new String[numPoint];
            long[] PointPosition = new long[numPoint];
            int[][] PointHitResult = new int[numPoint][numControl + 1];
            int[] PointHitSumControl = new int[numPoint];
            int[] PointChr = new int[numPoint];
            int[] Pointbp = new int[numPoint];
            ArrayTools.InitializeArray1(PointHitSumControl);
            int i2 = 0;
            while (i2 < numCase) {
                CaseControlID[i2] = CaseID[i2];
                ++i2;
            }
            i2 = 0;
            while (i2 < numSample) {
                tmpFlag = true;
                int j = 0;
                while (j < numCase) {
                    if (SampleID[i2].equals(CaseID[j])) {
                        tmpFlag = false;
                    }
                    ++j;
                }
                if (tmpFlag) {
                    ControlID[counter] = SampleID[i2];
                    ++counter;
                }
                ++i2;
            }
            String[] SNPID = new String[numSNP];
            int[] Chr = new int[numSNP];
            int[] bp = new int[numSNP];
            long[] Position = new long[numSNP];
            int[][] CaseCount = new int[numSNP][3];
            int[][] CaseControlCount = new int[numSNP][3];
            out = "Log_for_LOCM_MappingCount.java\n\nInput_File:\t" + prefix + ".txt\nNo.SNP:\t" + numSNP + "\nWindow_kb:\t" + Windowkb + "\nStretch_kb:\t" + Stretchkb + "\nNo.GapSNP:\t" + numGapSNP + "\nNo.MinSNP:\t" + numMinSNP + "\n\n";
            FileTools.out3File(bw[0], out);
            int i3 = 0;
            while (i3 < numSNP) {
                tmp = DataMap[i3].split("\t");
                SNPID[i3] = tmp[1];
                Chr[i3] = Integer.parseInt(tmp[0]);
                bp[i3] = Integer.parseInt(tmp[3]);
                Position[i3] = Long.parseLong(tmp[0]) * 100000000000L + Long.parseLong(tmp[3]);
                ++i3;
            }
            i3 = 0;
            while (i3 < numPoint) {
                tmp = DataMap[i3].split("\t");
                PointID[i3] = tmp[1];
                PointChr[i3] = Integer.parseInt(tmp[0]);
                Pointbp[i3] = Integer.parseInt(tmp[3]);
                PointPosition[i3] = Long.parseLong(tmp[0]) * 100000000000L + Long.parseLong(tmp[3]);
                ++i3;
            }
            CaseCount = PedTools.TranslatePed12toCount(PedTools.ExtractPedonSampleID(DataPed, CaseID), 6);
            int[][] StretchLong = LOCH_MappingTools.LOCHMappingAll(CaseCount, Position, Windowkb, numGapSNP, numMinSNP, Stretchkb);
            int[] PointHit = LOCH_MappingTools.PointHitonStretch(StretchLong, PointPosition, Position);
            int numStretchLong = StretchLong.length;
            System.out.println(numStretchLong);
            int i4 = 0;
            while (i4 < numPoint) {
                PointHitResult[i4][0] = PointHit[i4];
                ++i4;
            }
            out = "\nNo.Long_Stretch_CaseOnly\t-\t" + numStretchLong + "\n\n";
            FileTools.out3File(bw[0], out);
            i4 = 0;
            while (i4 < numStretchLong) {
                out = String.valueOf(i4 + 1) + "\t" + Chr[StretchLong[i4][0]] + "\t" + SNPID[StretchLong[i4][0]] + "\t" + SNPID[StretchLong[i4][1]] + "\t" + bp[StretchLong[i4][0]] + "\t" + bp[StretchLong[i4][1]] + "\t" + (bp[StretchLong[i4][1]] - bp[StretchLong[i4][0]]) + "\n";
                FileTools.out3File(bw[0], out);
                ++i4;
            }
            i4 = 0;
            while (i4 < numControl) {
                CaseControlID[numCase] = ControlID[i4];
                CaseControlCount = PedTools.TranslatePed12toCount(PedTools.ExtractPedonSampleID(DataPed, CaseControlID), 6);
                int[][] StretchLongControl = LOCH_MappingTools.LOCHMappingAll(CaseControlCount, Position, Windowkb, numGapSNP, numMinSNP, StretchkbControl);
                int[] PointHitControl = LOCH_MappingTools.PointHitonStretch(StretchLongControl, PointPosition, Position);
                int numStretchLongControl = StretchLongControl.length;
                int j = 0;
                while (j < numPoint) {
                    PointHitResult[j][i4 + 1] = PointHitControl[j];
                    ++j;
                }
                out = "\n\nNo.Long_Stretch_CaseControl\t" + ControlID[i4] + "\t" + numStretchLongControl + "\n\n";
                FileTools.out3File(bw[0], out);
                j = 0;
                while (j < numStretchLongControl) {
                    out = String.valueOf(j + 1) + "\t" + Chr[StretchLongControl[j][0]] + "\t" + SNPID[StretchLongControl[j][0]] + "\t" + SNPID[StretchLongControl[j][1]] + "\t" + bp[StretchLongControl[j][0]] + "\t" + bp[StretchLongControl[j][1]] + "\t" + (bp[StretchLongControl[j][1]] - bp[StretchLongControl[j][0]]) + "\n";
                    FileTools.out3File(bw[0], out);
                    ++j;
                }
                ++i4;
            }
            System.out.println("Mapping finished !!");
            i4 = 0;
            while (i4 < PointHitResult.length) {
                int j = 1;
                while (j < PointHitResult[0].length) {
                    int n = i4;
                    PointHitSumControl[n] = PointHitSumControl[n] + PointHitResult[i4][j];
                    ++j;
                }
                ++i4;
            }
            out = "\n\nPositionHitResults\n\nLocus\tChr\tbp\tCaseSum\tControlSum\tCaseOnly\t";
            i4 = 0;
            while (i4 < numControl) {
                out = String.valueOf(out) + ControlID[i4] + "\t";
                ++i4;
            }
            out = String.valueOf(out) + "\n";
            FileTools.out3File(bw[0], out);
            out = "";
            i4 = 0;
            while (i4 < PointHitResult.length) {
                out = String.valueOf(out) + PointID[i4] + "\t" + PointChr[i4] + "\t" + Pointbp[i4] + "\t" + CaseID.length + "\t" + PointHitSumControl[i4] + "\t";
                int j = 0;
                while (j < PointHitResult[0].length) {
                    out = String.valueOf(out) + PointHitResult[i4][j] + "\t";
                    ++j;
                }
                out = String.valueOf(out) + "\n";
                FileTools.out3File(bw[0], out);
                out = "";
                ++i4;
            }
            out = "\nCalculation_finished_at:\t" + Tools.GetTime() + "\n";
            FileTools.out3File(bw[0], out);
            bw[0].close();
        }
        catch (Exception e) {
            System.out.println("Error");
            System.out.println(e);
        }
    }
}

