/*
 * Decompiled with CFR 0.152.
 */
package Interaction;

import Likelihood.TableManage;
import Tool.ArrayTools;
import Tool.PlotTools;
import Tool.StatTools;
import org.apache.commons.math.distribution.ChiSquaredDistributionImpl;

public class TableLike3x3x2LD {
    public static void main(String[] args) {
        int Pk = 100;
        int Maxrep = 1000;
        int testtype = 0;
        int[][][] data3x3 = new int[][][]{new int[][]{{82, 105, 62}, {146, 240, 126}, {69, 115, 55}}, new int[][]{{42, 109, 100}, {82, 234, 165}, {37, 131, 100}}};
        double kizOR = 1.01;
        double ThresL = Math.pow(10.0, -10.0);
        double boost = 20.0;
        boolean[] H1flag = new boolean[]{true, true};
        PlotTools.Array(TableLike3x3x2LD.CalcMaxLike3x3(data3x3, H1flag, testtype, Pk, kizOR, Maxrep, ThresL, boost));
        PlotTools.Array2(TableLike3x3x2LD.CalcLike3x3H0H1(data3x3, testtype, Pk, kizOR, Maxrep, ThresL, boost));
        int[][] ContArray = TableManage.ExtractTable(data3x3, 0);
        int[][] CaseArray = TableManage.ExtractTable(data3x3, 1);
        double[] OR = TableLike3x3x2LD.CalcBaseRiskFrom3x3(ContArray, CaseArray, testtype);
        PlotTools.Array(OR);
        double[][] ORsH1 = TableLike3x3x2LD.CalcRisk3x3FromR1R2(OR[0], OR[1], testtype);
        double[][] ORsH0 = TableLike3x3x2LD.CalcRisk3x3FromR1R2(1.0, 1.0, testtype);
    }

    public static double[] CalcLikeDiff(double[][] Array) throws Exception {
        boolean df1 = true;
        int df2 = 2;
        ChiSquaredDistributionImpl chidf1 = new ChiSquaredDistributionImpl((double)df1);
        ChiSquaredDistributionImpl chidf2 = new ChiSquaredDistributionImpl((double)df2);
        double[] ret = new double[10];
        ret[0] = (Array[1][2] - Array[0][2]) * 2.0;
        ret[2] = (Array[2][2] - Array[0][2]) * 2.0;
        ret[4] = (Array[3][2] - Array[0][2]) * 2.0;
        ret[6] = (Array[3][2] - Array[1][2]) * 2.0;
        ret[8] = (Array[3][2] - Array[2][2]) * 2.0;
        ret[1] = StatTools.TranslateToPdf1(ret[0], chidf1);
        ret[3] = StatTools.TranslateToPdf1(ret[2], chidf1);
        ret[5] = StatTools.TranslateToPdf1(ret[4], chidf2);
        ret[7] = StatTools.TranslateToPdf1(ret[6], chidf1);
        ret[9] = StatTools.TranslateToPdf1(ret[8], chidf1);
        return ret;
    }

    public static double[][] CalcLike3x3H0H1(int[][][] array, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[][] ret = new double[4][4];
        boolean[] H0H0 = new boolean[2];
        boolean[] blArray = new boolean[2];
        blArray[0] = true;
        boolean[] H1H0 = blArray;
        boolean[] blArray2 = new boolean[2];
        blArray2[1] = true;
        boolean[] H0H1 = blArray2;
        boolean[] H1H1 = new boolean[]{true, true};
        double[] LikeH0H0 = TableLike3x3x2LD.CalcMaxLike3x3(array, H0H0, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH1H0 = TableLike3x3x2LD.CalcMaxLike3x3(array, H1H0, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH0H1 = TableLike3x3x2LD.CalcMaxLike3x3(array, H0H1, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        double[] LikeH1H1 = TableLike3x3x2LD.CalcMaxLike3x3(array, H1H1, testtype, Pk, kizOR, Maxrep, ThresL, boost);
        int i = 0;
        while (i < LikeH0H0.length) {
            ret[0][i] = LikeH0H0[i];
            ret[1][i] = LikeH1H0[i];
            ret[2][i] = LikeH0H1[i];
            ret[3][i] = LikeH1H1[i];
            ++i;
        }
        return ret;
    }

    public static double[] CalcMaxLike3x3(int[][][] array, boolean[] H1flag, int testtype, int Pk, double kizOR, int Maxrep, double ThresL, double boost) {
        double[] ret = new double[4];
        int boostcounter = 0;
        int[] flagOR = new int[2];
        int[][] TotalArray = TableManage.CombineTable(array);
        int[][] ContArray = TableManage.ExtractTable(array, 0);
        int[][] CaseArray = TableManage.ExtractTable(array, 1);
        double[][] Freq = TableManage.GetFreq(TotalArray);
        double[][] ContFreq = TableManage.GetFreq(ContArray);
        double[][] CaseFreq = TableManage.GetFreq(CaseArray);
        double[] OR = new double[2];
        double[] tmpOR = TableLike3x3x2LD.CalcBaseRiskFrom3x3(CaseArray, ContArray, testtype);
        double[] tmpOR0 = new double[2];
        double[] tmpOR1 = new double[2];
        double counter = 0.0;
        double L = -9.99999999E8;
        boolean iter = true;
        if (!H1flag[0]) {
            tmpOR[0] = 1.0;
        }
        if (!H1flag[1]) {
            tmpOR[1] = 1.0;
        }
        while (iter) {
            if (H1flag[0]) {
                tmpOR0[0] = tmpOR[0] / kizOR;
                tmpOR0[1] = tmpOR[0] * kizOR;
                tmpOR1[0] = tmpOR[1];
                tmpOR1[1] = tmpOR[1];
                flagOR[0] = TableLike3x3x2LD.FindHighestLikeORs(L, ContArray, CaseArray, ContFreq, tmpOR0, tmpOR1, testtype, Pk);
            } else {
                tmpOR0[0] = 1.0;
                tmpOR0[1] = 1.0;
                tmpOR1[0] = tmpOR[1];
                tmpOR1[1] = tmpOR[1];
                flagOR[0] = -99;
            }
            if (H1flag[1]) {
                tmpOR0[0] = tmpOR[0];
                tmpOR0[1] = tmpOR[0];
                tmpOR1[0] = tmpOR[1] / kizOR;
                tmpOR1[1] = tmpOR[1] * kizOR;
                flagOR[1] = TableLike3x3x2LD.FindHighestLikeORs(L, ContArray, CaseArray, ContFreq, tmpOR0, tmpOR1, testtype, Pk);
            } else {
                tmpOR0[0] = tmpOR[0];
                tmpOR0[1] = tmpOR[0];
                tmpOR1[0] = 1.0;
                tmpOR1[1] = 1.0;
                flagOR[1] = -99;
            }
            tmpOR = TableLike3x3x2LD.DecideORsfromFlag(tmpOR, flagOR, kizOR);
            double[][] tmpRArray = TableLike3x3x2LD.CalcRisk3x3FromR1R2(tmpOR[0], tmpOR[1], testtype);
            double[][][] tmpFreq = TableLike3x3x2LD.EstimateFreqFrom3x3ORfixedTotalFreq(ContArray, CaseArray, tmpRArray, Pk);
            double[][] tmpContFreq = TableManage.ExtractTable(tmpFreq, 0);
            double[][] tmpCaseFreq = TableManage.ExtractTable(tmpFreq, 1);
            double tmpL = TableLike3x3x2LD.LikeArray(ContArray, tmpContFreq) + TableLike3x3x2LD.LikeArray(CaseArray, tmpCaseFreq);
            if (tmpL - L > ThresL) {
                L = tmpL;
                OR = tmpOR;
            } else {
                kizOR = 1.0 + (kizOR - 1.0) / boost;
                if (boostcounter == 1) {
                    iter = false;
                }
                ++boostcounter;
            }
            counter += 1.0;
        }
        ret[0] = OR[0];
        ret[1] = OR[1];
        ret[2] = L;
        ret[3] = counter;
        return ret;
    }

    public static double[] DecideORsfromFlag(double[] tmpOR, int[] flag, double kizOR) {
        double[] ret = new double[tmpOR.length];
        int i = 0;
        while (i < tmpOR.length) {
            if (flag[i] == 0) {
                ret[i] = tmpOR[i] / kizOR;
            } else if (flag[i] == 1) {
                ret[i] = tmpOR[i] * kizOR;
            } else if (flag[i] == -99) {
                ret[i] = tmpOR[i];
            }
            ++i;
        }
        return ret;
    }

    public static int FindHighestLikeORs(double BaseL, int[][] ContArray, int[][] CaseArray, double[][] ContFreq, double[] OR1, double[] OR2, int testtype, int Pk) {
        int len = OR1.length;
        int ret = -99;
        int i = 0;
        while (i < len) {
            double[][] tmpRArray = TableLike3x3x2LD.CalcRisk3x3FromR1R2(OR1[i], OR2[i], testtype);
            double[][][] tmpFreq = TableLike3x3x2LD.EstimateFreqFrom3x3ORfixedTotalFreq(ContArray, CaseArray, tmpRArray, Pk);
            double[][] tmpContFreq = TableManage.ExtractTable(tmpFreq, 0);
            double[][] tmpCaseFreq = TableManage.ExtractTable(tmpFreq, 1);
            double tmpL = TableLike3x3x2LD.LikeArray(ContArray, tmpContFreq) + TableLike3x3x2LD.LikeArray(CaseArray, tmpCaseFreq);
            if (tmpL > BaseL) {
                BaseL = tmpL;
                ret = i;
            }
            ++i;
        }
        return ret;
    }

    public static double LikeArray(int[][] array, double[][] Freq) {
        double L = 0.0;
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[0].length) {
                if (Freq[i][j] != 0.0 && array[i][j] != 0) {
                    L += (double)array[i][j] * Math.log(Freq[i][j]);
                }
                ++j;
            }
            ++i;
        }
        return L;
    }

    public static double[][][] EstimateFreqFrom3x3OR(double[][] ContFreq, double[][] ORArray) {
        int j;
        double[][][] ret = new double[2][ContFreq.length][ContFreq[0].length];
        double N = 0.0;
        int i = 0;
        while (i < ContFreq.length) {
            j = 0;
            while (j < ContFreq[0].length) {
                ret[0][i][j] = ContFreq[i][j];
                ret[1][i][j] = ContFreq[i][j] * ORArray[i][j];
                N += ContFreq[i][j] * ORArray[i][j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < ContFreq.length) {
            j = 0;
            while (j < ContFreq[0].length) {
                double[] dArray = ret[1][i];
                int n = j++;
                dArray[n] = dArray[n] / N;
            }
            ++i;
        }
        return ret;
    }

    public static double[][][] EstimateFreqFrom3x3ORfixedTotalFreq(int[][] ContArray, int[][] CaseArray, double[][] OR, int k) {
        double[][][] ret = new double[2][3][3];
        double BestP1 = TableLike3x3x2LD.FindBestP1seq(ContArray, CaseArray, OR, k)[0];
        double[][] ContP = TableLike3x3x2LD.EstimateContFreqFrom3x3ORwithP1(ContArray, CaseArray, OR, BestP1);
        double R0 = TableManage.SumTable(ContArray);
        double R1 = TableManage.SumTable(CaseArray);
        int[][] TotalArray = TableManage.CombineTwoTable(ContArray, CaseArray);
        int i = 0;
        while (i < OR.length) {
            int j = 0;
            while (j < OR.length) {
                ret[0][i][j] = ContP[i][j];
                ret[1][i][j] = ((double)TotalArray[i][j] - R0 * ret[0][i][j]) / R1;
                ++j;
            }
            ++i;
        }
        return ret;
    }

    public static double[] FindBestP1seq(int[][] ContArray, int[][] CaseArray, double[][] OR, int k) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1000000.0;
        ret = TableLike3x3x2LD.FindBestP1(ContArray, CaseArray, OR, k, 0.0, 1.0);
        ret = TableLike3x3x2LD.FindBestP1(ContArray, CaseArray, OR, k, ret[0] - 1.0 / (double)(k + 1), ret[0] + 1.0 / (double)(k + 1));
        ret = TableLike3x3x2LD.FindBestP1(ContArray, CaseArray, OR, k, ret[0] - 2.0 / (double)((k + 1) * (k + 1)), ret[0] + 2.0 / (double)((k + 1) * (k + 1)));
        ret = TableLike3x3x2LD.FindBestP1(ContArray, CaseArray, OR, k, ret[0] - 4.0 / (double)((k + 1) * (k + 1) * (k + 1)), ret[0] + 4.0 / (double)((k + 1) * (k + 1) * (k + 1)));
        return ret;
    }

    public static double[] FindBestP1(int[][] ContArray, int[][] CaseArray, double[][] OR, int k, double range0, double range1) {
        double[] ret = new double[2];
        double finP = -1.0;
        double minRet = 1.0E8;
        double[] Pcand = ArrayTools.MakeThomasArray(k, range0, range1);
        int i = 0;
        while (i < Pcand.length) {
            double tmpRet = TableLike3x3x2LD.CheckSumContFreqFrom3x3ORwithP1(ContArray, CaseArray, OR, Pcand[i]);
            if (tmpRet <= minRet) {
                minRet = tmpRet;
                finP = Pcand[i];
            }
            ++i;
        }
        ret[0] = finP;
        ret[1] = minRet;
        return ret;
    }

    public static double CheckSumContFreqFrom3x3ORwithP1(int[][] ContArray, int[][] CaseArray, double[][] OR, double P1) {
        double[][] P = TableLike3x3x2LD.EstimateContFreqFrom3x3ORwithP1(ContArray, CaseArray, OR, P1);
        double ret = 1.0E8;
        if (TableManage.CheckRange(P, 0.0, 1.0)) {
            ret = Math.abs(1.0 - TableManage.SumTable(P));
        }
        return ret;
    }

    public static double[][] EstimateContFreqFrom3x3ORwithP1(int[][] ContArray, int[][] CaseArray, double[][] OR, double P1) {
        double[][] ret = new double[3][3];
        double baseOR = OR[1][1];
        int i = 0;
        while (i < OR.length) {
            int j = 0;
            while (j < OR[0].length) {
                OR[i][j] = OR[i][j] / baseOR;
                ++j;
            }
            ++i;
        }
        int[][] TotalArray = TableManage.CombineTwoTable(ContArray, CaseArray);
        int SumCont = TableManage.SumTable(ContArray);
        int i2 = 0;
        while (i2 < OR.length) {
            int j = 0;
            while (j < OR[0].length) {
                ret[i2][j] = (double)TotalArray[i2][j] * P1 / ((double)SumCont * P1 * (1.0 - OR[i2][j]) + OR[i2][j] * (double)TotalArray[1][1]);
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static double[][] CalcRisk3x3FromR1R2(double R1, double R2, int testtype) {
        double[][] ret = new double[3][3];
        if (testtype == 0) {
            ret[0][0] = 1.0 / (R1 * R2);
            ret[1][0] = 1.0 / R2;
            ret[2][0] = R1 / R2;
            ret[0][1] = 1.0 / R1;
            ret[1][1] = 1.0;
            ret[2][1] = R1;
            ret[0][2] = R2 / R1;
            ret[1][2] = R2;
            ret[2][2] = R1 * R2;
        } else if (testtype != 1) {
            if (testtype == 2) {
                ret[0][0] = 1.0 / (R1 * R2);
                ret[1][0] = 1.0 / R2;
                ret[2][0] = 1.0 / R2;
                ret[0][1] = 1.0 / R1;
                ret[1][1] = 1.0;
                ret[2][1] = 1.0;
                ret[0][2] = 1.0 / R1;
                ret[1][2] = 1.0;
                ret[2][2] = 1.0;
            } else if (testtype == 3) {
                ret[0][0] = 1.0;
                ret[1][0] = 1.0;
                ret[2][0] = R1;
                ret[0][1] = 1.0;
                ret[1][1] = 1.0;
                ret[2][1] = R1;
                ret[0][2] = R2;
                ret[1][2] = R2;
                ret[2][2] = R1 * R2;
            }
        }
        return ret;
    }

    public static double[] CalcBaseRiskFrom3x3(int[][] ContArray, int[][] CaseArray, int testtype) {
        double[] ret = new double[2];
        double[] tmpAF = new double[2];
        int[][] Array = TableLike3x3x2LD.Change3x3x2To3x2(ContArray, CaseArray);
        int i = 0;
        while (i < 2) {
            if (testtype == 0) {
                tmpAF[1] = (double)(Array[i][5] * 2 + Array[i][4]) / ((double)(Array[i][3] + Array[i][4] + Array[i][5]) * 2.0);
                tmpAF[0] = (double)(Array[i][2] * 2 + Array[i][1]) / ((double)(Array[i][0] + Array[i][1] + Array[i][2]) * 2.0);
                ret[i] = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
            } else if (testtype != 1) {
                if (testtype == 2) {
                    tmpAF[1] = (double)(Array[i][5] + Array[i][4]) / (double)(Array[i][3] + Array[i][4] + Array[i][5]);
                    tmpAF[0] = (double)(Array[i][2] + Array[i][1]) / (double)(Array[i][2] + Array[i][1] + Array[i][0]);
                    ret[i] = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
                } else if (testtype == 3) {
                    tmpAF[1] = (double)Array[i][5] / (double)(Array[i][3] + Array[i][4] + Array[i][5]);
                    tmpAF[0] = (double)Array[i][2] / (double)(Array[i][2] + Array[i][1] + Array[i][0]);
                    ret[i] = tmpAF[1] / (1.0 - tmpAF[1]) * (1.0 - tmpAF[0]) / tmpAF[0];
                }
            }
            ++i;
        }
        return ret;
    }

    public static int[][] Change3x3x2To3x2(int[][] ContArray, int[][] CaseArray) {
        int[][] ret = new int[2][6];
        ret[0][0] = ContArray[0][0] + ContArray[0][1] + ContArray[0][2];
        ret[0][1] = ContArray[1][0] + ContArray[1][1] + ContArray[1][2];
        ret[0][2] = ContArray[2][0] + ContArray[2][1] + ContArray[2][2];
        ret[0][3] = CaseArray[0][0] + CaseArray[0][1] + CaseArray[0][2];
        ret[0][4] = CaseArray[1][0] + CaseArray[1][1] + CaseArray[1][2];
        ret[0][5] = CaseArray[2][0] + CaseArray[2][1] + CaseArray[2][2];
        ret[1][0] = ContArray[0][0] + ContArray[1][0] + ContArray[2][0];
        ret[1][1] = ContArray[0][1] + ContArray[1][1] + ContArray[2][1];
        ret[1][2] = ContArray[0][2] + ContArray[1][2] + ContArray[2][2];
        ret[1][3] = CaseArray[0][0] + CaseArray[1][0] + CaseArray[2][0];
        ret[1][4] = CaseArray[0][1] + CaseArray[1][1] + CaseArray[2][1];
        ret[1][5] = CaseArray[0][2] + CaseArray[1][2] + CaseArray[2][2];
        return ret;
    }
}

