/*
 * Decompiled with CFR 0.152.
 */
package HWE;

import Algorithms.MersenneTwisterFast;
import HWE.HWEExact;
import Tool.ArrayTools;
import Tool.PermTools;

public class HWETools {
    public static void main(String[] args) {
        int seed = 0;
        int x = 10000000;
        seed = (int)((double)x * Math.random());
        MersenneTwisterFast mz = new MersenneTwisterFast(seed);
        int[][] nArrayArray = new int[3][];
        int[] nArray = new int[3];
        nArray[2] = 160;
        nArrayArray[0] = nArray;
        int[] nArray2 = new int[3];
        nArray2[1] = 1;
        nArray2[2] = 230;
        nArrayArray[1] = nArray2;
        nArrayArray[2] = new int[]{1, 1, 130};
        int[][] data0_1 = nArrayArray;
        int[][] nArrayArray2 = new int[3][];
        int[] nArray3 = new int[3];
        nArray3[2] = 150;
        nArrayArray2[0] = nArray3;
        int[] nArray4 = new int[3];
        nArray4[1] = 1;
        nArray4[2] = 180;
        nArrayArray2[1] = nArray4;
        nArrayArray2[2] = new int[]{1, 1, 100};
        int[][] data0_2 = nArrayArray2;
        int[][] nArrayArray3 = new int[3][];
        int[] nArray5 = new int[3];
        nArray5[2] = 1800;
        nArrayArray3[0] = nArray5;
        int[] nArray6 = new int[3];
        nArray6[1] = 1;
        nArray6[2] = 3000;
        nArrayArray3[1] = nArray6;
        nArrayArray3[2] = new int[]{1, 1, 1200};
        int[][] data0_3 = nArrayArray3;
        int[][] nArrayArray4 = new int[6][];
        int[] nArray7 = new int[3];
        nArray7[2] = 4;
        nArrayArray4[0] = nArray7;
        int[] nArray8 = new int[3];
        nArray8[1] = 1;
        nArray8[2] = 12;
        nArrayArray4[1] = nArray8;
        int[] nArray9 = new int[3];
        nArray9[1] = 2;
        nArray9[2] = 20;
        nArrayArray4[2] = nArray9;
        nArrayArray4[3] = new int[]{1, 1, 9};
        nArrayArray4[4] = new int[]{1, 2, 30};
        nArrayArray4[5] = new int[]{2, 2, 25};
        int[][] data1_1 = nArrayArray4;
        int[][] nArrayArray5 = new int[6][];
        int[] nArray10 = new int[3];
        nArray10[2] = 40;
        nArrayArray5[0] = nArray10;
        int[] nArray11 = new int[3];
        nArray11[1] = 1;
        nArray11[2] = 120;
        nArrayArray5[1] = nArray11;
        int[] nArray12 = new int[3];
        nArray12[1] = 2;
        nArray12[2] = 200;
        nArrayArray5[2] = nArray12;
        nArrayArray5[3] = new int[]{1, 1, 90};
        nArrayArray5[4] = new int[]{1, 2, 300};
        nArrayArray5[5] = new int[]{2, 2, 250};
        int[][] data1_2 = nArrayArray5;
        int[][] nArrayArray6 = new int[6][];
        int[] nArray13 = new int[3];
        nArray13[2] = 200;
        nArrayArray6[0] = nArray13;
        int[] nArray14 = new int[3];
        nArray14[1] = 1;
        nArray14[2] = 600;
        nArrayArray6[1] = nArray14;
        int[] nArray15 = new int[3];
        nArray15[1] = 2;
        nArray15[2] = 1000;
        nArrayArray6[2] = nArray15;
        nArrayArray6[3] = new int[]{1, 1, 500};
        nArrayArray6[4] = new int[]{1, 2, 1500};
        nArrayArray6[5] = new int[]{2, 2, 1200};
        int[][] data1_3 = nArrayArray6;
        int[][] nArrayArray7 = new int[6][];
        int[] nArray16 = new int[3];
        nArray16[2] = 210;
        nArrayArray7[0] = nArray16;
        int[] nArray17 = new int[3];
        nArray17[1] = 1;
        nArray17[2] = 580;
        nArrayArray7[1] = nArray17;
        int[] nArray18 = new int[3];
        nArray18[1] = 2;
        nArray18[2] = 1010;
        nArrayArray7[2] = nArray18;
        nArrayArray7[3] = new int[]{1, 1, 500};
        nArrayArray7[4] = new int[]{1, 2, 1500};
        nArrayArray7[5] = new int[]{2, 2, 1200};
        int[][] data1_4 = nArrayArray7;
        int[][] nArrayArray8 = new int[10][];
        int[] nArray19 = new int[3];
        nArray19[2] = 10;
        nArrayArray8[0] = nArray19;
        int[] nArray20 = new int[3];
        nArray20[1] = 1;
        nArray20[2] = 40;
        nArrayArray8[1] = nArray20;
        int[] nArray21 = new int[3];
        nArray21[1] = 2;
        nArray21[2] = 60;
        nArrayArray8[2] = nArray21;
        int[] nArray22 = new int[3];
        nArray22[1] = 3;
        nArray22[2] = 80;
        nArrayArray8[3] = nArray22;
        nArrayArray8[4] = new int[]{1, 1, 40};
        nArrayArray8[5] = new int[]{1, 2, 120};
        nArrayArray8[6] = new int[]{1, 3, 160};
        nArrayArray8[7] = new int[]{2, 2, 90};
        nArrayArray8[8] = new int[]{2, 3, 240};
        nArrayArray8[9] = new int[]{3, 3, 160};
        int[][] data2_1 = nArrayArray8;
        int[][] nArrayArray9 = new int[6][];
        int[] nArray23 = new int[3];
        nArray23[2] = 1;
        nArrayArray9[0] = nArray23;
        int[] nArray24 = new int[3];
        nArray24[1] = 1;
        nArray24[2] = 3;
        nArrayArray9[1] = nArray24;
        int[] nArray25 = new int[3];
        nArray25[1] = 2;
        nArray25[2] = 1;
        nArrayArray9[2] = nArray25;
        nArrayArray9[3] = new int[]{1, 1, 1};
        int[] nArray26 = new int[3];
        nArray26[0] = 1;
        nArray26[1] = 2;
        nArrayArray9[4] = nArray26;
        nArrayArray9[5] = new int[]{2, 2, 2};
        int[][] data3_0 = nArrayArray9;
        int[][] nArrayArray10 = new int[6][];
        int[] nArray27 = new int[3];
        nArray27[2] = 4;
        nArrayArray10[0] = nArray27;
        int[] nArray28 = new int[3];
        nArray28[1] = 1;
        nArray28[2] = 30;
        nArrayArray10[1] = nArray28;
        int[] nArray29 = new int[3];
        nArray29[1] = 2;
        nArray29[2] = 25;
        nArrayArray10[2] = nArray29;
        nArrayArray10[3] = new int[]{1, 1, 9};
        nArrayArray10[4] = new int[]{1, 2, 40};
        nArrayArray10[5] = new int[]{2, 2, 20};
        int[][] data3_1 = nArrayArray10;
        double[] LogFact = ArrayTools.LogFact(2000);
        System.out.println(HWETools.HWEChifromDiplo(data3_1));
        System.out.println(HWETools.HWEPfromDiploPerm(data3_1, 500000, mz));
        System.out.println(HWEExact.ExactHWEMultiByLouis(data3_1, LogFact));
        System.out.println(HWETools.HWEPfromDiploPermExact(data3_1, 500000, mz, LogFact));
    }

    public static long[] GetCalcTime(int[][] Diplo, MersenneTwisterFast mz, boolean Louis, boolean all) {
        double[] LogFact;
        int N;
        long[] ret = new long[6];
        long startTime = System.nanoTime();
        HWETools.HWEChifromDiplo(Diplo);
        ret[0] = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        HWETools.HWEPfromDiploPerm(Diplo, 10000, mz);
        ret[1] = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        HWETools.HWEPfromDiploPerm(Diplo, 50000, mz);
        ret[2] = System.nanoTime() - startTime;
        startTime = System.nanoTime();
        HWETools.HWEPfromDiploPerm(Diplo, 100000, mz);
        ret[3] = System.nanoTime() - startTime;
        if (Louis) {
            startTime = System.nanoTime();
            N = HWEExact.SumDiplo(Diplo);
            LogFact = ArrayTools.LogFact(N * 2);
            HWEExact.ExactHWEMultiByLouis(Diplo, LogFact);
            ret[4] = System.nanoTime() - startTime;
        } else {
            ret[4] = 0L;
        }
        if (all) {
            startTime = System.nanoTime();
            N = HWEExact.SumDiplo(Diplo);
            LogFact = ArrayTools.LogFact(N * 2);
            HWEExact.ExactHWEMulti(Diplo, LogFact);
            ret[5] = System.nanoTime() - startTime;
        } else {
            ret[5] = 0L;
        }
        return ret;
    }

    public static double HWEPfromDiploPerm(int[][] Diplo, int rep, MersenneTwisterFast mz) {
        double orgChi = HWETools.HWEChifromDiplo(Diplo);
        double[] PermChi = HWETools.HWEChifromDiploPerm(Diplo, rep, mz);
        double ret = PermTools.PermP2HemiRev(orgChi, PermChi);
        return ret;
    }

    public static double HWEPfromDiploPermExact(int[][] Diplo, int rep, MersenneTwisterFast mz, double[] LogFact) {
        double orgProb = HWEExact.ExactHWEProbVariable(Diplo, LogFact);
        double[] PermProb = HWETools.HWEExactfromDiploPerm(Diplo, rep, mz, LogFact);
        double ret = PermTools.PermP2Hemi(orgProb, PermProb);
        return ret;
    }

    public static double[] HWEChifromDiploPerm(int[][] Diplo, int rep, MersenneTwisterFast mz) {
        double[] ret = new double[rep];
        int[] Sample = HWETools.ChangeDiploToSample(Diplo);
        int i = 0;
        while (i < rep) {
            Sample = PermTools.ShuffleArray1(Sample, mz);
            ret[i] = HWETools.HWEChifromSample(Sample);
            ++i;
        }
        return ret;
    }

    public static double[] HWEExactfromDiploPerm(int[][] Diplo, int rep, MersenneTwisterFast mz, double[] LogFact) {
        double[] ret = new double[rep];
        int[] Sample = HWETools.ChangeDiploToSample(Diplo);
        int i = 0;
        while (i < rep) {
            Sample = PermTools.ShuffleArray1(Sample, mz);
            int[][] tmpDiplo = HWETools.ChangeSampleToDiplo(Sample);
            ret[i] = HWEExact.ExactHWEProbVariable(tmpDiplo, LogFact);
            ++i;
        }
        return ret;
    }

    public static double HWEChifromSample(int[] Sample) {
        int[][] Diplo = HWETools.ChangeSampleToDiplo(Sample);
        double ret = HWETools.HWEChifromDiplo(Diplo);
        return ret;
    }

    public static double HWEChifromDiplo(int[][] Diplo) {
        int[][] Allele = HWETools.ChangeDiploToAllele(Diplo);
        double[][] HWEDiplo = HWETools.ChangeAlleleToHWEDiplo(Allele);
        double ret = HWETools.DiffDiplo(Diplo, HWEDiplo);
        return ret;
    }

    public static double DiffDiplo(int[][] Diplo, double[][] HWEDiplo) {
        double ret = 0.0;
        int kdip = Diplo.length;
        int i = 0;
        while (i < kdip) {
            ret += Math.pow((double)Diplo[i][2] - HWEDiplo[i][2], 2.0) / HWEDiplo[i][2];
            ++i;
        }
        return ret;
    }

    public static double[][] ChangeAlleleToHWEDiplo(int[][] Array) {
        int k = Array.length;
        int kdip = k * (k + 1) / 2;
        int N = 0;
        int count1 = 0;
        int count2 = 0;
        double[] Freq = new double[k];
        double[][] ret = new double[kdip][3];
        int i = 0;
        while (i < k) {
            N += Array[i][1];
            ++i;
        }
        i = 0;
        while (i < k) {
            Freq[i] = (double)Array[i][1] / (double)(N * 2);
            ++i;
        }
        i = 0;
        while (i < kdip) {
            ret[i][2] = 0.0;
            ret[i][0] = count1;
            ret[i][1] = count2;
            if (++count2 == k) {
                count2 = ++count1;
            }
            ++i;
        }
        i = 0;
        while (i < kdip) {
            ret[i][2] = ret[i][0] == ret[i][1] ? Math.pow(Freq[(int)ret[i][0]], 2.0) : 2.0 * Freq[(int)ret[i][0]] * Freq[(int)ret[i][1]];
            double[] dArray = ret[i];
            dArray[2] = dArray[2] * (double)(N * 2);
            ++i;
        }
        return ret;
    }

    public static int[][] ChangeDiploToAllele(int[][] Array) {
        int kdip = Array.length;
        int k = (int)Math.floor(Math.sqrt(kdip * 2));
        int[][] ret = new int[k][2];
        int i = 0;
        while (i < ret.length) {
            ret[i][0] = i;
            ret[i][1] = 0;
            ++i;
        }
        i = 0;
        while (i < Array.length) {
            int[] nArray = ret[Array[i][0]];
            nArray[1] = nArray[1] + Array[i][2];
            int[] nArray2 = ret[Array[i][1]];
            nArray2[1] = nArray2[1] + Array[i][2];
            ++i;
        }
        return ret;
    }

    public static int[] ChangeDiploToSample(int[][] Array) {
        int N = 0;
        int counter = 0;
        int i = 0;
        while (i < Array.length) {
            N += Array[i][2];
            ++i;
        }
        int[] ret = new int[N *= 2];
        int i2 = 0;
        while (i2 < Array.length) {
            int j = 0;
            while (j < Array[i2][2]) {
                ret[counter] = Array[i2][0];
                ret[counter + 1] = Array[i2][1];
                counter += 2;
                ++j;
            }
            ++i2;
        }
        return ret;
    }

    public static int[][] ChangeSampleToDiplo(int[] Array) {
        int k = -99;
        int count1 = 0;
        int count2 = 0;
        int i = 0;
        while (i < Array.length) {
            if (Array[i] > k) {
                k = Array[i];
            }
            ++i;
        }
        int kdip = (k + 1) * (k + 2) / 2;
        int[][] ret = new int[kdip][3];
        int i2 = 0;
        while (i2 < kdip) {
            ret[i2][2] = 0;
            ret[i2][0] = count1++;
            ret[i2][1] = count2++;
            if (count2 == k + 1) {
                count2 = count1;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < Array.length) {
            int x = Math.min(Array[i2], Array[i2 + 1]);
            int y = Math.max(Array[i2], Array[i2 + 1]);
            int ord = (k + 1) * x - x * (x - 1) / 2 + y - x;
            int[] nArray = ret[ord];
            nArray[2] = nArray[2] + 1;
            i2 += 2;
        }
        return ret;
    }
}

