/*
 * Decompiled with CFR 0.152.
 */
package Applets;

import Tool.FileTools;
import Tool.PlotTools;
import java.awt.Color;
import java.awt.Graphics;
import javax.swing.JPanel;

class DrawGridsBasicPanel
extends JPanel {
    String inputfile = "SampleGrids.txt";
    String Parameterfile = "SampleGrids_para.txt";
    int R = 0;
    int G = 0;
    int B = 0;
    Color color = new Color(this.R, this.G, this.B);
    int space = 25;
    int block = 400;
    int baseX = this.space;
    int baseY = this.space;
    double[] Xax = new double[]{-10.0, 10.0};
    double[] Yax = new double[]{-10.0, 10.0};
    boolean ParaPlot = true;

    DrawGridsBasicPanel() {
    }

    @Override
    public void paintComponent(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(this.baseX - 1, this.baseY - 1, this.block + 1, this.block + 1);
        try {
            double[][] value = FileTools.readDatFileIOStringTAB(this.inputfile);
            int Xgrids = value.length;
            int Ygrids = value[0].length;
            int Xkizami = this.block / Xgrids;
            int Ykizami = this.block / Ygrids;
            int x = this.baseX;
            int y = this.baseY;
            double[] range = new double[]{9.9999999E7, -9.9999999E7};
            int i = 0;
            while (i < Xgrids) {
                int j = 0;
                while (j < Ygrids) {
                    if (value[i][j] <= range[0]) {
                        range[0] = value[i][j];
                    } else if (value[i][j] >= range[1]) {
                        range[1] = value[i][j];
                    }
                    ++j;
                }
                ++i;
            }
            double length = range[1] - range[0];
            int i2 = 0;
            while (i2 < Xgrids) {
                int j = 0;
                while (j < Ygrids) {
                    this.R = DrawGridsBasicPanel.setColor(range[0], range[1], value[i2][j])[0];
                    this.G = DrawGridsBasicPanel.setColor(range[0], range[1], value[i2][j])[1];
                    this.B = DrawGridsBasicPanel.setColor(range[0], range[1], value[i2][j])[2];
                    this.color = new Color(this.R, this.G, this.B);
                    g.setColor(this.color);
                    g.fillRect(x, y, Xkizami, Ykizami);
                    x += Xkizami;
                    ++j;
                }
                x = this.baseX;
                y += Ykizami;
                ++i2;
            }
            if (this.ParaPlot) {
                double[][] Para = FileTools.readDatFileIOStringTAB(this.Parameterfile);
                g.setColor(Color.black);
                this.DrawAxis(Para, g);
            }
            this.DrawBar(range[0], range[1], this.baseX, this.baseY + this.block + this.space, this.block, this.space, g);
            g.setColor(Color.black);
            g.drawRect(this.baseX - 1, this.baseY + this.block + this.space - 1, this.block + 1, this.space + 1);
            g.drawString(String.valueOf(PlotTools.DecimalHU(range[0], 1)), this.baseX - this.space / 4, this.baseY + this.space + this.block - this.space / 5);
            g.drawString(String.valueOf(PlotTools.DecimalHU(range[1], 1)), this.baseX + this.block - this.space / 4, this.baseY + this.space + this.block - this.space / 5);
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    public void DrawAxis(double[][] Para, Graphics g) {
        int rep = Para.length;
        int i = 0;
        while (i < rep) {
            if (Para[i][0] == 1.0) {
                this.Xax[0] = Para[i][1];
                this.Xax[1] = Para[i][2];
            }
            if (Para[i][0] == 2.0) {
                this.Yax[0] = Para[i][1];
                this.Yax[1] = Para[i][2];
            }
            ++i;
        }
        int kiz = 2;
        int i2 = 0;
        while (i2 < rep) {
            if (Para[i2][0] == 3.0) {
                g.fillOval(this.ScaleChange(Para[i2][1], Para[i2][2])[0] - kiz, this.ScaleChange(Para[i2][1], Para[i2][2])[1] - kiz, kiz * 2 + 1, kiz * 2 + 1);
            }
            if (Para[i2][0] == 4.0) {
                g.drawLine(this.ScaleChange(Para[i2][1], Para[i2][2])[0], this.ScaleChange(this.Xax[0], this.Yax[0])[1], this.ScaleChange(Para[i2][1], Para[i2][2])[0], this.ScaleChange(this.Xax[1], this.Yax[1])[1]);
            }
            if (Para[i2][0] == 5.0) {
                g.drawLine(this.ScaleChange(this.Xax[0], this.Yax[0])[0], this.ScaleChange(Para[i2][1], Para[i2][2])[1], this.ScaleChange(this.Xax[1], this.Yax[1])[0], this.ScaleChange(Para[i2][1], Para[i2][2])[1]);
            }
            if (Para[i2][0] == 6.0) {
                g.drawLine(this.ScaleChange(Para[i2][1], Para[i2][2])[0], this.ScaleChange(Para[i2][1], Para[i2][2])[1] - kiz, this.ScaleChange(Para[i2][1], Para[i2][2])[0], this.ScaleChange(Para[i2][1], Para[i2][2])[1] + kiz);
            }
            if (Para[i2][0] == 7.0) {
                g.drawLine(this.ScaleChange(Para[i2][1], Para[i2][2])[0] - kiz, this.ScaleChange(Para[i2][1], Para[i2][2])[1], this.ScaleChange(Para[i2][1], Para[i2][2])[0] + kiz, this.ScaleChange(Para[i2][1], Para[i2][2])[1]);
            }
            ++i2;
        }
    }

    public int[] ScaleChange(double x, double y) {
        int[] ret = new int[]{(int)((x - this.Xax[0]) / (this.Xax[1] - this.Xax[0]) * (double)this.block + (double)this.baseX), (int)((y - this.Yax[0]) / (this.Yax[1] - this.Yax[0]) * (double)this.block + (double)this.baseY)};
        return ret;
    }

    public static int[] setColor(double range0, double range1, double value) {
        int[] ret = new int[]{(int)Math.max(Math.min((value - range0) / (range1 - range0) * 255.0 * 4.0 - 510.0, 255.0), 0.0), (int)Math.max(Math.min(Math.min((value - range0) / (range1 - range0) * 255.0 * 4.0, (value - range0) / (range1 - range0) * -255.0 * 4.0 + 1020.0), 255.0), 0.0), (int)Math.max(Math.min((value - range0) / (range1 - range0) * 255.0 * -4.0 + 510.0, 255.0), 0.0)};
        return ret;
    }

    public void DrawBar(double range0, double range1, int baseX, int baseY, int len, int dep, Graphics g) {
        int rep = 100;
        double kizami = (double)len / (double)rep;
        int i = 0;
        while (i < rep) {
            int[] tmp = DrawGridsBasicPanel.setColor(range0, range1, (range1 - range0) * (double)i / (double)(rep - 1) + range0);
            int R = tmp[0];
            int G = tmp[1];
            int B = tmp[2];
            this.color = new Color(R, G, B);
            g.setColor(this.color);
            g.fillRect((int)((double)baseX + kizami * (double)i), baseY, (int)kizami + 1, dep);
            ++i;
        }
    }
}

